/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.Frequency;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedHashMap;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class FusiformSimilarityTraverser
extends HugeTraverser {
    private long accessed = 0L;

    public FusiformSimilarityTraverser(HugeGraph graph) {
        super(graph);
    }

    public SimilarsMap fusiformSimilarity(Iterator<Vertex> vertices, Directions direction, String label, int minNeighbors, double alpha, int minSimilars, int top, String groupProperty, int minGroups, long degree, long capacity, long limit, boolean withIntermediary) {
        FusiformSimilarityTraverser.checkCapacity(capacity);
        FusiformSimilarityTraverser.checkLimit(limit);
        FusiformSimilarityTraverser.checkGroupArgs(groupProperty, minGroups);
        int foundCount = 0;
        SimilarsMap results = new SimilarsMap();
        while (vertices.hasNext()) {
            FusiformSimilarityTraverser.checkCapacity(capacity, ++this.accessed, "fusiform similarity");
            HugeVertex vertex = (HugeVertex)vertices.next();
            Set<Similar> result = this.fusiformSimilarityForVertex(vertex, direction, label, minNeighbors, alpha, minSimilars, top, groupProperty, minGroups, degree, capacity, withIntermediary);
            if (result.isEmpty()) continue;
            results.put(vertex.id(), result);
            if (limit == -1L || (long)(++foundCount) < limit) continue;
            break;
        }
        this.reset();
        return results;
    }

    private Set<Similar> fusiformSimilarityForVertex(HugeVertex vertex, Directions direction, String label, int minNeighbors, double alpha, int minSimilars, int top, String groupProperty, int minGroups, long degree, long capacity, boolean withIntermediary) {
        boolean matched = this.matchMinNeighborCount(vertex, direction, label, minNeighbors, degree);
        if (!matched) {
            return ImmutableSet.of();
        }
        Id labelId = this.getEdgeLabelId(label);
        Iterator<Edge> edges = this.edgesOfVertex(vertex.id(), direction, labelId, degree);
        HashMap<Id, MutableInt> similars = new HashMap<Id, MutableInt>();
        MultivaluedHashMap intermediaries = new MultivaluedHashMap();
        HashSet<Id> neighbors = new HashSet<Id>();
        while (edges.hasNext()) {
            Id target = ((HugeEdge)edges.next()).id().otherVertexId();
            if (neighbors.contains(target)) continue;
            neighbors.add(target);
            FusiformSimilarityTraverser.checkCapacity(capacity, ++this.accessed, "fusiform similarity");
            Directions backDir = direction.opposite();
            Iterator<Edge> backEdges = this.edgesOfVertex(target, backDir, labelId, degree);
            HashSet currentSimilars = new HashSet();
            while (backEdges.hasNext()) {
                MutableInt count;
                Id node = ((HugeEdge)backEdges.next()).id().otherVertexId();
                if (currentSimilars.contains(node)) continue;
                currentSimilars.add(node);
                if (withIntermediary) {
                    intermediaries.add((Object)node, (Object)target);
                }
                if ((count = (MutableInt)similars.get(node)) == null) {
                    count = new MutableInt(0);
                    similars.put(node, count);
                    FusiformSimilarityTraverser.checkCapacity(capacity, ++this.accessed, "fusiform similarity");
                }
                count.increment();
            }
        }
        assert (similars.containsKey(vertex.id()));
        similars.remove(vertex.id());
        if (similars.isEmpty()) {
            return ImmutableSet.of();
        }
        double neighborNum = neighbors.size();
        HashMap matchedAlpha = new HashMap();
        for (Map.Entry entry : similars.entrySet()) {
            double score = (double)((MutableInt)entry.getValue()).intValue() / neighborNum;
            if (!(score >= alpha)) continue;
            matchedAlpha.put(entry.getKey(), score);
        }
        if (matchedAlpha.size() < minSimilars) {
            return ImmutableSet.of();
        }
        Map topN = top > 0 ? FusiformSimilarityTraverser.topN(matchedAlpha, true, top) : matchedAlpha;
        if (groupProperty != null) {
            HashSet<Object> values = new HashSet<Object>();
            values.add(vertex.value(groupProperty));
            for (Id id : topN.keySet()) {
                Vertex v = this.graph().vertices(id).next();
                values.add(v.value(groupProperty));
            }
            if (values.size() < minGroups) {
                return ImmutableSet.of();
            }
        }
        Set result = InsertionOrderUtil.newSet();
        for (Map.Entry entry : topN.entrySet()) {
            Id similar = (Id)entry.getKey();
            double score = (Double)entry.getValue();
            ImmutableList inters = withIntermediary ? (List)intermediaries.get((Object)similar) : ImmutableList.of();
            result.add(new Similar(similar, score, (List<Id>)inters));
        }
        return result;
    }

    private static void checkGroupArgs(String groupProperty, int minGroups) {
        if (groupProperty == null) {
            E.checkArgument((minGroups == 0 ? 1 : 0) != 0, (String)"Can't set min group count when group property not set", (Object[])new Object[0]);
        } else {
            E.checkArgument((!groupProperty.isEmpty() ? 1 : 0) != 0, (String)"The group property can't be empty", (Object[])new Object[0]);
            E.checkArgument((minGroups > 0 ? 1 : 0) != 0, (String)"Must set min group count when group property set", (Object[])new Object[0]);
        }
    }

    private boolean matchMinNeighborCount(HugeVertex vertex, Directions direction, String label, int minNeighbors, long degree) {
        long neighborCount;
        EdgeLabel edgeLabel = null;
        Id labelId = null;
        if (label != null) {
            edgeLabel = this.graph().edgeLabel(label);
            labelId = edgeLabel.id();
        }
        if (edgeLabel != null && edgeLabel.frequency() == Frequency.SINGLE) {
            Iterator<Edge> edges = this.edgesOfVertex(vertex.id(), direction, labelId, (long)minNeighbors);
            neighborCount = IteratorUtils.count(edges);
        } else {
            Iterator<Edge> edges = this.edgesOfVertex(vertex.id(), direction, labelId, degree);
            HashSet<Id> neighbors = new HashSet<Id>();
            while (edges.hasNext()) {
                Id target = ((HugeEdge)edges.next()).id().otherVertexId();
                neighbors.add(target);
                if (neighbors.size() < minNeighbors) continue;
                break;
            }
            neighborCount = neighbors.size();
        }
        return neighborCount >= (long)minNeighbors;
    }

    private void reset() {
        this.accessed = 0L;
    }

    public static class SimilarsMap
    extends HashMap<Id, Set<Similar>> {
        private static final long serialVersionUID = -1906770930513268291L;

        public Set<Id> vertices() {
            HashSet<Id> vertices = new HashSet<Id>();
            vertices.addAll(this.keySet());
            for (Set similars : this.values()) {
                for (Similar similar : similars) {
                    vertices.add(similar.id());
                    vertices.addAll(similar.intermediaries());
                }
            }
            return vertices;
        }

        public Map<Id, Set<Map<String, Object>>> toMap() {
            HashMap<Id, Set<Map<String, Object>>> results = new HashMap<Id, Set<Map<String, Object>>>();
            for (Map.Entry entry : this.entrySet()) {
                Id source = (Id)entry.getKey();
                Set similars = (Set)entry.getValue();
                Set result = InsertionOrderUtil.newSet();
                for (Similar similar : similars) {
                    result.add(similar.toMap());
                }
                results.put(source, result);
            }
            return results;
        }
    }

    public static class Similar {
        private final Id id;
        private final double score;
        private final List<Id> intermediaries;

        public Similar(Id id, double score, List<Id> intermediaries) {
            this.id = id;
            this.score = score;
            assert (new HashSet<Id>(intermediaries).size() == intermediaries.size()) : "Invalid intermediaries";
            this.intermediaries = intermediaries;
        }

        public Id id() {
            return this.id;
        }

        public double score() {
            return this.score;
        }

        public List<Id> intermediaries() {
            return this.intermediaries;
        }

        public Map<String, Object> toMap() {
            return ImmutableMap.of((Object)"id", (Object)this.id, (Object)"score", (Object)this.score, (Object)"intermediaries", this.intermediaries);
        }
    }
}

