/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Aggregate;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.iterator.ExtendableIterator;
import com.baidu.hugegraph.iterator.FilterIterator;
import com.baidu.hugegraph.iterator.MapperIterator;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.traversal.algorithm.steps.EdgeStep;
import com.baidu.hugegraph.traversal.optimize.TraversalUtil;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class HugeTraverser {
    private HugeGraph graph;
    public static final String DEFAULT_CAPACITY = "10000000";
    public static final String DEFAULT_ELEMENTS_LIMIT = "10000000";
    public static final String DEFAULT_PATHS_LIMIT = "10";
    public static final String DEFAULT_LIMIT = "100";
    public static final String DEFAULT_DEGREE = "10000";
    public static final String DEFAULT_SKIP_DEGREE = "100000";
    public static final String DEFAULT_SAMPLE = "100";
    public static final String DEFAULT_MAX_DEPTH = "50";
    public static final String DEFAULT_WEIGHT = "0";
    protected static final int MAX_VERTICES = 10;
    public static final String DEFAULT_PAGE_LIMIT = "100000";
    public static final long NO_LIMIT = -1L;

    public HugeTraverser(HugeGraph graph) {
        this.graph = graph;
    }

    public HugeGraph graph() {
        return this.graph;
    }

    protected int concurrentDepth() {
        return (Integer)this.config().get(CoreOptions.OLTP_CONCURRENT_DEPTH);
    }

    protected HugeConfig config() {
        return (HugeConfig)this.graph().hugegraph().configuration();
    }

    protected Set<Id> adjacentVertices(Set<Id> vertices, Directions dir, Id label, Set<Id> excluded, long degree, long limit) {
        if (limit == 0L) {
            return ImmutableSet.of();
        }
        Set<Id> neighbors = HugeTraverser.newSet();
        for (Id source : vertices) {
            Iterator<Edge> edges = this.edgesOfVertex(source, dir, label, degree);
            while (edges.hasNext()) {
                HugeEdge e = (HugeEdge)edges.next();
                Id target = e.id().otherVertexId();
                if (excluded != null && excluded.contains(target)) continue;
                neighbors.add(target);
                if (limit == -1L || (long)neighbors.size() < limit) continue;
                return neighbors;
            }
        }
        return neighbors;
    }

    protected Iterator<Id> adjacentVertices(Id source, Directions dir, Id label, long limit) {
        Iterator<Edge> edges = this.edgesOfVertex(source, dir, label, limit);
        return new MapperIterator(edges, e -> {
            HugeEdge edge = (HugeEdge)e;
            return edge.id().otherVertexId();
        });
    }

    protected Set<Id> adjacentVertices(Id source, EdgeStep step) {
        HashSet<Id> neighbors = new HashSet<Id>();
        Iterator<Edge> edges = this.edgesOfVertex(source, step);
        while (edges.hasNext()) {
            neighbors.add(((HugeEdge)edges.next()).id().otherVertexId());
        }
        return neighbors;
    }

    protected Set<Node> adjacentVertices(Set<Node> vertices, EdgeStep step, Set<Node> excluded, long remaining) {
        Set<Node> neighbors = HugeTraverser.newSet();
        for (Node source : vertices) {
            Iterator<Edge> edges = this.edgesOfVertex(source.id(), step);
            while (edges.hasNext()) {
                Id target = ((HugeEdge)edges.next()).id().otherVertexId();
                KNode kNode = new KNode(target, (KNode)source);
                if (excluded != null && excluded.contains(kNode)) continue;
                neighbors.add(kNode);
                if (remaining == -1L || --remaining > 0L) continue;
                return neighbors;
            }
        }
        return neighbors;
    }

    protected Iterator<Edge> edgesOfVertex(Id source, Directions dir, Id label, long limit) {
        Id[] labels = new Id[]{};
        if (label != null) {
            labels = new Id[]{label};
        }
        ConditionQuery query = GraphTransaction.constructEdgesQuery(source, dir, labels);
        if (limit != -1L) {
            query.limit(limit);
        }
        return this.graph.edges(query);
    }

    protected Iterator<Edge> edgesOfVertex(Id source, Directions dir, Map<Id, String> labels, long limit) {
        if (labels == null || labels.isEmpty()) {
            return this.edgesOfVertex(source, dir, (Id)null, limit);
        }
        ExtendableIterator results = new ExtendableIterator();
        for (Id label : labels.keySet()) {
            E.checkNotNull((Object)label, (String)"edge label");
            results.extend(this.edgesOfVertex(source, dir, label, limit));
        }
        return results;
    }

    protected Iterator<Edge> edgesOfVertex(Id source, EdgeStep edgeStep) {
        if (edgeStep.properties() == null || edgeStep.properties().isEmpty()) {
            Iterator<Edge> edges = this.edgesOfVertex(source, edgeStep.direction(), edgeStep.labels(), edgeStep.limit());
            return edgeStep.skipSuperNodeIfNeeded(edges);
        }
        return this.edgesOfVertex(source, edgeStep, false);
    }

    protected Iterator<Edge> edgesOfVertexWithSK(Id source, EdgeStep edgeStep) {
        assert (edgeStep.properties() != null && !edgeStep.properties().isEmpty());
        return this.edgesOfVertex(source, edgeStep, true);
    }

    private Iterator<Edge> edgesOfVertex(Id source, EdgeStep edgeStep, boolean mustAllSK) {
        Id[] edgeLabels = edgeStep.edgeLabels();
        ConditionQuery query = GraphTransaction.constructEdgesQuery(source, edgeStep.direction(), edgeLabels);
        ConditionQuery filter = null;
        if (mustAllSK) {
            this.fillFilterBySortKeys(query, edgeLabels, edgeStep.properties());
        } else {
            filter = (ConditionQuery)((Query)query).copy();
            this.fillFilterByProperties(filter, edgeStep.properties());
        }
        query.capacity(-1L);
        if (edgeStep.limit() != -1L) {
            query.limit(edgeStep.limit());
        }
        FilterIterator edges = this.graph().edges(query);
        if (filter != null) {
            ConditionQuery finalFilter = filter;
            edges = new FilterIterator(edges, e -> finalFilter.test((HugeEdge)e));
        }
        return edgeStep.skipSuperNodeIfNeeded((Iterator<Edge>)edges);
    }

    private void fillFilterBySortKeys(Query query, Id[] edgeLabels, Map<Id, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        E.checkArgument((edgeLabels.length == 1 ? 1 : 0) != 0, (String)"The properties filter condition can be set only if just set one edge label", (Object[])new Object[0]);
        this.fillFilterByProperties(query, properties);
        ConditionQuery condQuery = (ConditionQuery)query;
        if (!GraphTransaction.matchFullEdgeSortKeys(condQuery, this.graph())) {
            Id label = (Id)condQuery.condition((Object)HugeKeys.LABEL);
            E.checkArgument((boolean)false, (String)"The properties %s does not match sort keys of edge label '%s'", (Object[])new Object[]{this.graph().mapPkId2Name(properties.keySet()), this.graph().edgeLabel(label).name()});
        }
    }

    private void fillFilterByProperties(Query query, Map<Id, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        ConditionQuery condQuery = (ConditionQuery)query;
        TraversalUtil.fillConditionQuery(condQuery, properties, this.graph);
    }

    protected long edgesCount(Id source, EdgeStep edgeStep) {
        Id[] edgeLabels = edgeStep.edgeLabels();
        ConditionQuery query = GraphTransaction.constructEdgesQuery(source, edgeStep.direction(), edgeLabels);
        this.fillFilterBySortKeys(query, edgeLabels, edgeStep.properties());
        query.aggregate(Aggregate.AggregateFunc.COUNT, null);
        query.capacity(-1L);
        query.limit(Long.MAX_VALUE);
        long count = this.graph().queryNumber(query).longValue();
        if (edgeStep.degree() == -1L || count < edgeStep.degree()) {
            return count;
        }
        if (edgeStep.skipDegree() != 0L && count >= edgeStep.skipDegree()) {
            return 0L;
        }
        return edgeStep.degree();
    }

    protected Object getVertexLabelId(Object label) {
        if (label == null) {
            return null;
        }
        return SchemaLabel.getLabelId(this.graph, HugeType.VERTEX, label);
    }

    protected Id getEdgeLabelId(Object label) {
        if (label == null) {
            return null;
        }
        return SchemaLabel.getLabelId(this.graph, HugeType.EDGE, label);
    }

    protected void checkVertexExist(Id vertexId, String name) {
        try {
            this.graph.vertex(vertexId);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException(String.format("The %s with id '%s' does not exist", name, vertexId), e);
        }
    }

    public static void checkDegree(long degree) {
        HugeTraverser.checkPositiveOrNoLimit(degree, "max degree");
    }

    public static void checkCapacity(long capacity) {
        HugeTraverser.checkPositiveOrNoLimit(capacity, "capacity");
    }

    public static void checkLimit(long limit) {
        HugeTraverser.checkPositiveOrNoLimit(limit, "limit");
    }

    public static void checkPositive(long value, String name) {
        E.checkArgument((value > 0L ? 1 : 0) != 0, (String)"The %s parameter must be > 0, but got %s", (Object[])new Object[]{name, value});
    }

    public static void checkPositiveOrNoLimit(long value, String name) {
        E.checkArgument((value > 0L || value == -1L ? 1 : 0) != 0, (String)"The %s parameter must be > 0 or == %s, but got: %s", (Object[])new Object[]{name, -1L, value});
    }

    public static void checkNonNegative(long value, String name) {
        E.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"The %s parameter must be >= 0, but got: %s", (Object[])new Object[]{name, value});
    }

    public static void checkNonNegativeOrNoLimit(long value, String name) {
        E.checkArgument((value >= 0L || value == -1L ? 1 : 0) != 0, (String)"The %s parameter must be >= 0 or == %s, but got: %s", (Object[])new Object[]{name, -1L, value});
    }

    public static void checkCapacity(long capacity, long access, String traverse) {
        if (capacity != -1L && access > capacity) {
            throw new HugeException("Exceed capacity '%s' while finding %s", capacity, traverse);
        }
    }

    public static void checkSkipDegree(long skipDegree, long degree, long capacity) {
        E.checkArgument((skipDegree >= 0L && skipDegree <= 800000L ? 1 : 0) != 0, (String)"The skipped degree must be in [0, %s], but got '%s'", (Object[])new Object[]{800000L, skipDegree});
        if (capacity != -1L) {
            E.checkArgument((degree != -1L && degree < capacity ? 1 : 0) != 0, (String)"The degree must be < capacity", (Object[])new Object[0]);
            E.checkArgument((skipDegree < capacity ? 1 : 0) != 0, (String)"The skipped degree must be < capacity", (Object[])new Object[0]);
        }
        if (skipDegree > 0L) {
            E.checkArgument((degree != -1L && skipDegree >= degree ? 1 : 0) != 0, (String)"The skipped degree must be >= degree, but got skipped degree '%s' and degree '%s'", (Object[])new Object[]{skipDegree, degree});
        }
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> topN(Map<K, V> map, boolean sorted, long limit) {
        if (sorted) {
            map = CollectionUtil.sortByValue(map, (boolean)false);
        }
        if (limit == -1L || (long)map.size() <= limit) {
            return map;
        }
        Map results = InsertionOrderUtil.newMap();
        long count = 0L;
        for (Map.Entry entry : map.entrySet()) {
            results.put(entry.getKey(), entry.getValue());
            if (++count < limit) continue;
            break;
        }
        return results;
    }

    public static Iterator<Edge> skipSuperNodeIfNeeded(Iterator<Edge> edges, long degree, long skipDegree) {
        if (skipDegree <= 0L) {
            return edges;
        }
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        int i = 1;
        while (edges.hasNext()) {
            Edge edge = edges.next();
            if ((long)i <= degree) {
                edgeList.add(edge);
            }
            if ((long)i >= skipDegree) {
                return QueryResults.emptyIterator();
            }
            ++i;
        }
        return edgeList.iterator();
    }

    protected static <V> Set<V> newSet() {
        return HugeTraverser.newSet(false);
    }

    protected static <V> Set<V> newSet(boolean concurrent) {
        if (concurrent) {
            return ConcurrentHashMap.newKeySet();
        }
        return new HashSet();
    }

    protected static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    protected static <K, V> MultivaluedMap<K, V> newMultivalueMap() {
        return new MultivaluedHashMap();
    }

    protected static List<Id> joinPath(Node prev, Node back, boolean ring) {
        List<Id> path = prev.path();
        List<Id> backPath = back.path();
        Collections.reverse(backPath);
        if (!ring && CollectionUtils.containsAny(path, backPath)) {
            return ImmutableList.of();
        }
        path.addAll(backPath);
        return path;
    }

    public static class PathSet
    extends HashSet<Path> {
        private static final long serialVersionUID = -8237531948776524872L;

        public Set<Id> vertices() {
            HashSet<Id> vertices = new HashSet<Id>();
            for (Path path : this) {
                vertices.addAll(path.vertices());
            }
            return vertices;
        }
    }

    public static class Path {
        public static final Path EMPTY_PATH = new Path((List<Id>)ImmutableList.of());
        private Id crosspoint;
        private List<Id> vertices;

        public Path(List<Id> vertices) {
            this(null, vertices);
        }

        public Path(Id crosspoint, List<Id> vertices) {
            this.crosspoint = crosspoint;
            this.vertices = vertices;
        }

        public Id crosspoint() {
            return this.crosspoint;
        }

        public List<Id> vertices() {
            return this.vertices;
        }

        public void reverse() {
            Collections.reverse(this.vertices);
        }

        public Map<String, Object> toMap(boolean withCrossPoint) {
            if (withCrossPoint) {
                return ImmutableMap.of((Object)"crosspoint", (Object)this.crosspoint, (Object)"objects", this.vertices);
            }
            return ImmutableMap.of((Object)"objects", this.vertices);
        }

        public boolean ownedBy(Id source) {
            E.checkNotNull((Object)source, (String)"source");
            Id min = null;
            for (Id id : this.vertices) {
                if (min != null && id.compareTo(min) >= 0) continue;
                min = id;
            }
            return source.equals(min);
        }

        public int hashCode() {
            return this.vertices.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Path)) {
                return false;
            }
            return this.vertices.equals(((Path)other).vertices);
        }
    }

    public static class KNode
    extends Node {
        public KNode(Id id, KNode parent) {
            super(id, parent);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof KNode)) {
                return false;
            }
            KNode other = (KNode)object;
            return Objects.equals(this.id(), other.id());
        }
    }

    public static class Node {
        private Id id;
        private Node parent;

        public Node(Id id) {
            this(id, null);
        }

        public Node(Id id, Node parent) {
            E.checkArgumentNotNull((Object)id, (String)"Id of Node can't be null", (Object[])new Object[0]);
            this.id = id;
            this.parent = parent;
        }

        public Id id() {
            return this.id;
        }

        public Node parent() {
            return this.parent;
        }

        public List<Id> path() {
            ArrayList<Id> ids = new ArrayList<Id>();
            Node current = this;
            do {
                ids.add(current.id);
            } while ((current = current.parent) != null);
            Collections.reverse(ids);
            return ids;
        }

        public List<Id> joinPath(Node back) {
            return HugeTraverser.joinPath(this, back, false);
        }

        public boolean contains(Id id) {
            Node node = this;
            do {
                if (!node.id.equals(id)) continue;
                return true;
            } while ((node = node.parent) != null);
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Node)) {
                return false;
            }
            Node other = (Node)object;
            return Objects.equals(this.id, other.id) && Objects.equals(this.parent, other.parent);
        }

        public String toString() {
            return this.id.toString();
        }
    }
}

