/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.traversal.algorithm.OltpTraverser;
import com.baidu.hugegraph.traversal.algorithm.steps.EdgeStep;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class JaccardSimilarTraverser
extends OltpTraverser {
    public JaccardSimilarTraverser(HugeGraph graph) {
        super(graph);
    }

    public double jaccardSimilarity(Id vertex, Id other, Directions dir, String label, long degree) {
        E.checkNotNull((Object)vertex, (String)"vertex id");
        E.checkNotNull((Object)other, (String)"the other vertex id");
        this.checkVertexExist(vertex, "vertex");
        this.checkVertexExist(other, "other vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        JaccardSimilarTraverser.checkDegree(degree);
        Id labelId = this.getEdgeLabelId(label);
        Set sourceNeighbors = IteratorUtils.set(this.adjacentVertices(vertex, dir, labelId, degree));
        Set targetNeighbors = IteratorUtils.set(this.adjacentVertices(other, dir, labelId, degree));
        return this.jaccardSimilarity(sourceNeighbors, targetNeighbors);
    }

    public double jaccardSimilarity(Set<Id> set1, Set<Id> set2) {
        int interNum = CollectionUtil.intersect(set1, set2).size();
        int unionNum = CollectionUtil.union(set1, set2).size();
        return (double)interNum / (double)unionNum;
    }

    public Map<Id, Double> jaccardSimilars(Id source, EdgeStep step, int top, long capacity) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        JaccardSimilarTraverser.checkCapacity(capacity);
        Map<Id, Double> results = 3 >= this.concurrentDepth() && step.direction() == Directions.BOTH ? this.jaccardSimilarsConcurrent(source, step, capacity) : this.jaccardSimilarsSingle(source, step, capacity);
        if (top > 0) {
            results = HugeTraverser.topN(results, true, top);
        }
        return results;
    }

    public Map<Id, Double> jaccardSimilarsConcurrent(Id source, EdgeStep step, long capacity) {
        AtomicLong count = new AtomicLong(0L);
        ConcurrentHashMap.KeySetView accessed = ConcurrentHashMap.newKeySet();
        accessed.add(source);
        JaccardSimilarTraverser.reachCapacity(count.incrementAndGet(), capacity);
        Set<Id> layer1s = this.adjacentVertices(source, step);
        JaccardSimilarTraverser.reachCapacity(count.get() + (long)layer1s.size(), capacity);
        count.addAndGet(layer1s.size());
        if (layer1s.isEmpty()) {
            return ImmutableMap.of();
        }
        ConcurrentHashMap<Id, Double> results = new ConcurrentHashMap<Id, Double>();
        ConcurrentHashMap.KeySetView layer2All = ConcurrentHashMap.newKeySet();
        this.traverseIds(layer1s.iterator(), id -> {
            if (accessed.contains(id)) {
                return;
            }
            Set<Id> layer2s = this.adjacentVertices((Id)id, step);
            if (layer2s.isEmpty()) {
                results.put((Id)id, 0.0);
            }
            layer2All.addAll(layer2s);
            JaccardSimilarTraverser.reachCapacity(count.get() + (long)layer2All.size(), capacity);
            double jaccardSimilarity = this.jaccardSimilarity(layer1s, layer2s);
            results.put((Id)id, jaccardSimilarity);
            accessed.add(id);
        });
        count.addAndGet(layer2All.size());
        this.traverseIds(layer2All.iterator(), id -> {
            if (accessed.contains(id)) {
                return;
            }
            Set<Id> layer3s = this.adjacentVertices((Id)id, step);
            JaccardSimilarTraverser.reachCapacity(count.get() + (long)layer3s.size(), capacity);
            if (layer3s.isEmpty()) {
                results.put((Id)id, 0.0);
            }
            double jaccardSimilarity = this.jaccardSimilarity(layer1s, layer3s);
            results.put((Id)id, jaccardSimilarity);
            accessed.add(id);
        });
        return results;
    }

    public Map<Id, Double> jaccardSimilarsSingle(Id source, EdgeStep step, long capacity) {
        double jaccardSimilarity;
        long count = 0L;
        HashSet<Id> accessed = new HashSet<Id>();
        accessed.add(source);
        JaccardSimilarTraverser.reachCapacity(++count, capacity);
        Set<Id> layer1s = this.adjacentVertices(source, step);
        JaccardSimilarTraverser.reachCapacity(count + (long)layer1s.size(), capacity);
        count += (long)layer1s.size();
        if (layer1s.isEmpty()) {
            return ImmutableMap.of();
        }
        HashMap<Id, Double> results = new HashMap<Id, Double>();
        HashSet<Id> layer2All = new HashSet<Id>();
        for (Id neighbor : layer1s) {
            if (accessed.contains(neighbor)) continue;
            Set<Id> layer2s = this.adjacentVertices(neighbor, step);
            if (layer2s.isEmpty()) {
                results.put(neighbor, 0.0);
                continue;
            }
            layer2All.addAll(layer2s);
            JaccardSimilarTraverser.reachCapacity(count + (long)layer2All.size(), capacity);
            jaccardSimilarity = this.jaccardSimilarity(layer1s, layer2s);
            results.put(neighbor, jaccardSimilarity);
            accessed.add(neighbor);
        }
        count += (long)layer2All.size();
        for (Id neighbor : layer2All) {
            if (accessed.contains(neighbor)) continue;
            Set<Id> layer3s = this.adjacentVertices(neighbor, step);
            JaccardSimilarTraverser.reachCapacity(count + (long)layer3s.size(), capacity);
            if (layer3s.isEmpty()) {
                results.put(neighbor, 0.0);
                continue;
            }
            jaccardSimilarity = this.jaccardSimilarity(layer1s, layer3s);
            results.put(neighbor, jaccardSimilarity);
            accessed.add(neighbor);
        }
        return results;
    }

    private static void reachCapacity(long count, long capacity) {
        if (capacity != -1L && count > capacity) {
            throw new HugeException("Reach capacity '%s'", capacity);
        }
    }
}

