/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.traversal.algorithm.OltpTraverser;
import com.baidu.hugegraph.traversal.algorithm.steps.EdgeStep;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.E;
import java.util.Iterator;
import java.util.Set;

public class KneighborTraverser
extends OltpTraverser {
    public KneighborTraverser(HugeGraph graph) {
        super(graph);
    }

    public Set<Id> kneighbor(Id sourceV, Directions dir, String label, int depth, long degree, long limit) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        KneighborTraverser.checkPositive(depth, "k-neighbor max_depth");
        KneighborTraverser.checkDegree(degree);
        KneighborTraverser.checkLimit(limit);
        Id labelId = this.getEdgeLabelId(label);
        Set<Id> latest = KneighborTraverser.newSet();
        latest.add(sourceV);
        Set<Id> all = KneighborTraverser.newSet();
        all.add(sourceV);
        while (depth-- > 0) {
            long remaining = limit == -1L ? -1L : limit - (long)all.size();
            latest = this.adjacentVertices(latest, dir, labelId, all, degree, remaining);
            all.addAll(latest);
            if (limit == -1L || (long)all.size() < limit) continue;
            break;
        }
        return all;
    }

    public Set<HugeTraverser.Node> customizedKneighbor(Id source, EdgeStep step, int maxDepth, long limit) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        KneighborTraverser.checkPositive(maxDepth, "k-neighbor max_depth");
        KneighborTraverser.checkLimit(limit);
        boolean single = maxDepth < this.concurrentDepth() || step.direction() != Directions.BOTH;
        return this.customizedKneighbor(source, step, maxDepth, limit, single);
    }

    public Set<HugeTraverser.Node> customizedKneighbor(Id source, EdgeStep step, int maxDepth, long limit, boolean single) {
        Set<HugeTraverser.Node> latest = KneighborTraverser.newSet(single);
        Set<HugeTraverser.Node> all = KneighborTraverser.newSet(single);
        HugeTraverser.KNode sourceV = new HugeTraverser.KNode(source, null);
        latest.add(sourceV);
        all.add(sourceV);
        while (maxDepth-- > 0) {
            long remaining = limit == -1L ? -1L : limit - (long)all.size();
            latest = this.adjacentVertices(latest, step, all, remaining, single);
            int size = all.size() + latest.size();
            if (limit != -1L && (long)size >= limit) {
                int subLength = (int)limit - all.size();
                Iterator<HugeTraverser.Node> iterator = latest.iterator();
                for (int i = 0; i < subLength && iterator.hasNext(); ++i) {
                    all.add(iterator.next());
                }
                break;
            }
            all.addAll(latest);
        }
        return all;
    }
}

