/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.traversal.algorithm.OltpTraverser;
import com.baidu.hugegraph.traversal.algorithm.steps.EdgeStep;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import java.util.Set;

public class KoutTraverser
extends OltpTraverser {
    public KoutTraverser(HugeGraph graph) {
        super(graph);
    }

    public Set<Id> kout(Id sourceV, Directions dir, String label, int depth, boolean nearest, long degree, long capacity, long limit) {
        long remaining;
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        KoutTraverser.checkPositive(depth, "k-out max_depth");
        KoutTraverser.checkDegree(degree);
        KoutTraverser.checkCapacity(capacity);
        KoutTraverser.checkLimit(limit);
        if (capacity != -1L) {
            E.checkArgument((capacity >= limit && limit != -1L ? 1 : 0) != 0, (String)"Capacity can't be less than limit, but got capacity '%s' and limit '%s'", (Object[])new Object[]{capacity, limit});
        }
        Id labelId = this.getEdgeLabelId(label);
        Set<Id> latest = KoutTraverser.newSet();
        latest.add(sourceV);
        Set<Id> all = KoutTraverser.newSet();
        all.add(sourceV);
        long l = remaining = capacity == -1L ? -1L : capacity - (long)latest.size();
        while (depth-- > 0) {
            if (depth == 0 && limit != -1L && (limit < remaining || remaining == -1L)) {
                remaining = limit;
            }
            if (nearest) {
                latest = this.adjacentVertices(latest, dir, labelId, all, degree, remaining);
                all.addAll(latest);
            } else {
                latest = this.adjacentVertices(latest, dir, labelId, null, degree, remaining);
            }
            if (capacity == -1L || (remaining -= (long)latest.size()) > 0L || depth <= 0) continue;
            throw new HugeException("Reach capacity '%s' while remaining depth '%s'", capacity, depth);
        }
        return latest;
    }

    public Set<HugeTraverser.Node> customizedKout(Id source, EdgeStep step, int maxDepth, boolean nearest, long capacity, long limit) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        KoutTraverser.checkPositive(maxDepth, "k-out max_depth");
        KoutTraverser.checkCapacity(capacity);
        KoutTraverser.checkLimit(limit);
        boolean single = maxDepth < this.concurrentDepth() || step.direction() != Directions.BOTH;
        Set results = this.customizedKout(source, step, maxDepth, nearest, capacity, single);
        if (limit != -1L && (long)results.size() > limit) {
            results = CollectionUtil.subSet(results, (int)0, (int)((int)limit));
        }
        return results;
    }

    public Set<HugeTraverser.Node> customizedKout(Id source, EdgeStep step, int maxDepth, boolean nearest, long capacity, boolean single) {
        long remaining;
        Set<HugeTraverser.Node> latest = KoutTraverser.newSet(single);
        Set<HugeTraverser.Node> all = KoutTraverser.newSet(single);
        HugeTraverser.KNode sourceV = new HugeTraverser.KNode(source, null);
        latest.add(sourceV);
        all.add(sourceV);
        int depth = maxDepth;
        long l = remaining = capacity == -1L ? -1L : capacity - (long)latest.size();
        while (depth-- > 0) {
            if (nearest) {
                latest = this.adjacentVertices(latest, step, all, remaining, single);
                all.addAll(latest);
            } else {
                latest = this.adjacentVertices(latest, step, null, remaining, single);
            }
            if (capacity == -1L) continue;
            KoutTraverser.reachCapacity(remaining -= (long)latest.size(), capacity, depth);
        }
        return latest;
    }

    private static void reachCapacity(long remaining, long capacity, int depth) {
        if (remaining <= 0L && depth > 0) {
            throw new HugeException("Reach capacity '%s' while remaining depth '%s'", capacity, depth);
        }
    }
}

