/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.traversal.algorithm.steps.EdgeStep;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.OrderLimitMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class NeighborRankTraverser
extends HugeTraverser {
    public static final int MAX_TOP = 1000;
    private final double alpha;
    private final long capacity;

    public NeighborRankTraverser(HugeGraph graph, double alpha, long capacity) {
        super(graph);
        NeighborRankTraverser.checkCapacity(capacity);
        this.alpha = alpha;
        this.capacity = capacity;
    }

    public List<Map<Id, Double>> neighborRank(Id source, List<Step> steps) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        E.checkArgument((!steps.isEmpty() ? 1 : 0) != 0, (String)"The steps can't be empty", (Object[])new Object[0]);
        MultivaluedMap sources = NeighborRankTraverser.newMultivalueMap();
        sources.add((Object)source, (Object)new HugeTraverser.Node(source, null));
        boolean sameLayerTransfer = true;
        long access = 0L;
        ArrayList<Ranks> ranks = new ArrayList<Ranks>();
        ranks.add(Ranks.of(source, 1.0));
        for (Step step : steps) {
            Ranks newLayerRanks;
            Ranks lastLayerRanks = (Ranks)((Object)ranks.get(ranks.size() - 1));
            HashMap<Id, Double> sameLayerIncrRanks = new HashMap<Id, Double>();
            ArrayList<Adjacencies> adjacencies = new ArrayList<Adjacencies>();
            MultivaluedMap newVertices = NeighborRankTraverser.newMultivalueMap();
            for (Map.Entry entry : sources.entrySet()) {
                Id vertex = (Id)entry.getKey();
                Iterator<Edge> edges = this.edgesOfVertex(vertex, step.edgeStep);
                Adjacencies adjacenciesV = new Adjacencies(vertex);
                HashSet<Id> sameLayerNodesV = new HashSet<Id>();
                HashMap<Integer, Set<Id>> prevLayerNodesV = new HashMap<Integer, Set<Id>>();
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    if (this.belongToSameLayer(sources.keySet(), target, sameLayerNodesV) || this.belongToPrevLayers(ranks, target, prevLayerNodesV)) continue;
                    for (HugeTraverser.Node n : (List)entry.getValue()) {
                        if (n.contains(target)) continue;
                        HugeTraverser.Node newNode = new HugeTraverser.Node(target, n);
                        adjacenciesV.add(newNode);
                        newVertices.add((Object)target, (Object)newNode);
                        NeighborRankTraverser.checkCapacity(this.capacity, ++access, "neighbor rank");
                    }
                }
                long degree = sameLayerNodesV.size() + prevLayerNodesV.size() + adjacenciesV.nodes().size();
                if (degree == 0L) continue;
                adjacenciesV.degree(degree);
                adjacencies.add(adjacenciesV);
                double incr = (Double)lastLayerRanks.getOrDefault(vertex, Double.valueOf(0.0)) * this.alpha / (double)degree;
                this.mergeSameLayerIncrRanks(sameLayerNodesV, incr, sameLayerIncrRanks);
                this.contributePrevLayers(ranks, incr, prevLayerNodesV);
            }
            if (sameLayerTransfer) {
                this.contributeLastLayer(sameLayerIncrRanks, lastLayerRanks);
                newLayerRanks = this.contributeNewLayer(adjacencies, lastLayerRanks, step.capacity);
            } else {
                newLayerRanks = this.contributeNewLayer(adjacencies, lastLayerRanks, step.capacity);
                this.contributeLastLayer(sameLayerIncrRanks, lastLayerRanks);
            }
            ranks.add(newLayerRanks);
            sources = newVertices;
        }
        return this.topRanks(ranks, steps);
    }

    private boolean belongToSameLayer(Set<Id> sources, Id target, Set<Id> sameLayerNodes) {
        if (sources.contains(target)) {
            sameLayerNodes.add(target);
            return true;
        }
        return false;
    }

    private boolean belongToPrevLayers(List<Ranks> ranks, Id target, Map<Integer, Set<Id>> prevLayerNodes) {
        for (int i = ranks.size() - 2; i > 0; --i) {
            Ranks prevLayerRanks = ranks.get(i);
            if (!prevLayerRanks.containsKey(target)) continue;
            Set nodes = prevLayerNodes.computeIfAbsent(i, HashSet::new);
            nodes.add(target);
            return true;
        }
        return false;
    }

    private void mergeSameLayerIncrRanks(Set<Id> sameLayerNodesV, double incr, Map<Id, Double> sameLayerIncrRanks) {
        for (Id node : sameLayerNodesV) {
            double oldRank = sameLayerIncrRanks.getOrDefault(node, 0.0);
            sameLayerIncrRanks.put(node, oldRank + incr);
        }
    }

    private void contributePrevLayers(List<Ranks> ranks, double incr, Map<Integer, Set<Id>> prevLayerNodesV) {
        for (Map.Entry<Integer, Set<Id>> e : prevLayerNodesV.entrySet()) {
            Ranks prevLayerRanks = ranks.get(e.getKey());
            for (Id node : e.getValue()) {
                double oldRank = (Double)prevLayerRanks.get(node);
                prevLayerRanks.put(node, Double.valueOf(oldRank + incr));
            }
        }
    }

    private void contributeLastLayer(Map<Id, Double> rankIncrs, Ranks lastLayerRanks) {
        for (Map.Entry<Id, Double> entry : rankIncrs.entrySet()) {
            double originRank = (Double)lastLayerRanks.get(entry.getKey());
            double incrRank = entry.getValue();
            lastLayerRanks.put(entry.getKey(), Double.valueOf(originRank + incrRank));
        }
    }

    private Ranks contributeNewLayer(List<Adjacencies> adjacencies, Ranks lastLayerRanks, int capacity) {
        Ranks newLayerRanks = new Ranks(capacity);
        for (Adjacencies adjacenciesV : adjacencies) {
            Id source = adjacenciesV.source();
            long degree = adjacenciesV.degree();
            for (HugeTraverser.Node node : adjacenciesV.nodes()) {
                double rank = (Double)newLayerRanks.getOrDefault(node.id(), Double.valueOf(0.0));
                newLayerRanks.put(node.id(), Double.valueOf(rank += (Double)lastLayerRanks.get(source) * this.alpha / (double)degree));
            }
        }
        return newLayerRanks;
    }

    private List<Map<Id, Double>> topRanks(List<Ranks> ranks, List<Step> steps) {
        assert (ranks.size() > 0);
        ArrayList<Map<Id, Double>> results = new ArrayList<Map<Id, Double>>(ranks.size());
        results.add((Map<Id, Double>)((Object)ranks.get(0)));
        for (int i = 1; i < ranks.size(); ++i) {
            Step step = steps.get(i - 1);
            Ranks origin = ranks.get(i);
            if (origin.size() > step.top) {
                results.add(origin.topN(step.top));
                continue;
            }
            results.add((Map<Id, Double>)((Object)origin));
        }
        return results;
    }

    private static class Ranks
    extends OrderLimitMap<Id, Double> {
        private static final long serialVersionUID = 2041529946017356029L;

        public Ranks(int capacity) {
            super(capacity);
        }

        public static Ranks of(Id key, Double value) {
            Ranks ranks = new Ranks(1);
            ranks.put(key, value);
            return ranks;
        }
    }

    private static class Adjacencies {
        private final Id source;
        private final List<HugeTraverser.Node> nodes;
        private long degree;

        public Adjacencies(Id source) {
            this.source = source;
            this.nodes = new ArrayList<HugeTraverser.Node>();
            this.degree = -1L;
        }

        public Id source() {
            return this.source;
        }

        public List<HugeTraverser.Node> nodes() {
            return this.nodes;
        }

        public void add(HugeTraverser.Node node) {
            this.nodes.add(node);
        }

        public long degree() {
            E.checkArgument((this.degree > 0L ? 1 : 0) != 0, (String)"The degree must be > 0, but got %s", (Object[])new Object[]{this.degree});
            return this.degree;
        }

        public void degree(long degree) {
            this.degree = degree;
        }
    }

    public static class Step {
        private final EdgeStep edgeStep;
        private final int top;
        private final int capacity;

        public Step(HugeGraph g, Directions direction, List<String> labels, long degree, long skipDegree, int top, int capacity) {
            E.checkArgument((top > 0 && top <= 1000 ? 1 : 0) != 0, (String)"The top of each layer can't exceed %s", (Object[])new Object[]{1000});
            E.checkArgument((capacity > 0 ? 1 : 0) != 0, (String)"The capacity of each layer must be > 0, but got %s", (Object[])new Object[]{capacity});
            this.edgeStep = new EdgeStep(g, direction, labels, null, degree, skipDegree);
            this.top = top;
            this.capacity = capacity;
        }
    }
}

