/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.iterator.FilterIterator;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.traversal.algorithm.steps.EdgeStep;
import com.baidu.hugegraph.util.Consumers;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import jersey.repackaged.com.google.common.base.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public abstract class OltpTraverser
extends HugeTraverser
implements AutoCloseable {
    private static final String EXECUTOR_NAME = "oltp";
    private static Consumers.ExecutorPool executors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OltpTraverser(HugeGraph graph) {
        super(graph);
        if (executors != null) {
            return;
        }
        Class<OltpTraverser> clazz = OltpTraverser.class;
        synchronized (OltpTraverser.class) {
            if (executors != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int workers = (Integer)this.config().get(CoreOptions.OLTP_CONCURRENT_THREADS);
            if (workers > 0) {
                executors = new Consumers.ExecutorPool(EXECUTOR_NAME, workers);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Class<OltpTraverser> clazz = OltpTraverser.class;
        synchronized (OltpTraverser.class) {
            if (executors != null) {
                executors.destroy();
                executors = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected Set<HugeTraverser.Node> adjacentVertices(Set<HugeTraverser.Node> latest, EdgeStep step, Set<HugeTraverser.Node> all, long remaining, boolean single) {
        if (single) {
            return this.adjacentVertices(latest, step, all, remaining);
        }
        AtomicLong remain = new AtomicLong(remaining);
        return this.adjacentVertices(latest, step, all, remain);
    }

    protected Set<HugeTraverser.Node> adjacentVertices(Set<HugeTraverser.Node> vertices, EdgeStep step, Set<HugeTraverser.Node> excluded, AtomicLong remaining) {
        ConcurrentHashMap.KeySetView neighbors = ConcurrentHashMap.newKeySet();
        this.traverseNodes(vertices.iterator(), v -> {
            Iterator<Edge> edges = this.edgesOfVertex(v.id(), step);
            while (edges.hasNext()) {
                Id target = ((HugeEdge)edges.next()).id().otherVertexId();
                HugeTraverser.KNode kNode = new HugeTraverser.KNode(target, (HugeTraverser.KNode)v);
                if (excluded != null && excluded.contains(kNode)) continue;
                neighbors.add(kNode);
                if (remaining.decrementAndGet() > 0L) continue;
                return;
            }
        });
        return neighbors;
    }

    protected long traverseNodes(Iterator<HugeTraverser.Node> vertices, Consumer<HugeTraverser.Node> consumer) {
        return this.traverse(vertices, consumer, "traverse-nodes");
    }

    protected long traversePairs(Iterator<Pair<Id, Id>> pairs, Consumer<Pair<Id, Id>> consumer) {
        return this.traverse(pairs, consumer, "traverse-pairs");
    }

    protected long traverseIds(Iterator<Id> ids, Consumer<Id> consumer) {
        return this.traverse(ids, consumer, "traverse-ids");
    }

    protected <K> long traverse(Iterator<K> iterator, Consumer<K> consumer, String name) {
        if (!iterator.hasNext()) {
            return 0L;
        }
        Consumers<K> consumers = new Consumers<K>(executors.getExecutor(), consumer, null);
        consumers.start(name);
        long total = 0L;
        try {
            while (iterator.hasNext()) {
                ++total;
                K v = iterator.next();
                consumers.provide(v);
            }
        }
        catch (Consumers.StopExecution e) {
            try {
                consumers.await();
            }
            catch (Throwable e2) {
                throw Consumers.wrapException(e2);
            }
            finally {
                executors.returnExecutor(consumers.executor());
                CloseableIterator.closeIterator(iterator);
            }
        }
        catch (Throwable e) {
            throw Consumers.wrapException(e);
        }
        finally {
            try {
                consumers.await();
            }
            catch (Throwable e) {
                throw Consumers.wrapException(e);
            }
            finally {
                executors.returnExecutor(consumers.executor());
                CloseableIterator.closeIterator(iterator);
            }
        }
        return total;
    }

    protected Iterator<Vertex> filter(Iterator<Vertex> vertices, String key, Object value) {
        return new FilterIterator(vertices, vertex -> this.match((Element)vertex, key, value));
    }

    protected boolean match(Element elem, String key, Object value) {
        this.graph().propertyKey(key);
        Property p = elem.property(key);
        return p.isPresent() && Objects.equal((Object)p.value(), (Object)value);
    }

    public class ConcurrentMultiValuedMap<K, V>
    extends ConcurrentHashMap<K, List<V>> {
        private static final long serialVersionUID = -7249946839643493614L;

        public void add(K key, V value) {
            List<V> values = this.getValues(key);
            values.add(value);
        }

        public void addAll(K key, List<V> value) {
            List<V> values = this.getValues(key);
            values.addAll(value);
        }

        public List<V> getValues(K key) {
            List old;
            List values = (CopyOnWriteArrayList)this.get(key);
            if (values == null && (old = (List)this.putIfAbsent(key, values = new CopyOnWriteArrayList())) != null) {
                values = old;
            }
            return values;
        }
    }
}

