/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class PathsTraverser
extends HugeTraverser {
    public PathsTraverser(HugeGraph graph) {
        super(graph);
    }

    public HugeTraverser.PathSet paths(Id sourceV, Directions sourceDir, Id targetV, Directions targetDir, String label, int depth, long degree, long capacity, long limit) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)targetV, (String)"target vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        this.checkVertexExist(targetV, "target vertex");
        E.checkNotNull((Object)sourceDir, (String)"source direction");
        E.checkNotNull((Object)targetDir, (String)"target direction");
        E.checkArgument((sourceDir == targetDir || sourceDir == targetDir.opposite() ? 1 : 0) != 0, (String)"Source direction must equal to target direction or opposite to target direction", (Object[])new Object[0]);
        PathsTraverser.checkPositive(depth, "max depth");
        PathsTraverser.checkDegree(degree);
        PathsTraverser.checkCapacity(capacity);
        PathsTraverser.checkLimit(limit);
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        if (sourceV.equals(targetV)) {
            paths.add(new HugeTraverser.Path(sourceV, (List<Id>)ImmutableList.of((Object)sourceV)));
        }
        Id labelId = this.getEdgeLabelId(label);
        Traverser traverser = new Traverser(sourceV, targetV, labelId, degree, capacity, limit);
        while (--depth >= 0 && !traverser.reachLimit()) {
            traverser.forward(sourceDir);
            if (--depth < 0 || traverser.reachLimit()) break;
            traverser.backward(targetDir);
        }
        paths.addAll(traverser.paths());
        return paths;
    }

    private class Traverser {
        private MultivaluedMap<Id, HugeTraverser.Node> sources = HugeTraverser.newMultivalueMap();
        private MultivaluedMap<Id, HugeTraverser.Node> targets = HugeTraverser.newMultivalueMap();
        private MultivaluedMap<Id, HugeTraverser.Node> sourcesAll = HugeTraverser.newMultivalueMap();
        private MultivaluedMap<Id, HugeTraverser.Node> targetsAll = HugeTraverser.newMultivalueMap();
        private final Id label;
        private final long degree;
        private final long capacity;
        private final long limit;
        private HugeTraverser.PathSet paths;

        public Traverser(Id sourceV, Id targetV, Id label, long degree, long capacity, long limit) {
            this.sources.add((Object)sourceV, (Object)new HugeTraverser.Node(sourceV));
            this.targets.add((Object)targetV, (Object)new HugeTraverser.Node(targetV));
            this.sourcesAll.putAll(this.sources);
            this.targetsAll.putAll(this.targets);
            this.label = label;
            this.degree = degree;
            this.capacity = capacity;
            this.limit = limit;
            this.paths = new HugeTraverser.PathSet();
        }

        public void forward(Directions direction) {
            MultivaluedMap newVertices = HugeTraverser.newMultivalueMap();
            for (Map.Entry entry : this.sources.entrySet()) {
                Id vid = (Id)entry.getKey();
                Iterator<Edge> edges = PathsTraverser.this.edgesOfVertex(vid, direction, this.label, this.degree);
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    for (HugeTraverser.Node n : (List)entry.getValue()) {
                        if (n.contains(target)) continue;
                        if (this.targetsAll.containsKey((Object)target)) {
                            for (HugeTraverser.Node node : (List)this.targetsAll.get((Object)target)) {
                                List<Id> path = n.joinPath(node);
                                if (path.isEmpty()) continue;
                                this.paths.add(new HugeTraverser.Path(target, path));
                                if (!this.reachLimit()) continue;
                                return;
                            }
                        }
                        newVertices.add((Object)target, (Object)new HugeTraverser.Node(target, n));
                    }
                }
            }
            this.sources = newVertices;
            for (Map.Entry entry : newVertices.entrySet()) {
                this.sourcesAll.addAll(entry.getKey(), (List)entry.getValue());
            }
        }

        public void backward(Directions direction) {
            MultivaluedMap newVertices = HugeTraverser.newMultivalueMap();
            for (Map.Entry entry : this.targets.entrySet()) {
                Id vid = (Id)entry.getKey();
                Iterator<Edge> edges = PathsTraverser.this.edgesOfVertex(vid, direction, this.label, this.degree);
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    for (HugeTraverser.Node n : (List)entry.getValue()) {
                        if (n.contains(target)) continue;
                        if (this.sourcesAll.containsKey((Object)target)) {
                            for (HugeTraverser.Node node : (List)this.sourcesAll.get((Object)target)) {
                                List<Id> path = n.joinPath(node);
                                if (path.isEmpty()) continue;
                                HugeTraverser.Path newPath = new HugeTraverser.Path(target, path);
                                newPath.reverse();
                                this.paths.add(newPath);
                                if (!this.reachLimit()) continue;
                                return;
                            }
                        }
                        newVertices.add((Object)target, (Object)new HugeTraverser.Node(target, n));
                    }
                }
            }
            this.targets = newVertices;
            for (Map.Entry entry : newVertices.entrySet()) {
                this.targetsAll.addAll(entry.getKey(), (List)entry.getValue());
            }
        }

        public HugeTraverser.PathSet paths() {
            return this.paths;
        }

        private int accessedNodes() {
            return this.sourcesAll.size() + this.targetsAll.size();
        }

        private boolean reachLimit() {
            HugeTraverser.checkCapacity(this.capacity, this.accessedNodes(), "paths");
            return this.limit != -1L && (long)this.paths.size() >= this.limit;
        }
    }
}

