/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import java.util.Collection;
import java.util.Set;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class SameNeighborTraverser
extends HugeTraverser {
    public SameNeighborTraverser(HugeGraph graph) {
        super(graph);
    }

    public Set<Id> sameNeighbors(Id vertex, Id other, Directions direction, String label, long degree, long limit) {
        E.checkNotNull((Object)vertex, (String)"vertex id");
        E.checkNotNull((Object)other, (String)"the other vertex id");
        this.checkVertexExist(vertex, "vertex");
        this.checkVertexExist(other, "other vertex");
        E.checkNotNull((Object)direction, (String)"direction");
        SameNeighborTraverser.checkDegree(degree);
        SameNeighborTraverser.checkLimit(limit);
        Id labelId = this.getEdgeLabelId(label);
        Set sourceNeighbors = IteratorUtils.set(this.adjacentVertices(vertex, direction, labelId, degree));
        Set targetNeighbors = IteratorUtils.set(this.adjacentVertices(other, direction, labelId, degree));
        Set sameNeighbors = (Set)CollectionUtil.intersect((Collection)sourceNeighbors, (Collection)targetNeighbors);
        if (limit != -1L) {
            int end = Math.min(sameNeighbors.size(), (int)limit);
            sameNeighbors = CollectionUtil.subSet((Set)sameNeighbors, (int)0, (int)end);
        }
        return sameNeighbors;
    }
}

