/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.traversal.algorithm.steps.EdgeStep;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class ShortestPathTraverser
extends HugeTraverser {
    public ShortestPathTraverser(HugeGraph graph) {
        super(graph);
    }

    public HugeTraverser.Path shortestPath(Id sourceV, Id targetV, Directions dir, List<String> labels, int depth, long degree, long skipDegree, long capacity) {
        HugeTraverser.PathSet paths;
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)targetV, (String)"target vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        this.checkVertexExist(targetV, "target vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        ShortestPathTraverser.checkPositive(depth, "max depth");
        ShortestPathTraverser.checkDegree(degree);
        ShortestPathTraverser.checkCapacity(capacity);
        ShortestPathTraverser.checkSkipDegree(skipDegree, degree, capacity);
        if (sourceV.equals(targetV)) {
            return new HugeTraverser.Path((List<Id>)ImmutableList.of((Object)sourceV));
        }
        HashMap<Id, String> labelMap = new HashMap<Id, String>(labels.size());
        for (String label : labels) {
            labelMap.put(this.getEdgeLabelId(label), label);
        }
        Traverser traverser = new Traverser(sourceV, targetV, dir, labelMap, degree, skipDegree, capacity);
        while ((paths = traverser.forward(false)).isEmpty() && --depth > 0) {
            ShortestPathTraverser.checkCapacity(traverser.capacity, traverser.size, "shortest path");
            paths = traverser.backward(false);
            if (!paths.isEmpty() || --depth <= 0) {
                if (paths.isEmpty()) break;
                HugeTraverser.Path path = (HugeTraverser.Path)paths.iterator().next();
                Collections.reverse(path.vertices());
                break;
            }
            ShortestPathTraverser.checkCapacity(traverser.capacity, traverser.size, "shortest path");
        }
        return paths.isEmpty() ? HugeTraverser.Path.EMPTY_PATH : (HugeTraverser.Path)paths.iterator().next();
    }

    public HugeTraverser.Path shortestPath(Id sourceV, Id targetV, EdgeStep step, int depth, long capacity) {
        return this.shortestPath(sourceV, targetV, step.direction(), new ArrayList<String>(step.labels().values()), depth, step.degree(), step.skipDegree(), capacity);
    }

    public HugeTraverser.PathSet allShortestPaths(Id sourceV, Id targetV, Directions dir, List<String> labels, int depth, long degree, long skipDegree, long capacity) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)targetV, (String)"target vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        this.checkVertexExist(targetV, "target vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        ShortestPathTraverser.checkPositive(depth, "max depth");
        ShortestPathTraverser.checkDegree(degree);
        ShortestPathTraverser.checkCapacity(capacity);
        ShortestPathTraverser.checkSkipDegree(skipDegree, degree, capacity);
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        if (sourceV.equals(targetV)) {
            paths.add(new HugeTraverser.Path((List<Id>)ImmutableList.of((Object)sourceV)));
            return paths;
        }
        HashMap<Id, String> labelMap = new HashMap<Id, String>(labels.size());
        for (String label : labels) {
            labelMap.put(this.getEdgeLabelId(label), label);
        }
        Traverser traverser = new Traverser(sourceV, targetV, dir, labelMap, degree, skipDegree, capacity);
        while ((paths = traverser.forward(true)).isEmpty() && --depth > 0) {
            ShortestPathTraverser.checkCapacity(traverser.capacity, traverser.size, "shortest path");
            paths = traverser.backward(true);
            if (!paths.isEmpty() || --depth <= 0) {
                for (HugeTraverser.Path path : paths) {
                    Collections.reverse(path.vertices());
                }
                break;
            }
            ShortestPathTraverser.checkCapacity(traverser.capacity, traverser.size, "shortest path");
        }
        return paths;
    }

    private class Traverser {
        private Map<Id, HugeTraverser.Node> sources = HugeTraverser.newMap();
        private Map<Id, HugeTraverser.Node> targets = HugeTraverser.newMap();
        private final Directions direction;
        private final Map<Id, String> labels;
        private final long degree;
        private final long skipDegree;
        private final long capacity;
        private long size;

        public Traverser(Id sourceV, Id targetV, Directions dir, Map<Id, String> labels, long degree, long skipDegree, long capacity) {
            this.sources.put(sourceV, new HugeTraverser.Node(sourceV));
            this.targets.put(targetV, new HugeTraverser.Node(targetV));
            this.direction = dir;
            this.labels = labels;
            this.degree = degree;
            this.skipDegree = skipDegree;
            this.capacity = capacity;
            this.size = 0L;
        }

        public HugeTraverser.PathSet forward(boolean all) {
            HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
            Map<Id, HugeTraverser.Node> newVertices = HugeTraverser.newMap();
            long degree = this.skipDegree > 0L ? this.skipDegree : this.degree;
            for (HugeTraverser.Node v : this.sources.values()) {
                Iterator<Edge> edges = ShortestPathTraverser.this.edgesOfVertex(v.id(), this.direction, this.labels, degree);
                edges = HugeTraverser.skipSuperNodeIfNeeded(edges, this.degree, this.skipDegree);
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    if (this.targets.containsKey(target)) {
                        if (this.superNode(target, this.direction)) continue;
                        paths.add(new HugeTraverser.Path(v.joinPath(this.targets.get(target))));
                        if (!all) {
                            return paths;
                        }
                    }
                    if (newVertices.containsKey(target) || this.sources.containsKey(target) || v.contains(target)) continue;
                    newVertices.put(target, new HugeTraverser.Node(target, v));
                }
            }
            this.sources = newVertices;
            this.size += (long)newVertices.size();
            return paths;
        }

        public HugeTraverser.PathSet backward(boolean all) {
            HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
            Map<Id, HugeTraverser.Node> newVertices = HugeTraverser.newMap();
            long degree = this.skipDegree > 0L ? this.skipDegree : this.degree;
            Directions opposite = this.direction.opposite();
            for (HugeTraverser.Node v : this.targets.values()) {
                Iterator<Edge> edges = ShortestPathTraverser.this.edgesOfVertex(v.id(), opposite, this.labels, degree);
                edges = HugeTraverser.skipSuperNodeIfNeeded(edges, this.degree, this.skipDegree);
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    if (this.sources.containsKey(target)) {
                        if (this.superNode(target, opposite)) continue;
                        paths.add(new HugeTraverser.Path(v.joinPath(this.sources.get(target))));
                        if (!all) {
                            return paths;
                        }
                    }
                    if (newVertices.containsKey(target) || this.targets.containsKey(target) || v.contains(target)) continue;
                    newVertices.put(target, new HugeTraverser.Node(target, v));
                }
            }
            this.targets = newVertices;
            this.size += (long)newVertices.size();
            return paths;
        }

        private boolean superNode(Id vertex, Directions direction) {
            if (this.skipDegree <= 0L) {
                return false;
            }
            Iterator<Edge> edges = ShortestPathTraverser.this.edgesOfVertex(vertex, direction, this.labels, this.skipDegree);
            return IteratorUtils.count(edges) >= this.skipDegree;
        }
    }
}

