/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class SingleSourceShortestPathTraverser
extends HugeTraverser {
    public SingleSourceShortestPathTraverser(HugeGraph graph) {
        super(graph);
    }

    public WeightedPaths singleSourceShortestPaths(Id sourceV, Directions dir, String label, String weight, long degree, long skipDegree, long capacity, long limit) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        SingleSourceShortestPathTraverser.checkDegree(degree);
        SingleSourceShortestPathTraverser.checkCapacity(capacity);
        SingleSourceShortestPathTraverser.checkSkipDegree(skipDegree, degree, capacity);
        SingleSourceShortestPathTraverser.checkLimit(limit);
        Id labelId = this.getEdgeLabelId(label);
        Traverser traverser = new Traverser(sourceV, dir, labelId, weight, degree, skipDegree, capacity, limit);
        while (true) {
            traverser.forward();
            if (traverser.done()) {
                return traverser.shortestPaths();
            }
            SingleSourceShortestPathTraverser.checkCapacity(traverser.capacity, traverser.size, "shortest path");
        }
    }

    public NodeWithWeight weightedShortestPath(Id sourceV, Id targetV, Directions dir, String label, String weight, long degree, long skipDegree, long capacity) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        E.checkNotNull((Object)weight, (String)"weight property");
        SingleSourceShortestPathTraverser.checkDegree(degree);
        SingleSourceShortestPathTraverser.checkCapacity(capacity);
        SingleSourceShortestPathTraverser.checkSkipDegree(skipDegree, degree, capacity);
        Id labelId = this.getEdgeLabelId(label);
        Traverser traverser = new Traverser(sourceV, dir, labelId, weight, degree, skipDegree, capacity, -1L);
        while (true) {
            traverser.forward();
            WeightedPaths results = traverser.shortestPaths();
            if (results.containsKey(targetV) || traverser.done()) {
                return (NodeWithWeight)results.get(targetV);
            }
            SingleSourceShortestPathTraverser.checkCapacity(traverser.capacity, traverser.size, "shortest path");
        }
    }

    public static class WeightedPaths
    extends LinkedHashMap<Id, NodeWithWeight> {
        private static final long serialVersionUID = -313873642177730993L;

        public Set<Id> vertices() {
            HashSet<Id> vertices = new HashSet<Id>();
            vertices.addAll(this.keySet());
            for (NodeWithWeight nw : this.values()) {
                vertices.addAll(nw.node().path());
            }
            return vertices;
        }

        public Map<Id, Map<String, Object>> toMap() {
            HashMap<Id, Map<String, Object>> results = new HashMap<Id, Map<String, Object>>();
            for (Map.Entry entry : this.entrySet()) {
                Id source = (Id)entry.getKey();
                NodeWithWeight nw = (NodeWithWeight)entry.getValue();
                Map<String, Object> result = nw.toMap();
                results.put(source, result);
            }
            return results;
        }
    }

    public static class NodeWithWeight
    implements Comparable<NodeWithWeight> {
        private final double weight;
        private final HugeTraverser.Node node;

        public NodeWithWeight(double weight, HugeTraverser.Node node) {
            this.weight = weight;
            this.node = node;
        }

        public NodeWithWeight(double weight, Id id, NodeWithWeight prio) {
            this(weight, new HugeTraverser.Node(id, prio.node()));
        }

        public double weight() {
            return this.weight;
        }

        public HugeTraverser.Node node() {
            return this.node;
        }

        public Map<String, Object> toMap() {
            return ImmutableMap.of((Object)"weight", (Object)this.weight, (Object)"vertices", this.node().path());
        }

        @Override
        public int compareTo(NodeWithWeight other) {
            return Double.compare(this.weight, other.weight);
        }
    }

    private class Traverser {
        private WeightedPaths findingNodes = new WeightedPaths();
        private WeightedPaths foundNodes = new WeightedPaths();
        private Set<NodeWithWeight> sources;
        private Id source;
        private final Directions direction;
        private final Id label;
        private final String weight;
        private final long degree;
        private final long skipDegree;
        private final long capacity;
        private final long limit;
        private long size;
        private boolean done = false;

        public Traverser(Id sourceV, Directions dir, Id label, String weight, long degree, long skipDegree, long capacity, long limit) {
            this.source = sourceV;
            this.sources = ImmutableSet.of((Object)new NodeWithWeight(0.0, new HugeTraverser.Node(sourceV, null)));
            this.direction = dir;
            this.label = label;
            this.weight = weight;
            this.degree = degree;
            this.skipDegree = skipDegree;
            this.capacity = capacity;
            this.limit = limit;
            this.size = 0L;
        }

        public void forward() {
            long degree = this.skipDegree > 0L ? this.skipDegree : this.degree;
            for (NodeWithWeight node : this.sources) {
                Iterator<Edge> edges = SingleSourceShortestPathTraverser.this.edgesOfVertex(node.node().id(), this.direction, this.label, degree);
                edges = this.skipSuperNodeIfNeeded(edges);
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    if (this.foundNodes.containsKey(target) || this.source.equals(target)) continue;
                    double currentWeight = this.edgeWeight(edge);
                    double weight = currentWeight + node.weight();
                    NodeWithWeight nw = new NodeWithWeight(weight, target, node);
                    NodeWithWeight exist = (NodeWithWeight)this.findingNodes.get(target);
                    if (exist != null && !(weight < exist.weight())) continue;
                    this.findingNodes.put(target, nw);
                }
            }
            Map sorted = CollectionUtil.sortByValue((Map)this.findingNodes, (boolean)true);
            double minWeight = 0.0;
            Set newSources = InsertionOrderUtil.newSet();
            for (Map.Entry entry : sorted.entrySet()) {
                Id id = (Id)entry.getKey();
                NodeWithWeight wn = (NodeWithWeight)entry.getValue();
                if (minWeight == 0.0) {
                    minWeight = wn.weight();
                } else if (wn.weight() > minWeight) break;
                this.foundNodes.put(id, wn);
                if (this.limit != -1L && (long)this.foundNodes.size() >= this.limit) {
                    this.done = true;
                    return;
                }
                this.findingNodes.remove(id);
                newSources.add(wn);
            }
            this.sources = newSources;
            if (this.sources.isEmpty()) {
                this.done = true;
            }
        }

        public boolean done() {
            return this.done;
        }

        public WeightedPaths shortestPaths() {
            return this.foundNodes;
        }

        private double edgeWeight(HugeEdge edge) {
            double edgeWeight = this.weight == null || !edge.property(this.weight).isPresent() ? 1.0 : (Double)edge.value(this.weight);
            return edgeWeight;
        }

        private Iterator<Edge> skipSuperNodeIfNeeded(Iterator<Edge> edges) {
            if (this.skipDegree <= 0L) {
                return edges;
            }
            ArrayList<Edge> edgeList = new ArrayList<Edge>();
            int count = 0;
            while (edges.hasNext()) {
                if ((long)count < this.degree) {
                    edgeList.add(edges.next());
                }
                if ((long)count >= this.skipDegree) {
                    return QueryResults.emptyIterator();
                }
                ++count;
            }
            return edgeList.iterator();
        }
    }
}

