/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm.steps;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.traversal.optimize.TraversalUtil;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class EdgeStep {
    protected Directions direction;
    protected final Map<Id, String> labels;
    protected final Map<Id, Object> properties;
    protected final long degree;
    protected final long skipDegree;

    public EdgeStep(HugeGraph g, Directions direction) {
        this(g, direction, (List<String>)ImmutableList.of());
    }

    public EdgeStep(HugeGraph g, List<String> labels) {
        this(g, Directions.BOTH, labels);
    }

    public EdgeStep(HugeGraph g, Map<String, Object> properties) {
        this(g, Directions.BOTH, (List<String>)ImmutableList.of(), properties);
    }

    public EdgeStep(HugeGraph g, Directions direction, List<String> labels) {
        this(g, direction, labels, (Map<String, Object>)ImmutableMap.of());
    }

    public EdgeStep(HugeGraph g, Directions direction, List<String> labels, Map<String, Object> properties) {
        this(g, direction, labels, properties, Long.valueOf("10000"), 0L);
    }

    public EdgeStep(HugeGraph g, Directions direction, List<String> labels, Map<String, Object> properties, long degree, long skipDegree) {
        E.checkArgument((degree == -1L || degree > 0L ? 1 : 0) != 0, (String)"The degree must be > 0 or == -1, but got: %s", (Object[])new Object[]{degree});
        HugeTraverser.checkSkipDegree(skipDegree, degree, -1L);
        this.direction = direction;
        HashMap<Id, String> labelIds = new HashMap<Id, String>();
        if (labels != null) {
            for (String label : labels) {
                EdgeLabel el = g.edgeLabel(label);
                labelIds.put(el.id(), label);
            }
        }
        this.labels = labelIds;
        this.properties = properties == null || properties.isEmpty() ? null : TraversalUtil.transProperties(g, properties);
        this.degree = degree;
        this.skipDegree = skipDegree;
    }

    public Directions direction() {
        return this.direction;
    }

    public Map<Id, String> labels() {
        return this.labels;
    }

    public Map<Id, Object> properties() {
        return this.properties;
    }

    public long degree() {
        return this.degree;
    }

    public long skipDegree() {
        return this.skipDegree;
    }

    public Id[] edgeLabels() {
        int elsSize = this.labels.size();
        Id[] edgeLabels = this.labels.keySet().toArray(new Id[elsSize]);
        return edgeLabels;
    }

    public void swithDirection() {
        this.direction = this.direction.opposite();
    }

    public long limit() {
        long limit = this.skipDegree > 0L ? this.skipDegree : this.degree;
        return limit;
    }

    public String toString() {
        return String.format("EdgeStep{direction=%s,labels=%s,properties=%s}", this.direction, this.labels, this.properties);
    }

    public Iterator<Edge> skipSuperNodeIfNeeded(Iterator<Edge> edges) {
        return HugeTraverser.skipSuperNodeIfNeeded(edges, this.degree, this.skipDegree);
    }
}

