/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm.steps;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.traversal.algorithm.steps.EdgeStep;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class WeightedEdgeStep {
    private final EdgeStep edgeStep;
    private final PropertyKey weightBy;
    private final double defaultWeight;
    private final long sample;

    public WeightedEdgeStep(HugeGraph g, Directions direction) {
        this(g, direction, (List<String>)ImmutableList.of());
    }

    public WeightedEdgeStep(HugeGraph g, List<String> labels) {
        this(g, Directions.BOTH, labels);
    }

    public WeightedEdgeStep(HugeGraph g, Map<String, Object> properties) {
        this(g, Directions.BOTH, (List<String>)ImmutableList.of(), properties);
    }

    public WeightedEdgeStep(HugeGraph g, Directions direction, List<String> labels) {
        this(g, direction, labels, (Map<String, Object>)ImmutableMap.of());
    }

    public WeightedEdgeStep(HugeGraph g, Directions direction, List<String> labels, Map<String, Object> properties) {
        this(g, direction, labels, properties, Long.valueOf("10000"), 0L, null, 0.0, Long.valueOf("100"));
    }

    public WeightedEdgeStep(HugeGraph g, Directions direction, List<String> labels, Map<String, Object> properties, long degree, long skipDegree, String weightBy, double defaultWeight, long sample) {
        E.checkArgument((sample > 0L || sample == -1L ? 1 : 0) != 0, (String)"The sample must be > 0 or == -1, but got: %s", (Object[])new Object[]{sample});
        E.checkArgument((degree == -1L || degree >= sample ? 1 : 0) != 0, (String)"Degree must be greater than or equal to sample, but got degree %s and sample %s", (Object[])new Object[]{degree, sample});
        this.edgeStep = new EdgeStep(g, direction, labels, properties, degree, skipDegree);
        this.weightBy = weightBy != null ? g.propertyKey(weightBy) : null;
        this.defaultWeight = defaultWeight;
        this.sample = sample;
    }

    public EdgeStep step() {
        return this.edgeStep;
    }

    public PropertyKey weightBy() {
        return this.weightBy;
    }

    public double defaultWeight() {
        return this.defaultWeight;
    }

    public long sample() {
        return this.sample;
    }
}

