/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm.strategy;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.traversal.algorithm.OltpTraverser;
import com.baidu.hugegraph.traversal.algorithm.steps.EdgeStep;
import com.baidu.hugegraph.traversal.algorithm.strategy.TraverseStrategy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class ConcurrentTraverseStrategy
extends OltpTraverser
implements TraverseStrategy {
    public ConcurrentTraverseStrategy(HugeGraph graph) {
        super(graph);
    }

    @Override
    public Map<Id, List<HugeTraverser.Node>> newMultiValueMap() {
        return new OltpTraverser.ConcurrentMultiValuedMap<Id, HugeTraverser.Node>(this);
    }

    @Override
    public void traverseOneLayer(Map<Id, List<HugeTraverser.Node>> vertices, EdgeStep step, BiConsumer<Id, EdgeStep> biConsumer) {
        this.traverseIds(vertices.keySet().iterator(), id -> biConsumer.accept((Id)id, step));
    }

    @Override
    public Set<HugeTraverser.Path> newPathSet() {
        return ConcurrentHashMap.newKeySet();
    }

    @Override
    public void addNode(Map<Id, List<HugeTraverser.Node>> vertices, Id id, HugeTraverser.Node node) {
        ((OltpTraverser.ConcurrentMultiValuedMap)vertices).add(id, node);
    }

    @Override
    public void addNewVerticesToAll(Map<Id, List<HugeTraverser.Node>> newVertices, Map<Id, List<HugeTraverser.Node>> targets) {
        OltpTraverser.ConcurrentMultiValuedMap vertices = (OltpTraverser.ConcurrentMultiValuedMap)targets;
        for (Map.Entry<Id, List<HugeTraverser.Node>> entry : newVertices.entrySet()) {
            vertices.addAll(entry.getKey(), entry.getValue());
        }
    }
}

