/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.optimize;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.traversal.optimize.QueryHolder;
import com.baidu.hugegraph.traversal.optimize.TraversalUtil;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;

public final class HugeVertexStep<E extends Element>
extends VertexStep<E>
implements QueryHolder {
    private static final long serialVersionUID = -7850636388424382454L;
    private static final Logger LOG = Log.logger(HugeVertexStep.class);
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();
    private final Query queryInfo = new Query(null);
    private Iterator<E> lastTimeResults = QueryResults.emptyIterator();

    public HugeVertexStep(VertexStep<E> originVertexStep) {
        super(originVertexStep.getTraversal(), originVertexStep.getReturnClass(), originVertexStep.getDirection(), originVertexStep.getEdgeLabels());
        originVertexStep.getLabels().forEach(arg_0 -> ((HugeVertexStep)this).addLabel(arg_0));
    }

    protected Iterator<E> flatMap(Traverser.Admin<Vertex> traverser) {
        Iterator<Vertex> results;
        boolean queryVertex = this.returnsVertex();
        boolean queryEdge = this.returnsEdge();
        assert (queryVertex || queryEdge);
        if (queryVertex) {
            results = this.vertices(traverser);
        } else {
            assert (queryEdge);
            results = this.edges(traverser);
        }
        this.lastTimeResults = results;
        return results;
    }

    private Iterator<Vertex> vertices(Traverser.Admin<Vertex> traverser) {
        HugeGraph graph = TraversalUtil.getGraph(this);
        Vertex vertex = (Vertex)traverser.get();
        Iterator<Edge> edges = this.edges(traverser);
        Iterator<Vertex> vertices = graph.adjacentVertices(edges);
        if (LOG.isDebugEnabled()) {
            LOG.debug("HugeVertexStep.vertices(): is there adjacent vertices of {}: {}, has={}", new Object[]{vertex.id(), vertices.hasNext(), this.hasContainers});
        }
        if (this.hasContainers.isEmpty()) {
            return vertices;
        }
        return TraversalUtil.filterResult(this.hasContainers, vertices);
    }

    private Iterator<Edge> edges(Traverser.Admin<Vertex> traverser) {
        HugeGraph graph = TraversalUtil.getGraph(this);
        List<HasContainer> conditions = this.hasContainers;
        boolean withEdgeCond = this.returnsEdge() && !conditions.isEmpty();
        boolean withVertexCond = this.returnsVertex() && !conditions.isEmpty();
        Id vertex = (Id)((Vertex)traverser.get()).id();
        Directions direction = Directions.convert(this.getDirection());
        Id[] edgeLabels = graph.mapElName2Id(this.getEdgeLabels());
        LOG.debug("HugeVertexStep.edges(): vertex={}, direction={}, edgeLabels={}, has={}", new Object[]{vertex, direction, edgeLabels, this.hasContainers});
        ConditionQuery query = GraphTransaction.constructEdgesQuery(vertex, direction, edgeLabels);
        if (withEdgeCond && edgeLabels.length > 0) {
            TraversalUtil.fillConditionQuery(query, conditions, graph);
            if (!GraphTransaction.matchPartialEdgeSortKeys(query, graph)) {
                query.resetUserpropConditions();
            } else if (GraphTransaction.matchFullEdgeSortKeys(query, graph)) {
                withEdgeCond = false;
            } else assert (query.userpropKeys().size() > 0);
        }
        if (!query.ids().isEmpty()) {
            query.resetConditions();
            LOG.warn("It's not recommended to query by has(id)");
        }
        if (withEdgeCond || withVertexCond) {
            E.checkArgument((!this.queryInfo().paging() ? 1 : 0) != 0, (String)"Can't query by paging and filtering", (Object[])new Object[0]);
            this.queryInfo().limit(Long.MAX_VALUE);
        }
        query = (ConditionQuery)this.injectQueryInfo(query);
        Iterator<Edge> edges = graph.edges(query);
        if (withEdgeCond) {
            return TraversalUtil.filterResult(conditions, edges);
        }
        return edges;
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return StringFactory.stepString((Step)this, (Object[])new Object[]{this.getDirection(), Arrays.asList(this.getEdgeLabels()), this.getReturnClass().getSimpleName(), this.hasContainers});
    }

    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    public void addHasContainer(HasContainer has) {
        if ("~page".equals(has.getKey())) {
            this.setPage((String)has.getValue());
            return;
        }
        this.hasContainers.add(has);
    }

    @Override
    public Query queryInfo() {
        return this.queryInfo;
    }

    @Override
    public Iterator<?> lastTimeResults() {
        return this.lastTimeResults;
    }

    public int hashCode() {
        return super.hashCode() ^ this.queryInfo.hashCode() ^ this.hasContainers.hashCode();
    }
}

