/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.type.define;

import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.SerialEnum;

public final class IndexType
extends Enum<IndexType>
implements SerialEnum {
    public static final /* enum */ IndexType SECONDARY = new IndexType(1, "secondary");
    public static final /* enum */ IndexType RANGE = new IndexType(2, "range");
    public static final /* enum */ IndexType RANGE_INT = new IndexType(21, "range_int");
    public static final /* enum */ IndexType RANGE_FLOAT = new IndexType(22, "range_float");
    public static final /* enum */ IndexType RANGE_LONG = new IndexType(23, "range_long");
    public static final /* enum */ IndexType RANGE_DOUBLE = new IndexType(24, "range_double");
    public static final /* enum */ IndexType SEARCH = new IndexType(3, "search");
    public static final /* enum */ IndexType SHARD = new IndexType(4, "shard");
    public static final /* enum */ IndexType UNIQUE = new IndexType(5, "unique");
    private byte code = 0;
    private String name = null;
    private static final /* synthetic */ IndexType[] $VALUES;

    public static IndexType[] values() {
        return (IndexType[])$VALUES.clone();
    }

    public static IndexType valueOf(String name) {
        return Enum.valueOf(IndexType.class, name);
    }

    private IndexType(int code, String name) {
        assert (code < 256);
        this.code = (byte)code;
        this.name = name;
    }

    @Override
    public byte code() {
        return this.code;
    }

    public String string() {
        return this.name;
    }

    public HugeType type() {
        switch (this) {
            case SECONDARY: {
                return HugeType.SECONDARY_INDEX;
            }
            case RANGE_INT: {
                return HugeType.RANGE_INT_INDEX;
            }
            case RANGE_FLOAT: {
                return HugeType.RANGE_FLOAT_INDEX;
            }
            case RANGE_LONG: {
                return HugeType.RANGE_LONG_INDEX;
            }
            case RANGE_DOUBLE: {
                return HugeType.RANGE_DOUBLE_INDEX;
            }
            case SEARCH: {
                return HugeType.SEARCH_INDEX;
            }
            case SHARD: {
                return HugeType.SHARD_INDEX;
            }
            case UNIQUE: {
                return HugeType.UNIQUE_INDEX;
            }
        }
        throw new AssertionError((Object)String.format("Unknown index type '%s'", this));
    }

    public boolean isString() {
        return this == SECONDARY || this == SEARCH || this == SHARD || this == UNIQUE;
    }

    public boolean isNumeric() {
        return this == RANGE_INT || this == RANGE_FLOAT || this == RANGE_LONG || this == RANGE_DOUBLE || this == SHARD;
    }

    public boolean isSecondary() {
        return this == SECONDARY;
    }

    public boolean isRange() {
        return this == RANGE_INT || this == RANGE_FLOAT || this == RANGE_LONG || this == RANGE_DOUBLE;
    }

    public boolean isSearch() {
        return this == SEARCH;
    }

    public boolean isShard() {
        return this == SHARD;
    }

    public boolean isUnique() {
        return this == UNIQUE;
    }

    static {
        $VALUES = new IndexType[]{SECONDARY, RANGE, RANGE_INT, RANGE_FLOAT, RANGE_LONG, RANGE_DOUBLE, SEARCH, SHARD, UNIQUE};
        SerialEnum.register(IndexType.class);
    }
}

