/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.serializer.BytesBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.digest.DigestUtils;

public final class GZipUtil {
    private static final int BUF_SIZE = 4096;

    public static String md5(String input) {
        return DigestUtils.md5Hex((String)input);
    }

    public static BytesBuffer compress(byte[] data) {
        int estimateSize = data.length >> 3;
        BytesBuffer output = BytesBuffer.allocate(estimateSize);
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        byte[] buffer = new byte[4096];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            output.write(buffer, 0, count);
        }
        output.forReadWritten();
        return output;
    }

    public static BytesBuffer decompress(byte[] data) {
        int estimateSize = data.length << 3;
        BytesBuffer output = BytesBuffer.allocate(estimateSize);
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        byte[] buffer = new byte[4096];
        while (!inflater.finished()) {
            try {
                int count = inflater.inflate(buffer);
                output.write(buffer, 0, count);
            }
            catch (DataFormatException e) {
                throw new BackendException("Failed to decompress", e);
            }
        }
        output.forReadWritten();
        return output;
    }
}

