/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.io.HugeGraphSONModule;
import com.baidu.hugegraph.util.E;
import java.io.IOException;
import java.util.Date;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.core.type.TypeReference;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.Module;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectReader;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public final class JsonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void registerModule(Module module) {
        mapper.registerModule(module);
    }

    public static String toJson(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new HugeException("Can't write json: %s", (Throwable)e, e.getMessage());
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        E.checkState((json != null ? 1 : 0) != 0, (String)"Json value can't be null for '%s'", (Object[])new Object[]{clazz.getSimpleName()});
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new HugeException("Can't read json: %s", (Throwable)e, e.getMessage());
        }
    }

    public static <T> T fromJson(String json, TypeReference<?> typeRef) {
        E.checkState((json != null ? 1 : 0) != 0, (String)"Json value can't be null for '%s'", (Object[])new Object[]{typeRef.getType()});
        try {
            ObjectReader reader = mapper.readerFor(typeRef);
            return (T)reader.readValue(json);
        }
        catch (IOException e) {
            throw new HugeException("Can't read json: %s", (Throwable)e, e.getMessage());
        }
    }

    public static Object castNumber(Object object, Class<?> clazz) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (clazz == Byte.class) {
                object = number.byteValue();
            } else if (clazz == Integer.class) {
                object = number.intValue();
            } else if (clazz == Long.class) {
                object = number.longValue();
            } else if (clazz == Float.class) {
                object = Float.valueOf(number.floatValue());
            } else if (clazz == Double.class) {
                assert (object instanceof Double) : object;
            } else assert (clazz == Date.class) : clazz;
        }
        return object;
    }

    public static Object asJson(Object value) {
        return new RawJson(JsonUtil.toJson(value));
    }

    public static Object asJson(String value) {
        return new RawJson(value);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(RawJson.class, (JsonSerializer)new RawJsonSerializer());
        HugeGraphSONModule.registerCommonSerializers(module);
        HugeGraphSONModule.registerIdSerializers(module);
        HugeGraphSONModule.registerSchemaSerializers(module);
        HugeGraphSONModule.registerGraphSerializers(module);
        mapper.registerModule((Module)module);
    }

    private static class RawJsonSerializer
    extends StdSerializer<RawJson> {
        private static final long serialVersionUID = 3240301861031054251L;

        public RawJsonSerializer() {
            super(RawJson.class);
        }

        public void serialize(RawJson json, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeRawValue(json.value());
        }
    }

    private static class RawJson {
        private final String value;

        public RawJson(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

