/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.serializer.BytesBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class LZ4Util {
    protected static final float DEFAULT_BUFFER_RATIO = 1.5f;

    public static BytesBuffer compress(byte[] bytes, int blockSize) {
        return LZ4Util.compress(bytes, blockSize, 1.5f);
    }

    public static BytesBuffer compress(byte[] bytes, int blockSize, float bufferRatio) {
        float ratio = bufferRatio <= 0.0f ? 1.5f : bufferRatio;
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4Compressor compressor = factory.fastCompressor();
        int initBufferSize = Math.round((float)bytes.length / ratio);
        BytesBuffer buf = new BytesBuffer(initBufferSize);
        LZ4BlockOutputStream lz4Output = new LZ4BlockOutputStream((OutputStream)buf, blockSize, compressor);
        try {
            lz4Output.write(bytes);
            lz4Output.close();
        }
        catch (IOException e) {
            throw new BackendException("Failed to compress", e);
        }
        return buf;
    }

    public static BytesBuffer decompress(byte[] bytes, int blockSize) {
        return LZ4Util.decompress(bytes, blockSize, 1.5f);
    }

    public static BytesBuffer decompress(byte[] bytes, int blockSize, float bufferRatio) {
        float ratio = bufferRatio <= 0.0f ? 1.5f : bufferRatio;
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4FastDecompressor decompressor = factory.fastDecompressor();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        int initBufferSize = Math.min(Math.round((float)bytes.length * ratio), 0x8000000);
        BytesBuffer buf = new BytesBuffer(initBufferSize);
        LZ4BlockInputStream lzInput = new LZ4BlockInputStream((InputStream)bais, decompressor);
        byte[] buffer = new byte[blockSize];
        try {
            int count;
            while ((count = lzInput.read(buffer)) != -1) {
                buf.write(buffer, 0, count);
            }
            lzInput.close();
        }
        catch (IOException e) {
            throw new BackendException("Failed to decompress", e);
        }
        return buf;
    }
}

