/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.util.E;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public final class ZipUtil {
    public static void compress(String rootDir, String sourceDir, String outputFile, Checksum checksum) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             CheckedOutputStream cos = new CheckedOutputStream(fos, checksum);
             BufferedOutputStream bos = new BufferedOutputStream(cos);
             ZipOutputStream zos = new ZipOutputStream(bos);){
            ZipUtil.compressDirectoryToZipFile(rootDir, sourceDir, zos);
            zos.flush();
            fos.getFD().sync();
        }
    }

    private static void compressDirectoryToZipFile(String rootDir, String sourceDir, ZipOutputStream zos) throws IOException {
        String dir = Paths.get(rootDir, sourceDir).toString();
        File[] files = new File(dir).listFiles();
        E.checkNotNull((Object)files, (String)"files");
        for (File file : files) {
            String child = Paths.get(sourceDir, file.getName()).toString();
            if (file.isDirectory()) {
                ZipUtil.compressDirectoryToZipFile(rootDir, child, zos);
                continue;
            }
            zos.putNextEntry(new ZipEntry(child));
            try (FileInputStream fis = new FileInputStream(file);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                IOUtils.copy((InputStream)bis, (OutputStream)zos);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decompress(String sourceFile, String outputDir, Checksum checksum) throws IOException {
        try (FileInputStream fis = new FileInputStream(sourceFile);
             CheckedInputStream cis = new CheckedInputStream(fis, checksum);
             BufferedInputStream bis = new BufferedInputStream(cis);
             ZipInputStream zis = new ZipInputStream(bis);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                FileOutputStream fos;
                block71: {
                    String fileName = entry.getName();
                    File entryFile = new File(Paths.get(outputDir, fileName).toString());
                    FileUtils.forceMkdir((File)entryFile.getParentFile());
                    fos = new FileOutputStream(entryFile);
                    Throwable throwable = null;
                    try {
                        try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
                            IOUtils.copy((InputStream)zis, (OutputStream)bos);
                            bos.flush();
                            fos.getFD().sync();
                        }
                        if (fos == null) continue;
                        if (throwable == null) break block71;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable == null) {
                                fos.close();
                                throw throwable3;
                            }
                            try {
                                fos.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            IOUtils.copy((InputStream)cis, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            return;
        }
    }
}

