/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.alarm;

import java.util.List;

/**
 * Created by liuzhenxing01 on 2018/10/22.
 */
public class AlarmPolicy {
    private List<SinkType> sinkTypes;

    private String alarmType;

    private AlarmTypeInfo alarmTypeInfo;

    public List<SinkType> getSinkTypes() {
        return sinkTypes;
    }

    public void setSinkTypes(List<SinkType> sinkTypes) {
        this.sinkTypes = sinkTypes;
    }

    public String getAlarmType() {
        return alarmType;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    public AlarmTypeInfo getAlarmTypeInfo() {
        return alarmTypeInfo;
    }

    public void setAlarmTypeInfo(AlarmTypeInfo alarmTypeInfo) {
        this.alarmTypeInfo = alarmTypeInfo;
    }

    public enum AlarmType {
        AT_ONCE("AT_ONCE"), AT_ONCE_WITH_NORMAL("AT_ONCE_WITH_NORMAL"),
        MULTI_NOTICE_WITH_NORMAL("MULTI_NOTICE_WITH_NORMAL");

        String alarmType;

        AlarmType(String alarmType) {
            this.alarmType = alarmType;
        }

        public String getAlarmType() {
            return this.alarmType;
        }
    }
}
