/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.map;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * get latest point request model
 * Created by liuzhenxing01 on 2018/10/22.
 */
public class GetLatestPointRequest extends AbstractRequest {
    private String vehicleId;
    private String processOption;
    private String coordTypeOutput;

    public String getVehicleId() {
        return vehicleId;
    }

    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public String getProcessOption() {
        return processOption;
    }

    public void setProcessOption(String processOption) {
        this.processOption = processOption;
    }

    public String getCoordTypeOutput() {
        return coordTypeOutput;
    }

    public void setCoordTypeOutput(String coordTypeOutput) {
        this.coordTypeOutput = coordTypeOutput;
    }

    @Override
    public Class responseType() {
        return GetLatestPointResponse.class;
    }

    public static class GetLatestPointResponse extends AbstractBceResponse {
        private GetTrackRequest.GeoInfo geoInfo;
        private Double limitSpeed;

        public GetTrackRequest.GeoInfo getGeoInfo() {
            return geoInfo;
        }

        public void setGeoInfo(GetTrackRequest.GeoInfo geoInfo) {
            this.geoInfo = geoInfo;
        }

        public Double getLimitSpeed() {
            return limitSpeed;
        }

        public void setLimitSpeed(Double limitSpeed) {
            this.limitSpeed = limitSpeed;
        }
    }
}
