/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.map;

import java.util.List;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * get the vehicle track request model
 * Created by liuzhenxing01 on 2018/10/22.
 */
public class GetTrackRequest extends AbstractRequest {

    private String vehicleId;
    private Long startTime;
    private Long endTime;
    private Integer isProcessed;
    private String processOption;
    private String supplementMode;
    private String coordTypeOutput;
    private String sortType;
    private Integer pageIndex;
    private Integer pageSize;

    public String getVehicleId() {
        return vehicleId;
    }

    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Integer getIsProcessed() {
        return isProcessed;
    }

    public void setIsProcessed(Integer isProcessed) {
        this.isProcessed = isProcessed;
    }

    public String getProcessOption() {
        return processOption;
    }

    public void setProcessOption(String processOption) {
        this.processOption = processOption;
    }

    public String getSupplementMode() {
        return supplementMode;
    }

    public void setSupplementMode(String supplementMode) {
        this.supplementMode = supplementMode;
    }

    public String getCoordTypeOutput() {
        return coordTypeOutput;
    }

    public void setCoordTypeOutput(String coordTypeOutput) {
        this.coordTypeOutput = coordTypeOutput;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public Class responseType() {
        return GetTrackResponse.class;
    }

    public static class GetTrackResponse extends AbstractBceResponse {
        private Integer total;
        private Integer size;
        private Double distance;
        private Double tollDistance;
        private LocationPoint startPoint;
        private LocationPoint endPoint;
        private List<GeoInfo> points;

        public Integer getTotal() {
            return total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getSize() {
            return size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Double getDistance() {
            return distance;
        }

        public void setDistance(Double distance) {
            this.distance = distance;
        }

        public Double getTollDistance() {
            return tollDistance;
        }

        public void setTollDistance(Double tollDistance) {
            this.tollDistance = tollDistance;
        }

        public LocationPoint getStartPoint() {
            return startPoint;
        }

        public void setStartPoint(LocationPoint startPoint) {
            this.startPoint = startPoint;
        }

        public LocationPoint getEndPoint() {
            return endPoint;
        }

        public void setEndPoint(LocationPoint endPoint) {
            this.endPoint = endPoint;
        }

        public List<GeoInfo> getPoints() {
            return points;
        }

        public void setPoints(List<GeoInfo> points) {
            this.points = points;
        }
    }

    public static class LocationPoint {
        private Double latitude;
        private Double longitude;
        private String coordType;
        private Long locTime;

        public Double getLatitude() {
            return latitude;
        }

        public void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public Double getLongitude() {
            return longitude;
        }

        public void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        public String getCoordType() {
            return coordType;
        }

        public void setCoordType(String coordType) {
            this.coordType = coordType;
        }

        public Long getLocTime() {
            return locTime;
        }

        public void setLocTime(Long locTime) {
            this.locTime = locTime;
        }
    }

    public static class GeoInfo {
        private Double latitude;
        private Double longitude;
        private Double radius;
        private Double speed;
        private Integer direction;
        private Double height;
        private Long locTime;

        public Double getLatitude() {
            return latitude;
        }

        public void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public Double getLongitude() {
            return longitude;
        }

        public void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        public Double getRadius() {
            return radius;
        }

        public void setRadius(Double radius) {
            this.radius = radius;
        }

        public Double getSpeed() {
            return speed;
        }

        public void setSpeed(Double speed) {
            this.speed = speed;
        }

        public Integer getDirection() {
            return direction;
        }

        public void setDirection(Integer direction) {
            this.direction = direction;
        }

        public Double getHeight() {
            return height;
        }

        public void setHeight(Double height) {
            this.height = height;
        }

        public Long getLocTime() {
            return locTime;
        }

        public void setLocTime(Long locTime) {
            this.locTime = locTime;
        }
    }
}