/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.shadow;

import java.util.List;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * query the vehicle status online
 * Created by liuzhenxing01 on 2018/10/31.
 */
public class QueryVehicleStatusRequest extends AbstractRequest {

    private List<String> vehicleIds;

    public List<String> getVehicleIds() {
        return vehicleIds;
    }

    public void setVehicleIds(List<String> vehicleIds) {
        this.vehicleIds = vehicleIds;
    }

    @Override
    public Class responseType() {
        return QueryVehicleStatusResponse.class;
    }

    public static class QueryVehicleStatusResponse extends AbstractBceResponse {

        private List<Vehicle> data;

        public List<Vehicle> getData() {
            return data;
        }

        public void setData(List<Vehicle> data) {
            this.data = data;
        }
    }

    public static class Vehicle {
        private String vehicleId;
        private String status;

        public String getVehicleId() {
            return vehicleId;
        }

        public void setVehicleId(String vehicleId) {
            this.vehicleId = vehicleId;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}
