/*
 * Copyright 2018 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.iothisk.model;

import static com.baidubce.services.iothisk.model.EncodeType.BASE64;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;

/**
 * Represent the request for HISK Device ID Activation.
 */
public class ActiveRequest extends AbstractBceRequest {

    /**
     * Device id activation message data, generated by SE.
     */
    private String data;

    /**
     * Cipher message data encoding type, default is base64.
     */
    private EncodeType type = BASE64;

    /**
     * Set device id activation message data.
     *
     * @param data device id activation message data
     */
    public void setData(String data) {
        this.data = data;
    }

    /**
     * Get device id activation message data.
     *
     * @return device id activation message data
     */
    public String getData() {
        return data;
    }

    /**
     * Set data encoding type.
     *
     * @param encodeType data encoding type.
     */
    public void setType(EncodeType encodeType) {
        this.type = encodeType;
    }

    /**
     * Get data encoding type.
     *
     * @return data encoding type.
     */
    public EncodeType getType() {
        return type;
    }

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return ActiveRequest with credentials.
     */
    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

}
