/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.common.utils;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateUtils {
    private static final String DEFAULT_TIMEZONE = "GMT+8";

    public static Date ceilDateMinute(Date date, int minStep) {
        Date tmpDate = org.apache.commons.lang3.time.DateUtils.setSeconds((Date)org.apache.commons.lang3.time.DateUtils.setMilliseconds((Date)date, (int)0), (int)0);
        Calendar calendar = org.apache.commons.lang3.time.DateUtils.toCalendar((Date)tmpDate);
        int minute = calendar.get(12);
        minute = Math.floorDiv(minute, minStep) * minStep;
        return org.apache.commons.lang3.time.DateUtils.setMinutes((Date)tmpDate, (int)minute);
    }

    public static Date parse(String pattern, String date, String timezone) throws ParseException {
        return FastDateFormat.getInstance((String)pattern, (TimeZone)TimeZone.getTimeZone(timezone)).parse(date);
    }

    public static Date parse(String pattern, String date) throws ParseException {
        return DateUtils.parse(pattern, date, DEFAULT_TIMEZONE);
    }

    public static String format(String pattern, Date date, String timezone) {
        return FastDateFormat.getInstance((String)pattern, (TimeZone)TimeZone.getTimeZone(timezone)).format(date);
    }

    public static String format(String pattern, Date date) {
        return DateUtils.format(pattern, date, DEFAULT_TIMEZONE);
    }

    public static final long diffBetween(Date fromDt, Date toDt) {
        if (fromDt == null || toDt == null) {
            throw new IllegalArgumentException("fromDt and toDt must not be null");
        }
        long fromTs = fromDt.getTime();
        long toTs = toDt.getTime();
        return toTs - fromTs;
    }
}

