/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4Qa\u0003\u0007\u0002\u0002EA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0006Y\u0001!\t\u0001\u000b\u0005\u0006[\u0001!\t\u0001\u000b\u0005\u0006[\u0001!\tA\f\u0005\u0006y\u0001!I!\u0010\u0005\u0006#\u0002!I\u0001\u000b\u0005\u0006%\u0002!\ta\u0015\u0005\u0006%\u00021\t!\u001b\u0002\u0016!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0015\tia\"\u0001\u0006d_:$(o\u001c7mKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eaR\"\u0001\u000e\u000b\u0005mq\u0011!B;uS2\u001c\u0018BA\u000f\u001b\u0005\u001daunZ4j]\u001e\f\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\t\u0001\u0013%D\u0001\r\u0013\t\u0011CBA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\fa\u0001P5oSRtDCA\u0013'!\t\u0001\u0003\u0001C\u0003\u001f\u0005\u0001\u0007q$A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003%\u0002\"a\u0005\u0016\n\u0005-\"\"\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\"iJLwmZ3s\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]N#\u0018\r^3DQ\u0006tw-\u001a\u000b\u0003S=BQ\u0001\r\u0004A\u0002E\nQ\u0001^8qS\u000e\u0004\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b\u0015\u001b\u0005)$B\u0001\u001c\u0011\u0003\u0019a$o\\8u}%\u0011\u0001\bF\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029)\u0005)CO]5hO\u0016\u0014xJ\u001c7j]\u0016\u001cF/\u0019;f\u0007\"\fgnZ3G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003SyBQaP\u0004A\u0002\u0001\u000b!\u0002]1si&$\u0018n\u001c8t!\r\tEIR\u0007\u0002\u0005*\u00111\tF\u0001\u000bG>dG.Z2uS>t\u0017BA#C\u0005\r\u0019V\r\u001e\t\u0003\u000f>k\u0011\u0001\u0013\u0006\u0003\u0013*\u000baaY8n[>t'BA\bL\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005AC%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0019S:LG/[1mSj,\u0007+\u0019:uSRLwN\\*uCR,\u0017A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$2\u0001\u00161e!\u0011\u0011TKR,\n\u0005Y[$aA'baB\u0011\u0001,\u0018\b\u00033ns!\u0001\u000e.\n\u0003UI!\u0001\u0018\u000b\u0002\u000fA\f7m[1hK&\u0011al\u0018\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\u0018\u000b\t\u000b}J\u0001\u0019A1\u0011\u0007a\u0013g)\u0003\u0002d?\n\u00191+Z9\t\u000b\u0015L\u0001\u0019\u00014\u0002\u0017Q\f'oZ3u'R\fG/\u001a\t\u0003A\u001dL!\u0001\u001b\u0007\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uKR!AK[6m\u0011\u0015y$\u00021\u0001b\u0011\u0015)'\u00021\u0001g\u0011\u0015i'\u00021\u0001o\u0003YaW-\u00193fe\u0016cWm\u0019;j_:\u001cFO]1uK\u001eL\bcA\npc&\u0011\u0001\u000f\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0001\u0012\u0018BA:\r\u0005}\u0001\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gn\u0015;sCR,w-\u001f")
public abstract class PartitionStateMachine
implements Logging {
    private final ControllerContext controllerContext;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void startup() {
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "Initializing partition state");
        this.initializePartitionState();
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "Triggering online partition state changes");
        this.triggerOnlinePartitionStateChange();
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Started partition state machine with initial state -> ").append($this.controllerContext.partitionStates()).toString());
    }

    public void shutdown() {
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "Stopped partition state machine");
    }

    public void triggerOnlinePartitionStateChange() {
        Set<TopicPartition> partitions = this.controllerContext.partitionsInStates((Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new PartitionState[]{OfflinePartition$.MODULE$, NewPartition$.MODULE$})));
        this.triggerOnlineStateChangeForPartitions(partitions);
    }

    public void triggerOnlinePartitionStateChange(String topic) {
        Set<TopicPartition> partitions = this.controllerContext.partitionsInStates(topic, (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new PartitionState[]{OfflinePartition$.MODULE$, NewPartition$.MODULE$})));
        this.triggerOnlineStateChangeForPartitions(partitions);
    }

    private void triggerOnlineStateChangeForPartitions(Set<TopicPartition> partitions) {
        Seq<TopicPartition> partitionsToTrigger = ((SetLike)partitions.filter((Function1<TopicPartition, Object> & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean(PartitionStateMachine.$anonfun$triggerOnlineStateChangeForPartitions$1(this, partition)))).toSeq();
        this.handleStateChanges(partitionsToTrigger, OnlinePartition$.MODULE$, new Some<PartitionLeaderElectionStrategy>(OfflinePartitionLeaderElectionStrategy$.MODULE$));
    }

    private void initializePartitionState() {
        this.controllerContext.allPartitions().foreach((Function1<TopicPartition, Object> & Serializable & scala.Serializable)topicPartition -> {
            PartitionStateMachine.$anonfun$initializePartitionState$1(this, topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public Map<TopicPartition, Throwable> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState) {
        return this.handleStateChanges(partitions, targetState, None$.MODULE$);
    }

    public abstract Map<TopicPartition, Throwable> handleStateChanges(Seq<TopicPartition> var1, PartitionState var2, Option<PartitionLeaderElectionStrategy> var3);

    public static final /* synthetic */ boolean $anonfun$triggerOnlineStateChangeForPartitions$1(PartitionStateMachine $this, TopicPartition partition) {
        return !$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic());
    }

    public static final /* synthetic */ void $anonfun$initializePartitionState$1(PartitionStateMachine $this, TopicPartition topicPartition) {
        Option option = $this.controllerContext.partitionLeadershipInfo().get(topicPartition);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
            if ($this.controllerContext.isReplicaOnline(currentLeaderIsrAndEpoch.leaderAndIsr().leader(), topicPartition, $this.controllerContext.isReplicaOnline$default$3())) {
                $this.controllerContext.putPartitionState(topicPartition, OnlinePartition$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.controllerContext.putPartitionState(topicPartition, OfflinePartition$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            $this.controllerContext.putPartitionState(topicPartition, NewPartition$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public PartitionStateMachine(ControllerContext controllerContext) {
        this.controllerContext = controllerContext;
        Logging.$init$(this);
    }
}

