/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001Q3Aa\u0002\u0005\u0001\u001f!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!)\u0004A!A!\u0002\u00131\u0004\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b\r\u0003A\u0011\u0001#\t\u000b)\u0003A\u0011I&\u0003SQ\u0013\u0018M\\:bGRLwN\\'be.,'OU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s\u0015\tI!\"A\u0006ue\u0006t7/Y2uS>t'BA\u0006\r\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u00035\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001!a\u0019\u0003CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005e\tS\"\u0001\u000e\u000b\u0005ma\u0012aB2mS\u0016tGo\u001d\u0006\u0003\u001buQ!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO&\u0011!E\u0007\u0002\u0019%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\bC\u0001\u0013(\u001b\u0005)#B\u0001\u0014\r\u0003\u0015)H/\u001b7t\u0013\tASEA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u00121!\u00138u\u0003=!\bP\\*uCR,W*\u00198bO\u0016\u0014\bC\u0001\u001a4\u001b\u0005A\u0011B\u0001\u001b\t\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'/A\fuq:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feB\u0011!gN\u0005\u0003q!\u0011q\u0004\u0016:b]N\f7\r^5p]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003U!\bP\\%e\u0003:$W*\u0019:lKJ,e\u000e\u001e:jKN\u00042a\u000f A\u001b\u0005a$BA\u001f\u0015\u0003\u0011)H/\u001b7\n\u0005}b$\u0001\u0002'jgR\u0004\"AM!\n\u0005\tC!a\u0005+y]&#\u0017I\u001c3NCJ\\WM]#oiJL\u0018A\u0002\u001fj]&$h\bF\u0003F\r\u001eC\u0015\n\u0005\u00023\u0001!)\u0011&\u0002a\u0001U!)\u0001'\u0002a\u0001c!)Q'\u0002a\u0001m!)\u0011(\u0002a\u0001u\u0005QqN\\\"p[BdW\r^3\u0015\u00051{\u0005CA\u0016N\u0013\tqEF\u0001\u0003V]&$\b\"\u0002)\u0007\u0001\u0004\t\u0016\u0001\u0003:fgB|gn]3\u0011\u0005e\u0011\u0016BA*\u001b\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\u0004")
public class TransactionMarkerRequestCompletionHandler
implements RequestCompletionHandler,
Logging {
    private final TransactionStateManager txnStateManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final List<TxnIdAndMarkerEntry> txnIdAndMarkerEntries;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionMarkerRequestCompletionHandler transactionMarkerRequestCompletionHandler = this;
        synchronized (transactionMarkerRequestCompletionHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void onComplete(ClientResponse response) {
        RequestHeader requestHeader = response.requestHeader();
        int correlationId = requestHeader.correlationId();
        if (response.wasDisconnected()) {
            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Cancelled request with header ").append(requestHeader).append(" due to node ").append(response.destination()).append(" being disconnected").toString());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.txnIdAndMarkerEntries).asScala()).foreach((Function1<TxnIdAndMarkerEntry, Object> & Serializable & scala.Serializable)txnIdAndMarker -> {
                TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$2(this, txnIdAndMarker);
                return BoxedUnit.UNIT;
            });
        } else {
            this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Received WriteTxnMarker response ").append(response).append(" from node ").append(response.destination()).append(" with correlation id ").append(correlationId).toString());
            WriteTxnMarkersResponse writeTxnMarkerResponse = (WriteTxnMarkersResponse)response.responseBody();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.txnIdAndMarkerEntries).asScala()).foreach((Function1<TxnIdAndMarkerEntry, Object> & Serializable & scala.Serializable)txnIdAndMarker -> {
                TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$8(this, writeTxnMarkerResponse, txnIdAndMarker);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$onComplete$2(TransactionMarkerRequestCompletionHandler $this, TxnIdAndMarkerEntry txnIdAndMarker) {
        BoxedUnit boxedUnit;
        Errors errors;
        String transactionalId = txnIdAndMarker.txnId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = txnIdAndMarker.txnMarkerEntry();
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)((Object)left.value());
            if (((Object)((Object)Errors.NOT_COORDINATOR)).equals((Object)errors2)) {
                $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(87).append("I am no longer the coordinator for ").append(transactionalId).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString());
                $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && ((Object)((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS)).equals((Object)(errors = (Errors)((Object)left.value())))) {
            $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(108).append("I am loading the transaction partition that contains ").append(transactionalId).append(" which means the current markers have to be obsoleted; ").append(new StringBuilder(50).append("cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString()).toString());
            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)((Object)left.value());
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append((Object)unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            }
        }
        if (!bl2) throw new MatchError(either);
        Option option = (Option)right.value();
        if (!(option instanceof Some)) throw new MatchError(either);
        Some some = (Some)option;
        CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
        if (epochAndMetadata.coordinatorEpoch() != txnMarker.coordinatorEpoch()) {
            $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Transaction coordinator epoch for ").append(transactionalId).append(" has changed from ").append(txnMarker.coordinatorEpoch()).append(" to ").append(new StringBuilder(52).append(epochAndMetadata.coordinatorEpoch()).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString()).toString());
            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Re-enqueuing ").append((Object)txnMarker.transactionResult()).append(" transaction markers for transactional id ").append(transactionalId).append(" ").append(new StringBuilder(24).append("under coordinator epoch ").append(txnMarker.coordinatorEpoch()).toString()).toString());
            $this.txnMarkerChannelManager.addTxnMarkersToBrokerQueue(transactionalId, txnMarker.producerId(), txnMarker.producerEpoch(), txnMarker.transactionResult(), txnMarker.coordinatorEpoch(), ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(txnMarker.partitions()).asScala()).toSet());
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit4 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$onComplete$13(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$onComplete$12(TransactionMarkerRequestCompletionHandler $this, Map errors$1, TransactionMetadata txnMetadata$1, String transactionalId$2, CoordinatorEpochAndTxnMetadata epochAndMetadata$2, Set retryPartitions$1, WriteTxnMarkersRequest.TxnMarkerEntry txnMarker$2, BooleanRef abortSending$1) {
        ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(errors$1).asScala()).withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$13(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$1 -> {
            Object object;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError(tuple2);
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            Errors error = (Errors)((Object)((Object)tuple2._2()));
            Errors errors = error;
            if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
                txnMetadata$1.removePartition(topicPartition);
                object = BoxedUnit.UNIT;
                return object;
            } else {
                boolean bl = ((Object)((Object)Errors.CORRUPT_MESSAGE)).equals((Object)errors) ? true : (((Object)((Object)Errors.MESSAGE_TOO_LARGE)).equals((Object)errors) ? true : (((Object)((Object)Errors.RECORD_LIST_TOO_LARGE)).equals((Object)errors) ? true : ((Object)((Object)Errors.INVALID_REQUIRED_ACKS)).equals((Object)errors)));
                if (bl) {
                    throw new IllegalStateException(new StringBuilder(51).append("Received fatal error ").append(error.exceptionName()).append(" while sending txn marker for ").append(transactionalId$2).toString());
                }
                boolean bl2 = ((Object)((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)).equals((Object)errors) ? true : (((Object)((Object)Errors.NOT_LEADER_FOR_PARTITION)).equals((Object)errors) ? true : (((Object)((Object)Errors.NOT_ENOUGH_REPLICAS)).equals((Object)errors) ? true : (((Object)((Object)Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND)).equals((Object)errors) ? true : ((Object)((Object)Errors.REQUEST_TIMED_OUT)).equals((Object)errors))));
                if (bl2) {
                    $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Sending ").append(transactionalId$2).append("'s transaction marker for partition ").append(topicPartition).append(" has failed with error ").append(error.exceptionName()).append(", retrying ").append(new StringBuilder(31).append("with current coordinator epoch ").append(epochAndMetadata$2.coordinatorEpoch()).toString()).toString());
                    object = retryPartitions$1.$plus$eq(topicPartition);
                    return object;
                } else {
                    boolean bl3 = ((Object)((Object)Errors.INVALID_PRODUCER_EPOCH)).equals((Object)errors) ? true : ((Object)((Object)Errors.TRANSACTION_COORDINATOR_FENCED)).equals((Object)errors);
                    if (bl3) {
                        $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Sending ").append(transactionalId$2).append("'s transaction marker for partition ").append(topicPartition).append(" has permanently failed with error ").append(error.exceptionName()).append(" ").append(new StringBuilder(96).append("with the current coordinator epoch ").append(epochAndMetadata$2.coordinatorEpoch()).append("; cancel sending any more transaction markers ").append(txnMarker$2).append(" to the brokers").toString()).toString());
                        $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId$2);
                        abortSending$1.elem = true;
                        object = BoxedUnit.UNIT;
                        return object;
                    } else {
                        boolean bl4 = ((Object)((Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT)).equals((Object)errors) ? true : ((Object)((Object)Errors.UNSUPPORTED_VERSION)).equals((Object)errors);
                        if (!bl4) throw new IllegalStateException(new StringBuilder(47).append("Unexpected error ").append(errors.exceptionName()).append(" while sending txn marker for ").append(transactionalId$2).toString());
                        $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Sending ").append(transactionalId$2).append("'s transaction marker from partition ").append(topicPartition).append(" has failed with ").append(new StringBuilder(60).append(" ").append(error.name()).append(". This partition will be removed from the set of partitions").toString()).append(" waiting for completion").toString());
                        txnMetadata$1.removePartition(topicPartition);
                        object = BoxedUnit.UNIT;
                    }
                }
            }
            return object;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$onComplete$8(TransactionMarkerRequestCompletionHandler $this, WriteTxnMarkersResponse writeTxnMarkerResponse$1, TxnIdAndMarkerEntry txnIdAndMarker) {
        BoxedUnit boxedUnit;
        Object object;
        Errors errors;
        String transactionalId = txnIdAndMarker.txnId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = txnIdAndMarker.txnMarkerEntry();
        Map<TopicPartition, Errors> errors2 = writeTxnMarkerResponse$1.errors(txnMarker.producerId());
        if (errors2 == null) {
            throw new IllegalStateException(new StringBuilder(75).append("WriteTxnMarkerResponse does not contain expected error map for producer id ").append(txnMarker.producerId()).toString());
        }
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors3 = (Errors)((Object)left.value());
            if (((Object)((Object)Errors.NOT_COORDINATOR)).equals((Object)errors3)) {
                $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(87).append("I am no longer the coordinator for ").append(transactionalId).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString());
                $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && ((Object)((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS)).equals((Object)(errors = (Errors)((Object)left.value())))) {
            $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(108).append("I am loading the transaction partition that contains ").append(transactionalId).append(" which means the current markers have to be obsoleted; ").append(new StringBuilder(50).append("cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString()).toString());
            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)((Object)left.value());
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append((Object)unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            }
        }
        if (!bl2) throw new MatchError(either);
        Option option = (Option)right.value();
        if (!(option instanceof Some)) throw new MatchError(either);
        Some some = (Some)option;
        CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
        GenTraversable retryPartitions = Set$.MODULE$.empty();
        BooleanRef abortSending = BooleanRef.create(false);
        if (epochAndMetadata.coordinatorEpoch() != txnMarker.coordinatorEpoch()) {
            $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Transaction coordinator epoch for ").append(transactionalId).append(" has changed from ").append(txnMarker.coordinatorEpoch()).append(" to ").append(new StringBuilder(52).append(epochAndMetadata.coordinatorEpoch()).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString()).toString());
            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
            abortSending.elem = true;
            object = BoxedUnit.UNIT;
        } else {
            object = txnMetadata.inLock(() -> TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$12($this, errors2, txnMetadata, transactionalId, epochAndMetadata, (Set)retryPartitions, txnMarker, abortSending));
        }
        if (!abortSending.elem) {
            if (retryPartitions.nonEmpty()) {
                $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Re-enqueuing ").append((Object)txnMarker.transactionResult()).append(" transaction markers for transactional id ").append(transactionalId).append(" ").append(new StringBuilder(24).append("under coordinator epoch ").append(txnMarker.coordinatorEpoch()).toString()).toString());
                $this.txnMarkerChannelManager.addTxnMarkersToBrokerQueue(transactionalId, txnMarker.producerId(), txnMarker.producerEpoch(), txnMarker.transactionResult(), txnMarker.coordinatorEpoch(), retryPartitions.toSet());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.txnMarkerChannelManager.completeSendMarkersForTxnId(transactionalId);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit4 = boxedUnit;
    }

    public TransactionMarkerRequestCompletionHandler(int brokerId, TransactionStateManager txnStateManager, TransactionMarkerChannelManager txnMarkerChannelManager, List<TxnIdAndMarkerEntry> txnIdAndMarkerEntries) {
        this.txnStateManager = txnStateManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.txnIdAndMarkerEntries = txnIdAndMarkerEntries;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(50).append("[Transaction Marker Request Completion Handler ").append(brokerId).append("]: ").toString());
    }
}

