/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.LogCleaner$;
import kafka.network.SocketServer$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.DynamicLogConfig$;
import kafka.server.DynamicThreadPool$;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class DynamicBrokerConfig$ {
    public static DynamicBrokerConfig$ MODULE$;
    private final scala.collection.mutable.Set<String> DynamicSecurityConfigs;
    private final scala.collection.mutable.Set<String> AllDynamicConfigs;
    private final Set<String> ClusterLevelListenerConfigs;
    private final scala.collection.mutable.Set<String> PerBrokerConfigs;
    private final Set<String> ListenerMechanismConfigs;
    private final Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    private final Regex ListenerConfigRegex;
    private final scala.collection.mutable.Set<String> DynamicPasswordConfigs;

    static {
        new DynamicBrokerConfig$();
    }

    public scala.collection.mutable.Set<String> DynamicSecurityConfigs() {
        return this.DynamicSecurityConfigs;
    }

    public scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return this.AllDynamicConfigs;
    }

    private Set<String> ClusterLevelListenerConfigs() {
        return this.ClusterLevelListenerConfigs;
    }

    private scala.collection.mutable.Set<String> PerBrokerConfigs() {
        return this.PerBrokerConfigs;
    }

    private Set<String> ListenerMechanismConfigs() {
        return this.ListenerMechanismConfigs;
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs() {
        return this.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    }

    public Regex ListenerConfigRegex() {
        return this.ListenerConfigRegex;
    }

    private scala.collection.mutable.Set<String> DynamicPasswordConfigs() {
        return this.DynamicPasswordConfigs;
    }

    public boolean isPasswordConfig(String name) {
        return this.DynamicPasswordConfigs().exists((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(name.endsWith(x$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string = name;
        String string2 = KafkaConfig$.MODULE$.LogRollTimeMillisProp();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl3 = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.LogRollTimeHoursProp();
            String string5 = string;
            bl3 = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl3) {
            return new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp()), Nil$.MODULE$));
        }
        String string6 = KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            bl2 = true;
        } else {
            String string8 = KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp();
            String string9 = string;
            bl2 = !(string8 != null ? !string8.equals(string9) : string9 != null);
        }
        if (bl2) {
            return new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp()), Nil$.MODULE$));
        }
        String string10 = KafkaConfig$.MODULE$.LogFlushIntervalMsProp();
        String string11 = string;
        if (string10 == null) {
            if (string11 == null) return new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogFlushIntervalMsProp()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp()), Nil$.MODULE$));
        } else if (string10.equals(string11)) {
            return new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogFlushIntervalMsProp()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp()), Nil$.MODULE$));
        }
        String string12 = KafkaConfig$.MODULE$.LogRetentionTimeMillisProp();
        String string13 = string;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            bl = true;
        } else {
            String string14 = KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp();
            String string15 = string;
            if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                bl = true;
            } else {
                String string16 = KafkaConfig$.MODULE$.LogRetentionTimeHoursProp();
                String string17 = string;
                bl = !(string16 != null ? !string16.equals(string17) : string17 != null);
            }
        }
        if (bl) {
            return new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)KafkaConfig$.MODULE$.LogRetentionTimeHoursProp()), Nil$.MODULE$)));
        }
        Option<List<String>> option = this.ListenerConfigRegex().unapplySeq(string);
        if (option.isEmpty()) return new $colon$colon<Nothing$>((Nothing$)((Object)name), Nil$.MODULE$);
        if (option.get() == null) return new $colon$colon<Nothing$>((Nothing$)((Object)name), Nil$.MODULE$);
        if (((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) return new $colon$colon<Nothing$>((Nothing$)((Object)name), Nil$.MODULE$);
        String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
        if (!matchListenerOverride) return new $colon$colon<Nothing$>((Nothing$)((Object)name), Nil$.MODULE$);
        Option mechanismConfig = this.ListenerMechanismConfigs().find((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(baseName.endsWith(x$1)));
        return new $colon$colon<Nothing$>((Nothing$)((Object)name), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)((String)mechanismConfig.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> baseName))), Nil$.MODULE$));
    }

    public void validateConfigs(Properties props, boolean perBrokerConfig) {
        block0: {
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Cannot update these configs dynamically");
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "These security configs can be dynamically updated only per-listener using the listener prefix");
            this.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            if (perBrokerConfig) break block0;
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Cannot update these configs at default cluster level, broker id must be specified");
        }
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$perBrokerConfigs(Properties props) {
        Set configNames = ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet();
        return ((SetLike)configNames.intersect(this.PerBrokerConfigs())).$plus$plus((GenTraversableOnce)configNames.filter((Function1<String, Object> & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean(this.perBrokerListenerConfig$1(name))));
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(Properties props) {
        return (Set)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(Properties props) {
        return (Set)this.DynamicSecurityConfigs().filter((Function1<Object, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(props.containsKey(x$1)));
    }

    public void kafka$server$DynamicBrokerConfig$$validateConfigTypes(Properties props) {
        Properties baseProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String v = (String)tuple2._2();
                Option<List<String>> option = MODULE$.ListenerConfigRegex().unapplySeq(string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
                    return baseProps.put(baseName, v);
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return baseProps.put(k, v);
        });
        DynamicConfig$Broker$.MODULE$.validate(baseProps);
    }

    public void addDynamicConfigs(ConfigDef configDef) {
        KafkaConfig$.MODULE$.configKeys().filterKeys((Function1<String, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(DynamicBrokerConfig$.$anonfun$addDynamicConfigs$1(elem))).values().foreach((Function1<ConfigDef.ConfigKey, ConfigDef> & Serializable & scala.Serializable)config -> configDef.define(config.name, config.type, config.defaultValue, config.validator, config.importance, config.documentation, config.group, config.orderInGroup, config.width, config.displayName, config.dependents, config.recommender));
    }

    public Map<String, String> dynamicConfigUpdateModes() {
        return JavaConverters$.MODULE$.mapAsJavaMapConverter(((TraversableOnce)this.AllDynamicConfigs().map((Function1<String, Tuple2> & Serializable & scala.Serializable)name -> {
            String mode = MODULE$.PerBrokerConfigs().contains((String)name) ? "per-broker" : "cluster-wide";
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), mode);
        }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$DynamicPasswordConfigs$1(Tuple2 x$1) {
        ConfigDef.Type type = ((ConfigDef.ConfigKey)x$1._2()).type;
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        return !(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null);
    }

    private static final void checkInvalidProps$1(Set invalidPropNames, String errorMessage) {
        if (invalidPropNames.nonEmpty()) {
            throw new ConfigException(new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final boolean perBrokerListenerConfig$1(String name) {
        boolean bl;
        String string = name;
        Option<List<String>> option = this.ListenerConfigRegex().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
            bl = !this.ClusterLevelListenerConfigs().contains(baseName);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$addDynamicConfigs$1(String elem) {
        return MODULE$.AllDynamicConfigs().contains(elem);
    }

    private DynamicBrokerConfig$() {
        MODULE$ = this;
        this.DynamicSecurityConfigs = JavaConverters$.MODULE$.asScalaSetConverter(SslConfigs.RECONFIGURABLE_CONFIGS).asScala();
        this.AllDynamicConfigs = this.DynamicSecurityConfigs().$plus$plus(LogCleaner$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicThreadPool$.MODULE$.ReconfigurableConfigs()).$plus$plus(Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MetricReporterClassesProp()}))).$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(SocketServer$.MODULE$.ReconfigurableConfigs());
        this.ClusterLevelListenerConfigs = (Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MaxConnectionsProp()}));
        this.PerBrokerConfigs = this.DynamicSecurityConfigs().$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$minus$minus(this.ClusterLevelListenerConfigs());
        this.ListenerMechanismConfigs = (Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.SaslJaasConfigProp()}));
        this.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs = (Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.truststore.location"}));
        this.ListenerConfigRegex = new StringOps(Predef$.MODULE$.augmentString("listener\\.name\\.[^.]*\\.(.*)")).r();
        Set passwordConfigs = ((MapLike)KafkaConfig$.MODULE$.configKeys().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(DynamicBrokerConfig$.$anonfun$DynamicPasswordConfigs$1(x$1)))).keySet();
        this.DynamicPasswordConfigs = (scala.collection.mutable.Set)this.AllDynamicConfigs().intersect(passwordConfigs);
    }
}

