/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.Constants$;
import kafka.server.QuotaType;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.SensorAccess;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcJ$sp;
import scala.runtime.java8.JFunction0$mcV$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0010!\u0001\u0015B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001BC\u0002\u0013%Q\b\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003?\u0011!Y\u0005A!b\u0001\n\u0013a\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011E\u0003!Q1A\u0005\nIC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u00063\u0002!\tA\u0017\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u0019q\u0007\u0001)A\u0005E\"9q\u000e\u0001b\u0001\n\u0013\u0001\bbBA\r\u0001\u0001\u0006I!\u001d\u0005\n\u00037\u0001\u0001\u0019!C\u0005\u0003;A\u0011\"!\n\u0001\u0001\u0004%I!a\n\t\u0011\u0005M\u0002\u0001)Q\u0005\u0003?A\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\t\u0011\u0005}\u0002\u0001)A\u0005\u0003sA\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000bBq!a\u0014\u0001\t\u0003\t\t\u0006C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003w\u0002A\u0011AAD\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\n9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d\u0006\u0003C\t\naa]3sm\u0016\u0014(\"A\u0012\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\n\u00173!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fMB\u0011Q\u0006M\u0007\u0002])\u0011qFI\u0001\u0006kRLGn]\u0005\u0003c9\u0012q\u0001T8hO&tw\r\u0005\u00024i5\t\u0001%\u0003\u00026A\ta!+\u001a9mS\u000e\f\u0017+^8uC\u000611m\u001c8gS\u001e,\u0012\u0001\u000f\t\u0003geJ!A\u000f\u0011\u0003;I+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u00148i\u001c8gS\u001e\fqaY8oM&<\u0007%A\u0004nKR\u0014\u0018nY:\u0016\u0003y\u0002\"a\u0010%\u000e\u0003\u0001S!\u0001P!\u000b\u0005\t\u001b\u0015AB2p[6|gN\u0003\u0002$\t*\u0011QIR\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tI\u0005IA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nqB]3qY&\u001c\u0017\r^5p]RK\b/Z\u000b\u0002\u001bB\u00111GT\u0005\u0003\u001f\u0002\u0012\u0011\"U;pi\u0006$\u0016\u0010]3\u0002!I,\u0007\u000f\\5dCRLwN\u001c+za\u0016\u0004\u0013\u0001\u0002;j[\u0016,\u0012a\u0015\t\u0003)Zk\u0011!\u0016\u0006\u0003_\u0005K!aV+\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bmcVLX0\u0011\u0005M\u0002\u0001\"\u0002\u001c\n\u0001\u0004A\u0004\"\u0002\u001f\n\u0001\u0004q\u0004\"B&\n\u0001\u0004i\u0005\"B)\n\u0001\u0004\u0019\u0016\u0001\u00027pG.,\u0012A\u0019\t\u0003G2l\u0011\u0001\u001a\u0006\u0003K\u001a\fQ\u0001\\8dWNT!a\u001a5\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002jU\u0006!Q\u000f^5m\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c3\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\fQ\u0001\\8dW\u0002\n1\u0003\u001e5s_R$H.\u001a3QCJ$\u0018\u000e^5p]N,\u0012!\u001d\t\u0006eN,\u0018\u0011A\u0007\u0002M&\u0011AO\u001a\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001<~\u001d\t98\u0010\u0005\u0002yQ5\t\u0011P\u0003\u0002{I\u00051AH]8pizJ!\u0001 \u0015\u0002\rA\u0013X\rZ3g\u0013\tqxP\u0001\u0004TiJLgn\u001a\u0006\u0003y\"\u0002b!a\u0001\u0002\u000e\u0005Ma\u0002BA\u0003\u0003\u0013q1\u0001_A\u0004\u0013\u0005I\u0013bAA\u0006Q\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u00111aU3r\u0015\r\tY\u0001\u000b\t\u0004O\u0005U\u0011bAA\fQ\t\u0019\u0011J\u001c;\u0002)QD'o\u001c;uY\u0016$\u0007+\u0019:uSRLwN\\:!\u0003\u0015\tXo\u001c;b+\t\ty\u0002E\u0002@\u0003CI1!a\tA\u0005\u0015\tVo\u001c;b\u0003%\tXo\u001c;b?\u0012*\u0017\u000f\u0006\u0003\u0002*\u0005=\u0002cA\u0014\u0002,%\u0019\u0011Q\u0006\u0015\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003cy\u0011\u0011!a\u0001\u0003?\t1\u0001\u001f\u00132\u0003\u0019\tXo\u001c;bA\u0005a1/\u001a8t_J\f5mY3tgV\u0011\u0011\u0011\b\t\u0004g\u0005m\u0012bAA\u001fA\ta1+\u001a8t_J\f5mY3tg\u0006i1/\u001a8t_J\f5mY3tg\u0002\naB]1uK6+GO]5d\u001d\u0006lW-\u0006\u0002\u0002FA!\u0011qIA%\u001b\u0005\t\u0015bAA&\u0003\nQQ*\u001a;sS\u000et\u0015-\\3\u0002\u001fI\fG/Z'fiJL7MT1nK\u0002\n1\"\u001e9eCR,\u0017+^8uCR!\u0011\u0011FA*\u0011\u001d\tY\"\u0006a\u0001\u0003?\tq\"[:Rk>$\u0018-\u0012=dK\u0016$W\rZ\u000b\u0003\u00033\u00022aJA.\u0013\r\ti\u0006\u000b\u0002\b\u0005>|G.Z1o\u0003-I7\u000f\u00165s_R$H.\u001a3\u0015\t\u0005e\u00131\r\u0005\b\u0003K:\u0002\u0019AA4\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!a\u0012\u0002j%\u0019\u00111N!\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00061!/Z2pe\u0012$B!!\u000b\u0002r!9\u00111\u000f\rA\u0002\u0005U\u0014!\u0002<bYV,\u0007cA\u0014\u0002x%\u0019\u0011\u0011\u0010\u0015\u0003\t1{gnZ\u0001\u000e[\u0006\u00148\u000e\u00165s_R$H.\u001a3\u0015\r\u0005%\u0012qPAB\u0011\u0019\t\t)\u0007a\u0001k\u0006)Ao\u001c9jG\"9\u0011QQ\rA\u0002\u0005\u0005\u0011A\u00039beRLG/[8ogR!\u0011\u0011FAE\u0011\u0019\t\tI\u0007a\u0001k\u0006q!/Z7pm\u0016$\u0006N]8ui2,G\u0003BA\u0015\u0003\u001fCa!!!\u001c\u0001\u0004)\u0018AC;qa\u0016\u0014(i\\;oIR\u0011\u0011QO\u0001\u0015O\u0016$\u0018+^8uC6+GO]5d\u0007>tg-[4\u0015\t\u0005e\u0015q\u0014\t\u0004\u007f\u0005m\u0015bAAO\u0001\naQ*\u001a;sS\u000e\u001cuN\u001c4jO\"9\u00111D\u000fA\u0002\u0005}\u0011AB:f]N|'\u000f\u0006\u0002\u0002&B\u0019q(a*\n\u0007\u0005%\u0006I\u0001\u0004TK:\u001cxN\u001d")
public class ReplicationQuotaManager
implements Logging,
ReplicaQuota {
    private final ReplicationQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType replicationType;
    private final Time time;
    private final ReentrantReadWriteLock lock;
    private final ConcurrentHashMap<String, Seq<Object>> throttledPartitions;
    private Quota quota;
    private final SensorAccess sensorAccess;
    private final MetricName rateMetricName;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicationQuotaManager replicationQuotaManager = this;
        synchronized (replicationQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ReplicationQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private QuotaType replicationType() {
        return this.replicationType;
    }

    private Time time() {
        return this.time;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ConcurrentHashMap<String, Seq<Object>> throttledPartitions() {
        return this.throttledPartitions;
    }

    private Quota quota() {
        return this.quota;
    }

    private void quota_$eq(Quota x$1) {
        this.quota = x$1;
    }

    private SensorAccess sensorAccess() {
        return this.sensorAccess;
    }

    private MetricName rateMetricName() {
        return this.rateMetricName;
    }

    public void updateQuota(Quota quota) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0$mcV$sp & scala.Serializable)() -> {
            block0: {
                this.quota_$eq(quota);
                KafkaMetric metric = this.metrics().metrics().get(this.rateMetricName());
                if (metric == null) break block0;
                metric.config(this.getQuotaMetricConfig(quota));
            }
        });
    }

    @Override
    public boolean isQuotaExceeded() {
        try {
            this.sensor().checkQuotas();
        }
        catch (QuotaViolationException qve) {
            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("%s: Quota violated for sensor (%s), metric: (%s), metric-value: (%f), bound: (%f)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.replicationType(), this.sensor().name(), qve.metricName(), BoxesRunTime.boxToDouble(qve.value()), BoxesRunTime.boxToDouble(qve.bound())})));
            return true;
        }
        return false;
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        Seq<Object> partitions = this.throttledPartitions().get(topicPartition.topic());
        return partitions != null ? partitions == Constants$.MODULE$.AllReplicas() || partitions.contains(BoxesRunTime.boxToInteger(topicPartition.partition())) : false;
    }

    @Override
    public void record(long value) {
        try {
            this.sensor().record(value);
        }
        catch (QuotaViolationException qve) {
            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Record: Quota violated, but ignored, for sensor (").append(this.sensor().name()).append("), metric: (").append(qve.metricName()).append("), value : (").append(qve.value()).append("), bound: (").append(qve.bound()).append("), recordedValue (").append(value).append(")").toString());
        }
    }

    public void markThrottled(String topic, Seq<Object> partitions) {
        this.throttledPartitions().put(topic, partitions);
    }

    public void markThrottled(String topic) {
        this.markThrottled(topic, Constants$.MODULE$.AllReplicas());
    }

    public void removeThrottle(String topic) {
        this.throttledPartitions().remove(topic);
    }

    public long upperBound() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.lock(), (JFunction0$mcJ$sp & scala.Serializable)() -> this.quota() != null ? (long)this.quota().bound() : Long.MAX_VALUE));
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow(this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    private Sensor sensor() {
        return this.sensorAccess().getOrCreate(this.replicationType().toString(), ReplicationQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<MetricName> & Serializable & scala.Serializable)() -> this.rateMetricName(), (Function0<Option<MetricConfig>>)(Function0<Some> & Serializable & scala.Serializable)() -> new Some<MetricConfig>(this.getQuotaMetricConfig(this.quota())), (Function0<MeasurableStat>)(Function0<SimpleRate> & Serializable & scala.Serializable)() -> new SimpleRate());
    }

    public ReplicationQuotaManager(ReplicationQuotaManagerConfig config, Metrics metrics, QuotaType replicationType, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.replicationType = replicationType;
        this.time = time;
        Logging.$init$(this);
        this.lock = new ReentrantReadWriteLock();
        this.throttledPartitions = new ConcurrentHashMap();
        this.quota = null;
        this.sensorAccess = new SensorAccess(this.lock(), metrics);
        this.rateMetricName = metrics.metricName("byte-rate", replicationType.toString(), new StringBuilder(23).append("Tracking byte-rate for ").append(replicationType).toString());
    }
}

