/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rEt!B$I\u0011\u0003ie!B(I\u0011\u0003\u0001\u0006\"B,\u0002\t\u0003A\u0006\u0002C-\u0002\u0005\u0004%\t\u0001\u0013.\t\r\r\f\u0001\u0015!\u0003\\\u0011\u0015!\u0017\u0001\"\u0001f\u0011\u0015A\u0018\u0001\"\u0003z\u0011\u001d\t)!\u0001C\u0005\u0003\u000fA\u0001\"a\u0003\u0002\t\u0003A\u0015Q\u0002\u0005\t\u00037\nA\u0011\u0001%\u0002^\u0019I\u0011qW\u0001\u0011\u0002G%\u0011\u0011\u0018\u0005\b\u0003{Sa\u0011AA`\r\u0019\u0011\u0019!\u0001\u0003\u0003\u0006!Q!1\u0003\u0007\u0003\u0002\u0003\u0006IA!\u0006\t\u0015\t\u0005BB!A!\u0002\u0013\u0011\u0019\u0003\u0003\u0004X\u0019\u0011\u0005!Q\u0005\u0005\b\u0003{cA\u0011\tB\u0017\r\u0019\u00119$\u0001\u0003\u0003:!1q+\u0005C\u0001\u0005{Aq!!0\u0012\t\u0003\u0012\tE\u0002\u0004\u0003J\u0005!!1\n\u0005\u0007/R!\tA!\u0014\t\u000f\tEC\u0003\"\u0003\u0003T!9!\u0011\r\u000b\u0005\n\t\r\u0004b\u0002BJ)\u0011%!Q\u0013\u0005\b\u0003{#B\u0011\tBS\u0011\u001d\u0011I+\u0001C\u0005\u0005WCqA!5\u0002\t\u0013\u0011\u0019N\u0002\u0004\u0002n\u0005\u0001\u0011q\u000e\u0005\u0007/r!\t!!\u001d\t\u0013\u0005MDD1A\u0005\u0002\u0005U\u0004\u0002CA@9\u0001\u0006I!a\u001e\t\u0013\u0005\u0005ED1A\u0005\u0002\u0005U\u0004\u0002CAB9\u0001\u0006I!a\u001e\t\u0013\u0005\u0015ED1A\u0005\u0002\u0005U\u0004\u0002CAD9\u0001\u0006I!a\u001e\t\u000f\u0005%E\u0004\"\u0001\u0002\f\"9\u0011q\u0013\u000f\u0005\u0002\u0005e\u0005bBAR9\u0011\u0005\u0011Q\u0015\u0005\b\u0003ccB\u0011AAZ\r\u0019\u0011Y/\u0001\u0003\u0003n\"Q!\u000e\u000bB\u0001B\u0003%1Na?\t\r]CC\u0011\u0001B\u007f\u0011%\u0019\u0019\u0001\u000bb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\u0014!\u0002\u000b\u0011BB\u0004\u0011%\u0019)\u0002\u000bb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\u0018!\u0002\u000b\u0011BB\u0004\u0011%\u0019I\u0002\u000bb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\u001c!\u0002\u000b\u0011BB\u0004\u0011%\u0019i\u0002\u000bb\u0001\n\u0003\u0019y\u0002\u0003\u0005\u0004(!\u0002\u000b\u0011BB\u0011\u0011%\u0019I\u0003\u000bb\u0001\n\u0003\u0019Y\u0003\u0003\u0005\u00046!\u0002\u000b\u0011BB\u0017\u0011%\u00199\u0004\u000bb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004:!\u0002\u000b\u0011BB\u0004\u0011%\u0019Y\u0004\u000bb\u0001\n\u0003\u0019i\u0004\u0003\u0005\u0004B!\u0002\u000b\u0011BB \u0011%\u0019\u0019\u0005\u000bb\u0001\n\u0003\u0019i\u0004\u0003\u0005\u0004F!\u0002\u000b\u0011BB \u0011%\u00199\u0005\u000bb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004J!\u0002\u000b\u0011BB\u0004\u0011%\u0019Y\u0005\u000bb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004N!\u0002\u000b\u0011BB\u0004\u0011\u001d\u0019y\u0005\u000bC\u0001\u0007#B!ba\u0019)\u0011\u000b\u0007I\u0011AB3\u0011)\u0011I\f\u000bEC\u0002\u0013\u00051Q\r\u0005\u000b\u0003;A\u0003R1A\u0005\u0002\r\u0015\u0004BCA\nQ!\u0015\r\u0011\"\u0001\u0004f!Q1q\r\u0015\t\u0006\u0004%\ta!\u001b\t\u0015\u0005M\u0003\u0006#b\u0001\n\u0003\u0019i\u0007C\u0004\u0004p!\"\t!a-\u0002\u001f\u0011+X\u000e\u001d'pON+w-\\3oiNT!!\u0013&\u0002\u000bQ|w\u000e\\:\u000b\u0003-\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002O\u00035\t\u0001JA\bEk6\u0004Hj\\4TK\u001elWM\u001c;t'\t\t\u0011\u000b\u0005\u0002S+6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16K\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u000bABU3d_J$\u0017J\u001c3f]R,\u0012a\u0017\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000bA\u0001\\1oO*\t\u0001-\u0001\u0003kCZ\f\u0017B\u00012^\u0005\u0019\u0019FO]5oO\u0006i!+Z2pe\u0012Le\u000eZ3oi\u0002\nA!\\1j]R\u0011a-\u001b\t\u0003%\u001eL!\u0001[*\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\u0016\u0001\ra[\u0001\u0005CJ<7\u000fE\u0002SY:L!!\\*\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=4hB\u00019u!\t\t8+D\u0001s\u0015\t\u0019H*\u0001\u0004=e>|GOP\u0005\u0003kN\u000ba\u0001\u0015:fI\u00164\u0017B\u00012x\u0015\t)8+\u0001\u0007ek6\u0004H\u000b\u001f8J]\u0012,\u0007\u0010\u0006\u0002gu\")1P\u0002a\u0001y\u0006!a-\u001b7f!\ri\u0018\u0011A\u0007\u0002}*\u0011qpX\u0001\u0003S>L1!a\u0001\u007f\u0005\u00111\u0015\u000e\\3\u0002-\u0011,X\u000e\u001d)s_\u0012,8-\u001a:JINs\u0017\r]:i_R$2AZA\u0005\u0011\u0015Yx\u00011\u0001}\u0003%!W/\u001c9J]\u0012,\u0007\u0010F\u0006g\u0003\u001f\t\t\"a\u0007\u0002 \u0005E\u0003\"B>\t\u0001\u0004a\bbBA\n\u0011\u0001\u0007\u0011QC\u0001\u0010S:$W\r_*b]&$\u0018p\u00148msB\u0019!+a\u0006\n\u0007\u0005e1KA\u0004C_>dW-\u00198\t\u000f\u0005u\u0001\u00021\u0001\u0002\u0016\u0005Qa/\u001a:jMf|e\u000e\\=\t\u000f\u0005\u0005\u0002\u00021\u0001\u0002$\u0005QR.[:NCR\u001c\u0007.Z:G_JLe\u000eZ3y\r&dWm]'baB9\u0011QEA\u0018]\u0006MRBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u000f5,H/\u00192mK*\u0019\u0011QF*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00022\u0005\u001d\"aA'baB1\u0011QGA \u0003\u000brA!a\u000e\u0002<9\u0019\u0011/!\u000f\n\u0003QK1!!\u0010T\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0011\u0002D\t!A*[:u\u0015\r\tid\u0015\t\b%\u0006\u001d\u00131JA&\u0013\r\tIe\u0015\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007I\u000bi%C\u0002\u0002PM\u0013A\u0001T8oO\"9\u00111\u000b\u0005A\u0002\u0005U\u0013AD7bq6+7o]1hKNK'0\u001a\t\u0004%\u0006]\u0013bAA-'\n\u0019\u0011J\u001c;\u0002\u001b\u0011,X\u000e\u001d+j[\u0016Le\u000eZ3y)-1\u0017qLA1\u0003G\n)'!.\t\u000bmL\u0001\u0019\u0001?\t\u000f\u0005M\u0011\u00021\u0001\u0002\u0016!9\u0011QD\u0005A\u0002\u0005U\u0001bBA4\u0013\u0001\u0007\u0011\u0011N\u0001\u0014i&lW-\u00138eKb$U/\u001c9FeJ|'o\u001d\t\u0004\u0003WbR\"A\u0001\u0003'QKW.Z%oI\u0016DH)^7q\u000bJ\u0014xN]:\u0014\u0005q\tFCAA5\u0003yi\u0017n]'bi\u000eDWm\u001d$peRKW.Z%oI\u0016Dh)\u001b7fg6\u000b\u0007/\u0006\u0002\u0002xA9\u0011QEA\u0018]\u0006e\u0004CBA\u0013\u0003w\n)%\u0003\u0003\u0002~\u0005\u001d\"aC!se\u0006L()\u001e4gKJ\fq$\\5t\u001b\u0006$8\r[3t\r>\u0014H+[7f\u0013:$W\r\u001f$jY\u0016\u001cX*\u00199!\u0003MyW\u000f^(g\u001fJ$WM\u001d+j[\u0016\u001cH/Y7q\u0003QyW\u000f^(g\u001fJ$WM\u001d+j[\u0016\u001cH/Y7qA\u0005)2\u000f[1mY><xJ\u001a4tKRtu\u000e\u001e$pk:$\u0017AF:iC2dwn^(gMN,GOT8u\r>,h\u000e\u001a\u0011\u0002/I,7m\u001c:e\u001b&\u001cX.\u0019;dQRKW.Z%oI\u0016DHc\u00024\u0002\u000e\u0006=\u00151\u0013\u0005\u0006w\u0012\u0002\r\u0001 \u0005\b\u0003##\u0003\u0019AA&\u00039Ig\u000eZ3y)&lWm\u001d;b[BDq!!&%\u0001\u0004\tY%\u0001\u0007m_\u001e$\u0016.\\3ti\u0006l\u0007/\u0001\u0010sK\u000e|'\u000fZ(vi>3wJ\u001d3fe&sG-\u001a=US6,7\u000f^1naR9a-a'\u0002\u001e\u0006}\u0005\"B>&\u0001\u0004a\bbBAIK\u0001\u0007\u00111\n\u0005\b\u0003C+\u0003\u0019AA&\u0003I\u0001(/\u001a<J]\u0012,\u0007\u0010V5nKN$\u0018-\u001c9\u00027I,7m\u001c:e'\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8e)\u001d1\u0017qUAU\u0003[CQa\u001f\u0014A\u0002qDq!a+'\u0001\u0004\tY%A\u0006j]\u0012,\u0007p\u00144gg\u0016$\bbBAXM\u0001\u0007\u00111J\u0001\nY><wJ\u001a4tKR\f1\u0002\u001d:j]R,%O]8sgR\ta\rC\u0004\u0002T%\u0001\r!!\u0016\u0003\u001b5+7o]1hKB\u000b'o]3s+\u0019\tY,!4\u0002dN\u0011!\"U\u0001\u0006a\u0006\u00148/\u001a\u000b\u0005\u0003\u0003\f9\u000fE\u0004S\u0003\u000f\n\u0019-a8\u0011\u000bI\u000b)-!3\n\u0007\u0005\u001d7K\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0017\fi\r\u0004\u0001\u0005\u000f\u0005='B1\u0001\u0002R\n\t1*\u0005\u0003\u0002T\u0006e\u0007c\u0001*\u0002V&\u0019\u0011q[*\u0003\u000f9{G\u000f[5oOB\u0019!+a7\n\u0007\u0005u7KA\u0002B]f\u0004RAUAc\u0003C\u0004B!a3\u0002d\u00129\u0011Q\u001d\u0006C\u0002\u0005E'!\u0001,\t\u000f\u0005%8\u00021\u0001\u0002l\u00061!/Z2pe\u0012\u0004B!!<\u0002\u00006\u0011\u0011q\u001e\u0006\u0005\u0003S\f\tP\u0003\u0003\u0002t\u0006U\u0018AB2p[6|gNC\u0002L\u0003oTA!!?\u0002|\u00061\u0011\r]1dQ\u0016T!!!@\u0002\u0007=\u0014x-\u0003\u0003\u0003\u0002\u0005=(A\u0002*fG>\u0014HM\u0001\u000bEK\u000e|G-\u001a:NKN\u001c\u0018mZ3QCJ\u001cXM]\u000b\u0007\u0005\u000f\u0011iA!\u0005\u0014\t1\t&\u0011\u0002\t\b\u0003WR!1\u0002B\b!\u0011\tYM!\u0004\u0005\u000f\u0005=GB1\u0001\u0002RB!\u00111\u001aB\t\t\u001d\t)\u000f\u0004b\u0001\u0003#\f!b[3z\t\u0016\u001cw\u000eZ3s!\u0019\u00119B!\b\u0003\f5\u0011!\u0011\u0004\u0006\u0004\u00057Q\u0015AC:fe&\fG.\u001b>fe&!!q\u0004B\r\u0005\u001d!UmY8eKJ\fAB^1mk\u0016$UmY8eKJ\u0004bAa\u0006\u0003\u001e\t=AC\u0002B\u0014\u0005S\u0011Y\u0003E\u0004\u0002l1\u0011YAa\u0004\t\u000f\tMq\u00021\u0001\u0003\u0016!9!\u0011E\bA\u0002\t\rB\u0003\u0002B\u0018\u0005k\u0001rAUA$\u0005c\u0011\u0019\u0004E\u0003S\u0003\u000b\u0014Y\u0001E\u0003S\u0003\u000b\u0014y\u0001C\u0004\u0002jB\u0001\r!a;\u00037Q\u0013\u0018M\\:bGRLwN\u001c'pO6+7o]1hKB\u000b'o]3s'\u0011\t\u0012Ka\u000f\u0011\u000b\u0005-$B\u001c8\u0015\u0005\t}\u0002cAA6#Q!!1\tB$!\u001d\u0011\u0016q\tB#\u0005\u000b\u0002BAUAc]\"9\u0011\u0011^\nA\u0002\u0005-(\u0001F(gMN,Go]'fgN\fw-\u001a)beN,'o\u0005\u0003\u0015#\nmBC\u0001B(!\r\tY\u0007F\u0001\u0004Q\u0016DHc\u00018\u0003V!9!q\u000b\fA\u0002\te\u0013!\u00022zi\u0016\u001c\b\u0003\u0002*m\u00057\u00022A\u0015B/\u0013\r\u0011yf\u0015\u0002\u0005\u0005f$X-\u0001\u0007qCJ\u001cXm\u00144gg\u0016$8\u000f\u0006\u0004\u0003f\t=$1\u0011\t\b%\u0006\u001d#q\rB7!\u0011\u0011&\u0011\u000e8\n\u0007\t-4K\u0001\u0003T_6,\u0007\u0003\u0002*\u0003jmCqA!\u001d\u0018\u0001\u0004\u0011\u0019(A\u0005pM\u001a\u001cX\r^&fsB!!Q\u000fB@\u001b\t\u00119H\u0003\u0003\u0003z\tm\u0014!B4s_V\u0004(b\u0001B?\u0015\u0006Y1m\\8sI&t\u0017\r^8s\u0013\u0011\u0011\tIa\u001e\u0003\u0013=3gm]3u\u0017\u0016L\bb\u0002BC/\u0001\u0007!qQ\u0001\ba\u0006LHn\\1e!\u0011\u0011IIa$\u000e\u0005\t-%b\u0001BG?\u0006\u0019a.[8\n\t\tE%1\u0012\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018A\u00059beN,wI]8va6+G/\u00193bi\u0006$bAa&\u0003\u001a\n\r\u0006c\u0002*\u0002H\t\u001d$q\r\u0005\b\u00057C\u0002\u0019\u0001BO\u0003A9'o\\;q\u001b\u0016$\u0018\rZ1uC.+\u0017\u0010\u0005\u0003\u0003v\t}\u0015\u0002\u0002BQ\u0005o\u0012\u0001c\u0012:pkBlU\r^1eCR\f7*Z=\t\u000f\t\u0015\u0005\u00041\u0001\u0003\bR!!1\tBT\u0011\u001d\tI/\u0007a\u0001\u0003W\fq\u0001Z;na2{w\rF\u0007g\u0005[\u0013yKa-\u00038\nm&Q\u0018\u0005\u0006wj\u0001\r\u0001 \u0005\b\u0005cS\u0002\u0019AA\u000b\u00035\u0001(/\u001b8u\u0007>tG/\u001a8ug\"9!Q\u0017\u000eA\u0002\u0005\r\u0012!\t8p]\u000e{gn]3dkRLg/\u001a)bSJ\u001chi\u001c:M_\u001e4\u0015\u000e\\3t\u001b\u0006\u0004\bb\u0002B]5\u0001\u0007\u0011QC\u0001\u0010SN$U-\u001a9Ji\u0016\u0014\u0018\r^5p]\"9\u00111\u000b\u000eA\u0002\u0005U\u0003b\u0002B`5\u0001\u0007!\u0011Y\u0001\u0007a\u0006\u00148/\u001a:1\r\t\r'q\u0019Bg!\u001d\tYG\u0003Bc\u0005\u0017\u0004B!a3\u0003H\u0012a!\u0011\u001aB_\u0003\u0003\u0005\tQ!\u0001\u0002R\n\u0019q\fJ\u0019\u0011\t\u0005-'Q\u001a\u0003\r\u0005\u001f\u0014i,!A\u0001\u0002\u000b\u0005\u0011\u0011\u001b\u0002\u0004?\u0012\u0012\u0014a\u00049sS:$()\u0019;dQ2+g/\u001a7\u0015\u000b\u0019\u0014)Na:\t\u000f\t]7\u00041\u0001\u0003Z\u0006)!-\u0019;dQB!!1\u001cBq\u001d\u0011\tiO!8\n\t\t}\u0017q^\u0001\u0013\r&dW\rT8h\u0013:\u0004X\u000f^*ue\u0016\fW.\u0003\u0003\u0003d\n\u0015(A\u0006$jY\u0016\u001c\u0005.\u00198oK2\u0014VmY8sI\n\u000bGo\u00195\u000b\t\t}\u0017q\u001e\u0005\b\u0005S\\\u0002\u0019AA&\u0003E\t7mY;nk2\fG/\u001b<f\u0005f$Xm\u001d\u0002\u0017\tVl\u0007\u000fT8h'\u0016<W.\u001a8ug>\u0003H/[8ogN\u0019\u0001Fa<\u0011\t\tE(q_\u0007\u0003\u0005gT1A!>K\u0003\u0015)H/\u001b7t\u0013\u0011\u0011IPa=\u0003+\r{W.\\1oI\u0012+g-Y;mi>\u0003H/[8og&\u0019!Na>\u0015\t\t}8\u0011\u0001\t\u0004\u0003WB\u0003\"\u00026+\u0001\u0004Y\u0017\u0001\u00039sS:$x\n\u001d;\u0016\u0005\r\u001d\u0001\u0003BB\u0005\u0007\u001fi!aa\u0003\u000b\u0005\r5\u0011A\u00036paR\u001c\u0018.\u001c9mK&!1\u0011CB\u0006\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM]\u0001\naJLg\u000e^(qi\u0002\n\u0011B^3sS\u001aLx\n\u001d;\u0002\u0015Y,'/\u001b4z\u001fB$\b%\u0001\bj]\u0012,\u0007pU1oSRLx\n\u001d;\u0002\u001f%tG-\u001a=TC:LG/_(qi\u0002\n\u0001BZ5mKN|\u0005\u000f^\u000b\u0003\u0007C\u0001Ra!\u0003\u0004$9LAa!\n\u0004\f\tY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000e\f\u0011BZ5mKN|\u0005\u000f\u001e\u0011\u0002#5\f\u00070T3tg\u0006<WmU5{K>\u0003H/\u0006\u0002\u0004.A11\u0011BB\u0012\u0007_\u00012\u0001XB\u0019\u0013\r\u0019\u0019$\u0018\u0002\b\u0013:$XmZ3s\u0003Ii\u0017\r_'fgN\fw-Z*ju\u0016|\u0005\u000f\u001e\u0011\u0002!\u0011,W\r]%uKJ\fG/[8o\u001fB$\u0018!\u00053fKBLE/\u001a:bi&|gn\u00149uA\u0005ya/\u00197vK\u0012+7m\u001c3fe>\u0003H/\u0006\u0002\u0004@A)1\u0011BB\u00127\u0006\u0001b/\u00197vK\u0012+7m\u001c3fe>\u0003H\u000fI\u0001\u000eW\u0016LH)Z2pI\u0016\u0014x\n\u001d;\u0002\u001d-,\u0017\u0010R3d_\u0012,'o\u00149uA\u0005QqN\u001a4tKR\u001cx\n\u001d;\u0002\u0017=4gm]3ug>\u0003H\u000fI\u0001\u0012iJ\fgn]1di&|g\u000eT8h\u001fB$\u0018A\u0005;sC:\u001c\u0018m\u0019;j_:dunZ(qi\u0002\nQ\"\\3tg\u0006<W\rU1sg\u0016\u0014XCAB*a\u0019\u0019)f!\u0017\u0004`A9\u00111\u000e\u0006\u0004X\ru\u0003\u0003BAf\u00073\"1ba\u0017@\u0003\u0003\u0005\tQ!\u0001\u0002R\n\u0019q\fJ\u001a\u0011\t\u0005-7q\f\u0003\f\u0007Cz\u0014\u0011!A\u0001\u0006\u0003\t\tNA\u0002`IQ\n!c\u001d5pk2$\u0007K]5oi\u0012\u000bG/\u0019'pOV\u0011\u0011QC\u0001\u0006M&dWm]\u000b\u0003\u0007W\u00022A\u00157\\+\t\t)&A\u0005dQ\u0016\u001c7.\u0011:hg\u0002")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    public static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            Tuple2<None$, Some<V>> tuple2;
            if (!record.hasValue()) {
                tuple2 = new Tuple2<None$, Some<V>>(None$.MODULE$, None$.MODULE$);
            } else {
                Option key = record.hasKey() ? new Some<K>(this.keyDecoder.fromBytes(Utils.readBytes(record.key()))) : None$.MODULE$;
                Some<V> payload = new Some<V>(this.valueDecoder.fromBytes(Utils.readBytes(record.value())));
                tuple2 = new Tuple2<None$, Some<V>>((None$)key, payload);
            }
            return tuple2;
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    public static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private boolean shouldPrintDataLog;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private final OptionSpecBuilder printOpt = this.parser().accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        private final OptionSpecBuilder indexSanityOpt = this.parser().accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        private final ArgumentAcceptingOptionSpec<String> filesOpt = this.parser().accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = this.parser().accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x500000), (Integer[])((Object[])new Integer[0]));
        private final OptionSpecBuilder deepIterationOpt = this.parser().accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt = this.parser().accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo("kafka.serializer.StringDecoder", (String[])((Object[])new String[0]));
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt = this.parser().accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo("kafka.serializer.StringDecoder", (String[])((Object[])new String[0]));
        private final OptionSpecBuilder offsetsOpt = this.parser().accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        private final OptionSpecBuilder transactionLogOpt = this.parser().accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
        private volatile byte bitmap$0;

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public MessageParser<?, ?> messageParser() {
            MessageParser<String, String> messageParser;
            if (this.options().has(this.offsetsOpt())) {
                messageParser = new OffsetsMessageParser();
            } else if (this.options().has(this.transactionLogOpt())) {
                messageParser = new TransactionLogMessageParser();
            } else {
                Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject(this.options().valueOf(this.valueDecoderOpt()), Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
                Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject(this.options().valueOf(this.keyDecoderOpt()), Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
                messageParser = new DecoderMessageParser(keyDecoder, valueDecoder);
            }
            return messageParser;
        }

        private boolean shouldPrintDataLog$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options().has(this.printOpt()) || this.options().has(this.offsetsOpt()) || this.options().has(this.transactionLogOpt()) || this.options().has(this.valueDecoderOpt()) || this.options().has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.shouldPrintDataLog;
        }

        public boolean shouldPrintDataLog() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldPrintDataLog$lzycompute() : this.shouldPrintDataLog;
        }

        private boolean isDeepIteration$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.isDeepIteration = this.options().has(this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.isDeepIteration;
        }

        public boolean isDeepIteration() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.isDeepIteration$lzycompute() : this.isDeepIteration;
        }

        private boolean verifyOnly$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.verifyOnly = this.options().has(this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.verifyOnly;
        }

        public boolean verifyOnly() {
            return (byte)(this.bitmap$0 & 4) == 0 ? this.verifyOnly$lzycompute() : this.verifyOnly;
        }

        private boolean indexSanityOnly$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.indexSanityOnly = this.options().has(this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            return this.indexSanityOnly;
        }

        public boolean indexSanityOnly() {
            return (byte)(this.bitmap$0 & 8) == 0 ? this.indexSanityOnly$lzycompute() : this.indexSanityOnly;
        }

        private String[] files$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.files = this.options().valueOf(this.filesOpt()).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            return this.files;
        }

        public String[] files() {
            return (byte)(this.bitmap$0 & 0x10) == 0 ? this.files$lzycompute() : this.files;
        }

        private int maxMessageSize$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.maxMessageSize = this.options().valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.maxMessageSize;
        }

        public int maxMessageSize() {
            return (byte)(this.bitmap$0 & 0x20) == 0 ? this.maxMessageSize$lzycompute() : this.maxMessageSize;
        }

        public void checkArgs() {
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.filesOpt()}));
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.parser().parse(super.args()));
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    public static class OffsetsMessageParser
    implements MessageParser<String, String> {
        private String hex(byte[] bytes) {
            return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty() ? "" : new StringOps(Predef$.MODULE$.augmentString("%X")).format(Predef$.MODULE$.genericWrapArray(new Object[]{package$.MODULE$.BigInt().apply(1, bytes)}));
        }

        private Tuple2<Some<String>, Some<String>> parseOffsets(OffsetKey offsetKey, ByteBuffer payload) {
            String group = offsetKey.key().group();
            TopicPartition topicPartition = offsetKey.key().topicPartition();
            OffsetAndMetadata offset = GroupMetadataManager$.MODULE$.readOffsetMessageValue(payload);
            String keyString = new StringBuilder(10).append("offset::").append(group).append(":").append(topicPartition.topic()).append(":").append(topicPartition.partition()).toString();
            String valueString = offset.metadata().isEmpty() ? String.valueOf(offset.offset()) : new StringBuilder(1).append(offset.offset()).append(":").append(offset.metadata()).toString();
            return new Tuple2<Some<String>, Some<String>>(new Some<String>(keyString), new Some<String>(valueString));
        }

        private Tuple2<Some<String>, Some<String>> parseGroupMetadata(GroupMetadataKey groupMetadataKey, ByteBuffer payload) {
            String groupId = groupMetadataKey.key();
            GroupMetadata group = GroupMetadataManager$.MODULE$.readGroupMessageValue(groupId, payload, Time.SYSTEM);
            String protocolType = (String)group.protocolType().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "");
            String assignment = ((TraversableOnce)group.allMemberMetadata().map((Function1<MemberMetadata, String> & Serializable & scala.Serializable)member -> {
                PartitionAssignor.Assignment partitionAssignment;
                String userData;
                String string = protocolType;
                String string2 = "consumer";
                return !(string != null ? !string.equals(string2) : string2 != null) ? ((userData = this.hex(Utils.toArray((partitionAssignment = ConsumerProtocol.deserializeAssignment(ByteBuffer.wrap(member.assignment()))).userData()))).isEmpty() ? new StringBuilder(1).append(member.memberId()).append("=").append(partitionAssignment.partitions()).toString() : new StringBuilder(2).append(member.memberId()).append("=").append(partitionAssignment.partitions()).append(":").append(userData).toString()) : new StringBuilder(1).append(member.memberId()).append("=").append(this.hex(member.assignment())).toString();
            }, List$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
            String keyString = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("metadata"), groupId)}))).asJava());
            String valueString = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("protocolType"), protocolType), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("protocol"), group.protocolOrNull()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("generationId"), BoxesRunTime.boxToInteger(group.generationId())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("assignment"), assignment)}))).asJava());
            return new Tuple2<Some<String>, Some<String>>(new Some<String>(keyString), new Some<String>(valueString));
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            Tuple2<Option<String>, Option<String>> tuple2;
            if (!record.hasValue()) {
                tuple2 = new Tuple2<Option<String>, Option<String>>(None$.MODULE$, None$.MODULE$);
            } else {
                Tuple2<Some<String>, Some<String>> tuple22;
                if (!record.hasKey()) {
                    throw new KafkaException("Failed to decode message using offset topic decoder (message had a missing key)");
                }
                BaseKey baseKey = GroupMetadataManager$.MODULE$.readMessageKey(record.key());
                if (baseKey instanceof OffsetKey) {
                    OffsetKey offsetKey = (OffsetKey)baseKey;
                    tuple22 = this.parseOffsets(offsetKey, record.value());
                } else if (baseKey instanceof GroupMetadataKey) {
                    GroupMetadataKey groupMetadataKey = (GroupMetadataKey)baseKey;
                    tuple22 = this.parseGroupMetadata(groupMetadataKey, record.value());
                } else {
                    throw new KafkaException("Failed to decode message using offset topic decoder (message had an invalid key)");
                }
                tuple2 = tuple22;
            }
            return tuple2;
        }
    }

    public static class TimeIndexDumpErrors {
        private final scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        private final scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        private final scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);

        public scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse(file.getAbsolutePath(), (Function0<ArrayBuffer> & Serializable & scala.Serializable)() -> new ArrayBuffer());
            Serializable serializable = misMatchesSeq.isEmpty() ? this.misMatchesForTimeIndexFilesMap().put(file.getAbsolutePath(), misMatchesSeq) : BoxedUnit.UNIT;
            misMatchesSeq.$plus$eq(new Tuple2$mcJJ$sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse(file.getAbsolutePath(), (Function0<ArrayBuffer> & Serializable & scala.Serializable)() -> new ArrayBuffer());
            Serializable serializable = outOfOrderSeq.isEmpty() ? this.outOfOrderTimestamp().put(file.getAbsolutePath(), outOfOrderSeq) : BoxedUnit.UNIT;
            outOfOrderSeq.$plus$eq(new Tuple2$mcJJ$sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse(file.getAbsolutePath(), (Function0<ArrayBuffer> & Serializable & scala.Serializable)() -> new ArrayBuffer());
            Serializable serializable = shallowOffsetNotFoundSeq.isEmpty() ? this.shallowOffsetNotFound().put(file.getAbsolutePath(), shallowOffsetNotFoundSeq) : BoxedUnit.UNIT;
            shallowOffsetNotFoundSeq.$plus$eq(new Tuple2$mcJJ$sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1<ArrayBuffer, Object> & Serializable & scala.Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String fileName = (String)tuple2._1();
            ArrayBuffer listOfMismatches = (ArrayBuffer)tuple2._2();
            System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
            listOfMismatches.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)m -> {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(m._1$mcJ$sp()), BoxesRunTime.boxToLong(m._2$mcJ$sp())})));
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String fileName = (String)tuple2._1();
            ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)tuple2._2();
            System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
            outOfOrderTimestamps.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)m -> {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(m._1$mcJ$sp()), BoxesRunTime.boxToLong(m._2$mcJ$sp())})));
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long indexedOffset = tuple2._1$mcJ$sp();
            long logOffset = tuple2._2$mcJ$sp();
            System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
            TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(txnKey.transactionalId(), record.value());
            String keyString = new StringBuilder(16).append("transactionalId=").append(txnKey.transactionalId()).toString();
            String valueString = new StringBuilder(12).append("producerId:").append(txnMetadata.producerId()).append(",").append(new StringBuilder(15).append("producerEpoch:").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(7).append("state=").append(txnMetadata.state()).append(",").toString()).append(new StringBuilder(12).append("partitions=").append(txnMetadata.topicPartitions()).append(",").toString()).append(new StringBuilder(24).append("txnLastUpdateTimestamp=").append(txnMetadata.txnLastUpdateTimestamp()).append(",").toString()).append(new StringBuilder(13).append("txnTimeoutMs=").append(txnMetadata.txnTimeoutMs()).toString()).toString();
            return new Tuple2<Option<String>, Option<String>>(new Some<String>(keyString), new Some<String>(valueString));
        }
    }
}

