/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.io.Serializable;
import org.apache.kafka.common.utils.Utils;

public final class TopicPartitionReplica
implements Serializable {
    private int hash = 0;
    private final int brokerId;
    private final int partition;
    private final String topic;

    public TopicPartitionReplica(String topic, int partition, int brokerId) {
        this.topic = Utils.notNull(topic);
        this.partition = partition;
        this.brokerId = brokerId;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.topic.hashCode();
        result2 = 31 * result2 + this.partition;
        this.hash = result2 = 31 * result2 + this.brokerId;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicPartitionReplica other = (TopicPartitionReplica)obj;
        return this.partition == other.partition && this.brokerId == other.brokerId && this.topic.equals(other.topic);
    }

    public String toString() {
        return String.format("%s-%d-%d", this.topic, this.partition, this.brokerId);
    }
}

