/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice;

import com.chinamcloud.bigdata.haiheservice.ConfigManager;
import com.chinamcloud.bigdata.haiheservice.bean.ConfigBean;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class RegionKeywordsConfigManager
extends ConfigManager {
    private static Logger logger = LogManager.getLogger(RegionKeywordsConfigManager.class);
    private final String type = "region_keywords";
    private final String ALL = "*";
    private AtomicReference<Map<String, Set<String>>> values = new AtomicReference();
    private volatile long lastUpdate = 0L;

    @PostConstruct
    public void init() {
        this.initConfig();
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                Date date = RegionKeywordsConfigManager.this.getLastUpdateTime();
                if (date != null && date.getTime() != RegionKeywordsConfigManager.this.lastUpdate) {
                    RegionKeywordsConfigManager.this.initConfig();
                }
            }
        }, 10000L, 20000L);
    }

    private void initConfig() {
        ConfigBean bean = this.getConfig();
        String detail = bean.getDetail();
        this.lastUpdate = bean.getUpdateTime().getTime();
        logger.info("trigger config checkupdate=" + this.lastUpdate + " nowUpdate=" + this.lastUpdate);
        if (StringUtils.isNotBlank((CharSequence)detail)) {
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
            Map values = null;
            try {
                values = (Map)mapper.readValue(detail, (TypeReference)typeRef);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            HashMap mapValues = new HashMap();
            if (values != null && !values.isEmpty()) {
                values.forEach((x, y) -> mapValues.put(x, new HashSet<String>(Arrays.asList(y.split(",")))));
                this.values.set(mapValues);
            }
        }
    }

    public boolean checkISAll(String key) {
        String regionWord;
        Set<String> regionWords;
        Map<String, Set<String>> values = this.values.get();
        return values != null && (regionWords = values.get(key)) != null && regionWords.size() == 1 && (regionWord = regionWords.iterator().next()).equals("*");
    }

    public Map<String, Set<String>> getCategoryMapping(String key) {
        Map<String, Set<String>> values = this.values.get();
        if (values != null) {
            String regionWord;
            Set<String> regionWords = values.get(key);
            if (regionWords != null && regionWords.size() == 1 && (regionWord = regionWords.iterator().next()).equals("*")) {
                HashMap<String, Set<String>> mapping = new HashMap<String, Set<String>>(values);
                mapping.remove(key);
                return mapping;
            }
            HashMap<String, Set<String>> mapping = new HashMap<String, Set<String>>();
            mapping.put(key, regionWords);
            return mapping;
        }
        return null;
    }

    public Collection<String> getRegionKeyWordsList(String key) {
        Map<String, Set<String>> values = this.values.get();
        if (values != null) {
            Set<String> regionWords = values.get(key);
            if (regionWords != null && regionWords.size() == 1) {
                String regionWord = regionWords.iterator().next();
                if (regionWord.equals("*")) {
                    HashSet<String> keywords = new HashSet<String>();
                    keywords.add("*");
                    return keywords;
                }
            } else {
                Set<String> value = values.get(key);
                if (value != null) {
                    return value.stream().collect(Collectors.toSet());
                }
            }
        }
        return Arrays.asList(key);
    }

    @Override
    public String type() {
        return "region_keywords";
    }
}

