/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.afterprocessor;

import com.chinamcloud.bigdata.haiheservice.afterprocessor.IAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.FacetGroupResult;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EmotionTendencyGroupAfterProcessor
implements IAfterProcessor<List<FacetResult>> {
    private static Map<String, String> emotionMaps = new HashMap<String, String>();
    private static Map<String, String> map;

    @Override
    public void process(List<FacetResult> facets) {
        FacetGroupResult facetGroupResult;
        if (facets.isEmpty()) {
            return;
        }
        Set<String> set = emotionMaps.keySet();
        for (FacetResult facet : facets) {
            facetGroupResult = (FacetGroupResult)facet;
            List<FacetResult> list = facetGroupResult.getValues();
            int size = list.size();
            for (String name : set) {
                boolean flag = false;
                for (int i = 0; i < size; ++i) {
                    if (!name.equals(list.get(i).getName())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                list.add(new FacetResult(name, 0L));
            }
        }
        for (FacetResult facet : facets) {
            facetGroupResult = (FacetGroupResult)facet;
            List<FacetResult> list = facetGroupResult.getValues();
            for (FacetResult value : list) {
                String name;
                name = value.getName();
                value.setName(emotionMaps.getOrDefault(name, "\u4e2d\u7acb\u6001\u5ea6"));
            }
        }
        Set<String> keySet = map.keySet();
        HashMap result = new HashMap();
        if (!keySet.contains(facets.get(0).getName())) {
            return;
        }
        for (FacetResult facetResult : facets) {
            FacetGroupResult facetGroupResult2 = (FacetGroupResult)facetResult;
            String name = map.get(facetResult.getName());
            HashMap<String, FacetResult> resultMap = (HashMap<String, FacetResult>)result.get(name);
            if (null == resultMap) {
                resultMap = new HashMap<String, FacetResult>();
                result.put(name, resultMap);
            }
            List<FacetResult> values2 = facetGroupResult2.getValues();
            for (FacetResult value : values2) {
                FacetResult facetResult2 = (FacetResult)resultMap.get(value.getName());
                if (null == facetResult2) {
                    resultMap.put(value.getName(), value);
                    continue;
                }
                facetResult2.setValue(facetResult2.getValue() + value.getValue());
            }
        }
        facets.clear();
        for (final Map.Entry entry : result.entrySet()) {
            FacetGroupResult facetGroupResult3 = new FacetGroupResult();
            facetGroupResult3.setName((String)entry.getKey());
            facetGroupResult3.setValues((List<FacetResult>)new ArrayList<FacetResult>(){
                {
                    this.addAll(((Map)entry.getValue()).values());
                }
            });
            facets.add(facetGroupResult3);
        }
    }

    static {
        emotionMaps.put("-1", "\u6d88\u6781\u6001\u5ea6");
        emotionMaps.put("1", "\u79ef\u6781\u6001\u5ea6");
        emotionMaps.put("0", "\u4e2d\u7acb\u6001\u5ea6");
        map = new HashMap<String, String>(){
            {
                this.put("News", "\u65b0\u95fb");
                this.put("WeiboV", "\u5fae\u535a");
                this.put("Weibo", "\u5fae\u535a");
                this.put("Government", "\u653f\u5e9c");
                this.put("LunTan", "\u8bba\u575b");
                this.put("WeiXin", "\u5fae\u4fe1");
                this.put("TieBa", "\u8d34\u5427");
                this.put("Other", "\u5176\u4ed6");
            }
        };
    }
}

