/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.afterprocessor;

import com.chinamcloud.bigdata.haiheservice.afterprocessor.IAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.Trend;
import com.chinamcloud.bigdata.haiheservice.es.bean.HotEventStatistic;
import com.chinamcloud.bigdata.haiheservice.util.DateUtils;
import java.util.ArrayList;
import java.util.List;

public class EventStatisticAfterProcessor
implements IAfterProcessor<HotEventStatistic> {
    @Override
    public void process(HotEventStatistic result) {
        List<Trend> doc_count = this.process(result.getDoc_count());
        List<Trend> emotion_value = this.process(result.getEmotion_value());
        List<Trend> hot_value = this.process(result.getHot_value());
        List<Trend> media_cover = this.process(result.getMedia_cover());
        result.setDoc_count(doc_count);
        result.setEmotion_value(emotion_value);
        result.setHot_value(hot_value);
        result.setMedia_cover(media_cover);
    }

    public List<Trend> process(List<Trend> values) {
        ArrayList<Trend> newValues = new ArrayList();
        long before_yesterday = DateUtils.computeDatesBackward(3, true)[0].getTime();
        long yesterday = DateUtils.computeDatesBackward(2, true)[0].getTime();
        if (values.size() == 2) {
            newValues = values;
        } else if (values.size() == 0) {
            newValues.add(new Trend(before_yesterday, 0L));
            newValues.add(new Trend(yesterday, 0L));
        } else if (values.size() == 1) {
            Trend trend = values.get(0);
            long time = trend.getTime();
            if (time == before_yesterday) {
                newValues.add(trend);
                newValues.add(new Trend(yesterday, 0L));
            } else if (time == yesterday) {
                newValues.add(new Trend(before_yesterday, 0L));
                newValues.add(trend);
            }
        }
        return newValues;
    }
}

