/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.util.HttpUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NewsSpiderController {
    private static Logger logger = LogManager.getLogger(NewsSpiderController.class);
    private static String baiduNewsUrl = "http://news.baidu.com/ns?word={kw}&pn={offset}&cl=2&ct=1&tn=news&rn={pageNum}&ie=utf-8&bt=0&et=0";
    private static String URL2ioUrl = "http://api.url2io.com/article?token=EGoQHzKoQYm5ywKsS_V2oQ&url=";

    @GetMapping(value={"/news/spider/test"})
    public CodeResult test() {
        return CodeResult.successResult();
    }

    @GetMapping(value={"/spider/news/list"})
    public CodeResult newsList(@RequestParam(value="kw") String kw, @RequestParam(value="offset", required=false, defaultValue="0") String offset, @RequestParam(value="pageNum", required=false, defaultValue="20") String pageNum) {
        Header[] headers = new Header[]{new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.75 Safari/537.36")};
        String rawText = HttpUtils.executeGet(this.tranUrl(kw, offset, pageNum), headers).getMsg();
        if (rawText == null) {
            return CodeResult.failedResult("\u8bf7\u6c42\u767e\u5ea6Url\u5931\u8d25");
        }
        Document document = Jsoup.parse((String)rawText);
        List<Map<String, String>> result = this.getList(document);
        if (result == null) {
            return CodeResult.failedResult("JSoup\u89e3\u6790\u5931\u8d25");
        }
        return CodeResult.successResult("", result);
    }

    @GetMapping(value={"/spider/news/detail"})
    public CodeResult newsDetail(@RequestParam(value="url") String url) {
        String rawText = HttpUtils.executeGet(URL2ioUrl + url, null).getMsg();
        if (rawText == null) {
            return CodeResult.failedResult("\u8bf7\u6c42URL2ioUrl\u5931\u8d25");
        }
        Map rawTextMap = (Map)JSON.parseObject((String)rawText, Map.class);
        return CodeResult.successResult("", rawTextMap);
    }

    private List<Map<String, String>> getList(Document document) {
        Elements newsList = document.getElementsByClass("result");
        if (newsList == null || newsList.size() == 0) {
            return null;
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(newsList.size());
        for (Element node : newsList) {
            HashMap<String, String> map = new HashMap<String, String>();
            Element titleEl = (Element)node.getElementsByTag("h3").get(0);
            String url = ((Element)titleEl.getElementsByTag("a").get(0)).attributes().get("href");
            String title = titleEl.text();
            String source = node.getElementsByClass("c-author").text();
            Element desEle = (Element)node.getElementsByClass("c-summary").get(0);
            String span = desEle.getElementsByTag("span").text();
            String des = desEle.text();
            des = des.replace(span, "").replace(source, "");
            map.put("url", url);
            map.put("title", title);
            map.put("des", des);
            map.put("time", String.valueOf(this.tranTime(source)));
            map.put("source", source.replaceFirst("\\d+\u5c0f\u65f6\u524d", "").replaceFirst("\\d+\u5206\u949f\u524d", "").replaceFirst("\\d+\u5e74\\d+\u6708\\d+\u65e5 \\d+:\\d+", "").replace("\u00a0", ""));
            result.add(map);
        }
        return result;
    }

    private long tranTime(String timeStr) {
        if (timeStr.contains("\u5c0f\u65f6\u524d")) {
            long curTime = new Date().getTime();
            String regex = "(\\d+)\u5c0f\u65f6\u524d";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(timeStr);
            if (matcher.find()) {
                int hours = Integer.parseInt(matcher.group(1));
                return curTime - (long)(hours * 60 * 60 * 1000);
            }
        } else if (timeStr.contains("\u5206\u949f\u524d")) {
            long curTime = new Date().getTime();
            String regex = "(\\d+)\u5206\u949f\u524d";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(timeStr);
            if (matcher.find()) {
                int hours = Integer.parseInt(matcher.group(1));
                return curTime - (long)(hours * 60 * 1000);
            }
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
            try {
                return simpleDateFormat.parse(timeStr).getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }

    private String tranUrl(String kw, String offset, String pageNum) {
        return baiduNewsUrl.replace("{kw}", kw).replace("{offset}", offset).replace("{pageNum}", pageNum);
    }
}

