/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller.dp;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.CatSiteAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.MediaLibAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.CatSite;
import com.chinamcloud.bigdata.haiheservice.pojo.CatSiteNewsParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.service.CatSiteService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/dp/catSite"})
public class DpCategorySiteController {
    private static Logger logger = LogManager.getLogger(DpCategorySiteController.class);
    private static final Integer productId = 53691;
    @Autowired
    private CatSiteService catSiteService;

    @RequestMapping(value={"/getCatHot"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getCatHot(HttpServletRequest request) {
        List<Object> list = new ArrayList();
        try {
            list = this.catSiteService.findCatSpiderTopicIdList();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult(null, list);
    }

    @RequestMapping(value={"/getMediaLibInfo"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getMediaLibInfo(HttpServletRequest request) {
        List<CatSite> list = this.catSiteService.findCatSpiderTopicIdList();
        Map<Integer, String> values = list.stream().filter(x -> x.getSpiderTopicId() != -1).collect(Collectors.toMap(x -> x.getSpiderTopicId(), x -> x.getCategory()));
        HotParams params = new HotParams();
        params.setProduceIds(Arrays.asList(productId));
        params.setSpiderTopicIds(new ArrayList<Integer>(values.keySet()));
        params.setFacetField("spider_topicId");
        MediaLibAfterProcessor afterProcessor = new MediaLibAfterProcessor(values);
        params.setAfterProcessor(afterProcessor);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        view.addObject("cache", (Object)true);
        return view;
    }

    @RequestMapping(value={"/news"})
    public Object hotNews(@RequestBody @Validated CatSiteNewsParams params, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Integer spiderTopicId = params.getSpiderTopicId();
        params.setProduceIds(Arrays.asList(productId));
        List<CatSite> list = this.catSiteService.findCatSpiderTopicIdList();
        if (list.size() == 0) {
            return CodeResult.successResult(null, Collections.emptyList());
        }
        Map<Integer, String> values = list.stream().collect(Collectors.toMap(x -> x.getSpiderTopicId(), x -> x.getCategory()));
        long count = list.stream().filter(x -> spiderTopicId.equals(x.getSpiderTopicId())).count();
        if (0L == count) {
            return CodeResult.successResult(null, Collections.emptyList());
        }
        CatSiteAfterProcessor afterProcessor = new CatSiteAfterProcessor(values);
        params.setAfterProcessor(afterProcessor);
        ArrayList<Integer> spiderTopicIds = new ArrayList<Integer>();
        if (spiderTopicId == -1) {
            spiderTopicIds = new ArrayList<Integer>(values.keySet());
        } else {
            spiderTopicIds.add(spiderTopicId);
        }
        params.setSpiderTopicIds(spiderTopicIds);
        ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
        params.setEsIndex("2");
        view.addObject("params", (Object)params);
        view.addObject("cache", (Object)true);
        return view;
    }
}

