/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.AnalysisRecord;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisReq;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisResult;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisTask;
import com.chinamcloud.bigdata.haiheservice.db.mapper.AnalysisRecordMapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class AnalysisDao {
    @Autowired
    private JdbcTemplate template;

    public boolean selectAnalysisReqExisted(String url, long ownerId) {
        return (Integer)this.template.queryForObject("SELECT count(*) FROM `t_analysis_req` WHERE url=? AND `ownerId`=? and `status` in(1,2)", new Object[]{url, ownerId}, Integer.class) > 0;
    }

    public long addAnalysisReq(final String url, final long ownerId, final AnalysisTask.Type type) {
        this.template.update("UPDATE `t_analysis_req` SET `status`=-2 WHERE ownerId=? AND `url`=? and `status` in(1,2)", new Object[]{ownerId, url});
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.template.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO `t_analysis_req`(`ownerId`,`url`,`type`) VALUES(?,?,?)", 1);
                ps.setLong(1, ownerId);
                ps.setString(2, url);
                ps.setInt(3, type.getIntValue());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().longValue();
    }

    public void updateReqPre(long ownerId, String url, long recordId, AnalysisTask.Type type) {
        this.template.update("UPDATE `t_analysis_req` SET `status`=-2 WHERE `ownerId`=? and `url`=? and `type`=?", new Object[]{ownerId, url, type.getIntValue()});
        this.template.update("INSERT INTO `t_analysis_req`(`ownerId`,`url`,`recordId`,`type`) VALUES(?,?,?,?)", new Object[]{ownerId, url, recordId, type.getIntValue()});
    }

    public void updateReqPost(long ownerId, String url, long recordId, AnalysisReq.Status status) {
        this.template.update("UPDATE `t_analysis_req` SET `status`=?,`recordId`=?,`modifyTime`=? WHERE `ownerId`=? and `url`=? and `status`=2 ", new Object[]{status.getIntValue(), recordId, new Timestamp(new Date().getTime()), ownerId, url});
    }

    public void updateReqPostYC(long ownerId, String url, AnalysisReq.Status status) {
        this.template.update("UPDATE `t_analysis_req` SET `status`=? WHERE `ownerId`=? and `url`=? and `status`=2", new Object[]{status.getIntValue(), ownerId, url});
    }

    public List<AnalysisReq> selectReqStatus(int id, long ownerId) {
        return this.template.query("select * from t_analysis_req WHERE id=? and ownerId=?", new Object[]{id, ownerId}, (RowMapper)new RowMapper<AnalysisReq>(){

            public AnalysisReq mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisReq req = new AnalysisReq();
                req.setId(rs.getInt("id"));
                req.setOwnerId(rs.getLong("ownerId"));
                req.setUrl(rs.getString("url"));
                req.setStatus(AnalysisReq.Status.valueOfInt(rs.getInt("status")));
                req.setType(AnalysisTask.Type.valueOfInt(rs.getInt("type")));
                req.setModifyTime(rs.getTimestamp("modifyTime"));
                return req;
            }
        });
    }

    public List<AnalysisReq> selectReqStatus(int id, String ownerIds) {
        return this.template.query("select * from t_analysis_req WHERE id=? and ownerId in (" + ownerIds + ")", new Object[]{id}, (RowMapper)new RowMapper<AnalysisReq>(){

            public AnalysisReq mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisReq req = new AnalysisReq();
                req.setId(rs.getInt("id"));
                req.setOwnerId(rs.getLong("ownerId"));
                req.setUrl(rs.getString("url"));
                req.setStatus(AnalysisReq.Status.valueOfInt(rs.getInt("status")));
                req.setType(AnalysisTask.Type.valueOfInt(rs.getInt("type")));
                req.setModifyTime(rs.getTimestamp("modifyTime"));
                return req;
            }
        });
    }

    public List<AnalysisReq> selectAnalysisReq(List<String> ids, long ownerId) {
        return this.template.query("select * from `t_analysis_req` where `ownerId`=? and id in (" + StringUtils.join(ids, (String)",") + ")", new Object[]{ownerId}, (RowMapper)new RowMapper<AnalysisReq>(){

            public AnalysisReq mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisReq req = new AnalysisReq();
                req.setId(rs.getInt("id"));
                req.setOwnerId(rs.getLong("ownerId"));
                req.setUrl(rs.getString("url"));
                req.setStatus(AnalysisReq.Status.valueOfInt(rs.getInt("status")));
                req.setType(AnalysisTask.Type.valueOfInt(rs.getInt("type")));
                req.setModifyTime(rs.getTimestamp("modifyTime"));
                return req;
            }
        });
    }

    public List<AnalysisReq> selectAnalysisReq(List<String> ids, String ownerIds) {
        return this.template.query("select * from `t_analysis_req` where `ownerId` in (" + ownerIds + ") and id in (" + StringUtils.join(ids, (String)",") + ")", new Object[0], (RowMapper)new RowMapper<AnalysisReq>(){

            public AnalysisReq mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisReq req = new AnalysisReq();
                req.setId(rs.getInt("id"));
                req.setOwnerId(rs.getLong("ownerId"));
                req.setUrl(rs.getString("url"));
                req.setStatus(AnalysisReq.Status.valueOfInt(rs.getInt("status")));
                req.setType(AnalysisTask.Type.valueOfInt(rs.getInt("type")));
                req.setModifyTime(rs.getTimestamp("modifyTime"));
                return req;
            }
        });
    }

    public List<AnalysisReq> selectAnalysisReqList(long ownerId, int type) {
        return this.template.query("select a.* from `t_analysis_req` as a where `ownerId`=? and `status` = 2 and `type`= ?", new Object[]{ownerId, type}, (RowMapper)new RowMapper<AnalysisReq>(){

            public AnalysisReq mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisReq req = new AnalysisReq();
                req.setId(rs.getInt("id"));
                req.setOwnerId(rs.getLong("ownerId"));
                req.setUrl(rs.getString("url"));
                req.setStatus(AnalysisReq.Status.valueOfInt(rs.getInt("status")));
                req.setType(AnalysisTask.Type.valueOfInt(rs.getInt("type")));
                req.setModifyTime(rs.getTimestamp("modifyTime"));
                return req;
            }
        });
    }

    public List<AnalysisReq> selectAnalysisReqList(String ownerIds, int type) {
        return this.template.query("select a.* from `t_analysis_req` as a where `ownerId` in (" + ownerIds + ") and `status` = 2 and `type`= ?", new Object[]{type}, (RowMapper)new RowMapper<AnalysisReq>(){

            public AnalysisReq mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisReq req = new AnalysisReq();
                req.setId(rs.getInt("id"));
                req.setOwnerId(rs.getLong("ownerId"));
                req.setUrl(rs.getString("url"));
                req.setStatus(AnalysisReq.Status.valueOfInt(rs.getInt("status")));
                req.setType(AnalysisTask.Type.valueOfInt(rs.getInt("type")));
                req.setModifyTime(rs.getTimestamp("modifyTime"));
                return req;
            }
        });
    }

    public List<AnalysisReq> selectAnalysisReqHistoryList(long userId, String url, int type) {
        return this.template.query("select a.* from `t_analysis_req` as a where `ownerId`=? and `url`=? and status in(-2,1) and `type`= ?", new Object[]{userId, url, type}, (RowMapper)new RowMapper<AnalysisReq>(){

            public AnalysisReq mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisReq req = new AnalysisReq();
                req.setId(rs.getInt("id"));
                req.setOwnerId(rs.getLong("ownerId"));
                req.setUrl(rs.getString("url"));
                req.setStatus(AnalysisReq.Status.valueOfInt(rs.getInt("status")));
                req.setType(AnalysisTask.Type.valueOfInt(rs.getInt("type")));
                req.setModifyTime(rs.getTimestamp("modifyTime"));
                return req;
            }
        });
    }

    public List<AnalysisReq> selectAnalysisReqHistoryList(String userIds, String url, int type) {
        return this.template.query("select a.* from `t_analysis_req` as a where `ownerId` in (" + userIds + ") and `url`=? and status in(-2,1) and `type`= ?", new Object[]{url, type}, (RowMapper)new RowMapper<AnalysisReq>(){

            public AnalysisReq mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisReq req = new AnalysisReq();
                req.setId(rs.getInt("id"));
                req.setOwnerId(rs.getLong("ownerId"));
                req.setUrl(rs.getString("url"));
                req.setStatus(AnalysisReq.Status.valueOfInt(rs.getInt("status")));
                req.setType(AnalysisTask.Type.valueOfInt(rs.getInt("type")));
                req.setModifyTime(rs.getTimestamp("modifyTime"));
                return req;
            }
        });
    }

    public void deleteAnalysisReq(long id) {
        this.template.update("UPDATE `t_analysis_req` SET `status`=-1 WHERE `id`=?", new Object[]{id});
    }

    public void updateReqRecordId(long ownerId, String url, long recordId) {
        this.template.update("UPDATE `t_analysis_req` SET `recordId`=? WHERE `ownerId`=? and `url`=? and `status`=2", new Object[]{recordId, ownerId, url});
    }

    public List<AnalysisTask> getAnalysisTask() {
        return this.template.query("SELECT * FROM `t_analysis_queue` WHERE `status` NOT IN(?,?)", new Object[]{AnalysisTask.Status.FAILED.toString(), AnalysisTask.Status.SUCCESSFUL.toString()}, (RowMapper)new RowMapper<AnalysisTask>(){

            public AnalysisTask mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisTask task = new AnalysisTask();
                task.setId(rs.getInt("id"));
                task.setAnalisisId(rs.getInt("analisisId"));
                task.setHeadType(rs.getString("headType"));
                task.setMessage(rs.getString("message"));
                task.setModifyTime(rs.getTimestamp("modifyTime"));
                task.setOwnerId(rs.getLong("ownerId"));
                task.setRetried(rs.getInt("retried"));
                task.setUrl(rs.getString("url"));
                task.setStatus(AnalysisTask.Status.valueOf(rs.getString("status")));
                task.setType(AnalysisTask.Type.valueOfInt(rs.getInt("type")));
                return task;
            }
        });
    }

    public boolean isAnalysisExisted(String url, long ownerId) {
        return (Integer)this.template.queryForObject("select count(id) from `t_analysis_queue` where `ownerId`=? and `url`=? and `status`!=? AND `status`!=?", new Object[]{ownerId, url, AnalysisTask.Status.SUCCESSFUL.toString(), AnalysisTask.Status.FAILED.toString()}, Integer.class) > 0;
    }

    public void addAnalysisTask(AnalysisTask task) {
        this.template.update("INSERT INTO `t_analysis_queue`(`analisisId`,`ownerId`,`url`,`type`) VALUES(?,?,?,?)", new Object[]{task.getAnalisisId(), task.getOwnerId(), task.getUrl(), task.getType().getIntValue()});
    }

    public int updateTask(AnalysisTask task) {
        return this.template.update("UPDATE `t_analysis_queue` SET `analisisId`=?,`message`=?, `modifyTime`=?,`retried`=?,`status`=? WHERE id=?", new Object[]{task.getAnalisisId(), task.getMessage(), task.getModifyTime(), task.getRetried(), task.getStatus().toString(), task.getId()});
    }

    public long saveAnalysisRecord(final AnalysisRecord record) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.template.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO `t_analysis_req_record`(`content`,`createdAt`,`ownerId`,`profileImageURL`,`screenName`,`uid`,`url`,`headType`,`source`,`forwards`,`comments`,`thumbs`,`resultId`,`type`) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
                ps.setString(1, record.getContent());
                ps.setTimestamp(2, new Timestamp(record.getCreateAt().getTime()));
                ps.setLong(3, record.getOwnerId());
                ps.setString(4, record.getProfileImageURL());
                ps.setString(5, record.getScreenName());
                ps.setString(6, record.getUid());
                ps.setString(7, record.getUrl());
                ps.setString(8, record.getHeadType());
                ps.setString(9, record.getSource());
                ps.setLong(10, record.getForwards());
                ps.setLong(11, record.getComments());
                ps.setLong(12, record.getThumbs());
                ps.setLong(13, record.getResultId());
                ps.setInt(14, record.getType().getIntValue());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().longValue();
    }

    public long saveAnalysisRecordYC(final AnalysisRecord record) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.template.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO `t_analysis_req_record`(`content`,`createdAt`,`ownerId`,`profileImageURL`,`screenName`,`uid`,`url`,`headType`,`source`,`forwards`,`comments`,`thumbs`,`resultId`,`type`,`status`,`deadline`,`relaId`,`reads`) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
                ps.setString(1, record.getContent());
                ps.setTimestamp(2, new Timestamp(record.getCreateAt().getTime()));
                ps.setLong(3, record.getOwnerId());
                ps.setString(4, record.getProfileImageURL());
                ps.setString(5, record.getScreenName());
                ps.setString(6, record.getUid());
                ps.setString(7, record.getUrl());
                ps.setString(8, record.getHeadType());
                ps.setString(9, record.getSource());
                ps.setLong(10, record.getForwards());
                ps.setLong(11, record.getComments());
                ps.setLong(12, record.getThumbs());
                ps.setLong(13, record.getResultId());
                ps.setInt(14, record.getType().getIntValue());
                ps.setLong(15, record.getStatus());
                ps.setTimestamp(16, new Timestamp(record.getDeadline().getTime()));
                ps.setLong(17, record.getRelaId());
                ps.setInt(18, record.getReads());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().longValue();
    }

    public List<AnalysisRecord> selectAnalysisRecordList(long ownerId, int type) {
        return this.template.query("select a.id, b.* from `t_analysis_req` as a INNER JOIN t_analysis_req_record as b ON a.recordId = b.id where a.`ownerId`=? and a.`type`=? and a.`status`=1 order by a.modifyTime DESC", new Object[]{ownerId, type}, (RowMapper)new AnalysisRecordMapper());
    }

    public List<AnalysisRecord> selectAnalysisRecordList(String ownerIds, int type) {
        return this.template.query("select a.id, b.* from `t_analysis_req` as a INNER JOIN t_analysis_req_record as b ON a.recordId = b.id where a.`ownerId` in (" + ownerIds + ") and a.`type`=? and a.`status`=1 order by a.modifyTime DESC", new Object[]{type}, (RowMapper)new AnalysisRecordMapper());
    }

    public List<AnalysisRecord> selectAnalysisRecord(long userId, String url, int type, Date modifyTime) {
        return this.template.query("select a.id, b.* from `t_analysis_req` as a INNER JOIN t_analysis_req_record as b ON a.recordId = b.id where a.`ownerId`=? and a.`url`=? and a.`status` in(0,1) and a.`type`=? and a.`modifyTime`=? ", new Object[]{userId, url, type, new Timestamp(modifyTime.getTime())}, (RowMapper)new AnalysisRecordMapper());
    }

    public AnalysisRecord selectRecord(long id, long userId) {
        List list = this.template.query("select a.id, b.* from `t_analysis_req` as a INNER JOIN t_analysis_req_record as b ON a.recordId = b.id where a.`id`=? and a.`ownerId`=? ", new Object[]{id, userId}, (RowMapper)new AnalysisRecordMapper());
        return list.size() > 0 ? (AnalysisRecord)list.get(0) : null;
    }

    public AnalysisRecord selectRecord(long id, String userIds) {
        List list = this.template.query("select a.id,a.ownerId, b.* from `t_analysis_req` as a INNER JOIN t_analysis_req_record as b ON a.recordId = b.id where a.`id`=? and a.`ownerId` in (" + userIds + ") ", new Object[]{id}, (RowMapper)new AnalysisRecordMapper());
        return list.size() > 0 ? (AnalysisRecord)list.get(0) : null;
    }

    public AnalysisRecord selectRecordByAnalysisId(long analisisId, long ownerId) {
        List list = this.template.query("select b.* from `t_analysis_queue` as a INNER JOIN t_analysis_req_record as b ON a.analisisId = b.id where a.`analisisId`=? and a.`ownerId`=?", new Object[]{analisisId, ownerId}, (RowMapper)new AnalysisRecordMapper());
        return list.size() > 0 ? (AnalysisRecord)list.get(0) : null;
    }

    public void updateRecord(int analisisId, long resultId) {
        this.template.update("UPDATE `t_analysis_req_record` SET `resultId`=? WHERE id=?", new Object[]{resultId, analisisId});
    }

    public void updateRecordForwards(long id, int forwards) {
        this.template.update("UPDATE `t_analysis_req_record` SET `forwards`=? WHERE id=?", new Object[]{forwards, id});
    }

    public long saveAnalysisResult(final AnalysisResult result) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.template.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO `t_analysis_result`(`modifyTime`,`ownerId`,`resultJson`,`url`) VALUES(?,?,?,?)", 1);
                ps.setTimestamp(1, new Timestamp(result.getModifyTime().getTime()));
                ps.setLong(2, result.getOwnerId());
                ps.setString(3, result.getResultJson());
                ps.setString(4, result.getUrl());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().longValue();
    }

    public AnalysisResult selectAnalysisResultById(int id, long ownerId) {
        List result = this.template.query("SELECT result.`resultJson`,req.`type`,req.`url` FROM `t_analysis_req` req INNER JOIN `t_analysis_req_record` record ON req.recordId=record.id INNER JOIN `t_analysis_result` result ON record.`resultId` = result.`id` WHERE req.id =? AND req.ownerId =?", new Object[]{id, ownerId}, (RowMapper)new RowMapper<AnalysisResult>(){

            public AnalysisResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisResult result = new AnalysisResult();
                result.setResultJson(rs.getString("resultJson"));
                result.setType(rs.getInt("type"));
                result.setUrl(rs.getString("url"));
                return result;
            }
        });
        return result.size() > 0 ? (AnalysisResult)result.get(0) : null;
    }

    public AnalysisResult selectAnalysisResultById(int id, String ownerIds) {
        List result = this.template.query("SELECT result.`resultJson`,req.`type`,req.`url` FROM `t_analysis_req` req INNER JOIN `t_analysis_req_record` record ON req.recordId=record.id INNER JOIN `t_analysis_result` result ON record.`resultId` = result.`id` WHERE req.id =? AND req.ownerId in (" + ownerIds + ")", new Object[]{id}, (RowMapper)new RowMapper<AnalysisResult>(){

            public AnalysisResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisResult result = new AnalysisResult();
                result.setResultJson(rs.getString("resultJson"));
                result.setType(rs.getInt("type"));
                result.setUrl(rs.getString("url"));
                return result;
            }
        });
        return result.size() > 0 ? (AnalysisResult)result.get(0) : null;
    }

    public AnalysisResult selectAnalysisResultHistory(long ownerId, String url, int type, Date modifyTime) {
        List result = this.template.query("SELECT result.`resultJson`,req.`type`,req.`url` FROM `t_analysis_req` req INNER JOIN `t_analysis_req_record` record ON req.recordId=record.id INNER JOIN `t_analysis_result` result ON record.`resultId` = result.`id` WHERE req.type=? AND req.modifyTime =? AND req.url=? AND req.ownerId =?", new Object[]{type, modifyTime, url, ownerId}, (RowMapper)new RowMapper<AnalysisResult>(){

            public AnalysisResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisResult result = new AnalysisResult();
                result.setResultJson(rs.getString("resultJson"));
                result.setType(rs.getInt("type"));
                result.setUrl(rs.getString("url"));
                return result;
            }
        });
        return result.size() > 0 ? (AnalysisResult)result.get(0) : null;
    }

    public AnalysisResult selectAnalysisResultHistory(String ownerIds, String url, int type, Date modifyTime) {
        List result = this.template.query("SELECT result.`resultJson`,req.`type`,req.`url` FROM `t_analysis_req` req INNER JOIN `t_analysis_req_record` record ON req.recordId=record.id INNER JOIN `t_analysis_result` result ON record.`resultId` = result.`id` WHERE req.type=? AND req.modifyTime =? AND req.url=? AND req.ownerId  in (" + ownerIds + ")", new Object[]{type, modifyTime, url}, (RowMapper)new RowMapper<AnalysisResult>(){

            public AnalysisResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                AnalysisResult result = new AnalysisResult();
                result.setResultJson(rs.getString("resultJson"));
                result.setType(rs.getInt("type"));
                result.setUrl(rs.getString("url"));
                return result;
            }
        });
        return result.size() > 0 ? (AnalysisResult)result.get(0) : null;
    }
}

