/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.bean.HotNews;
import com.chinamcloud.bigdata.haiheservice.bean.Page;
import com.chinamcloud.bigdata.haiheservice.es.bean.EsApsSearchField;
import com.chinamcloud.bigdata.haiheservice.es.result.EsPagedResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsSearchResult;
import com.chinamcloud.bigdata.haiheservice.util.JSONUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HotNewsDataParser {
    private SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    public Page<HotNews> parseRecords(EsPagedResult<EsSearchResult> result) {
        ArrayList<HotNews> news = new ArrayList<HotNews>();
        for (EsApsSearchField apsFeedback : ((EsSearchResult)result.getResult()).getRecords()) {
            HotNews hotNew = new HotNews();
            hotNew.setAuthor(apsFeedback.getTbNickname());
            hotNew.setCity(apsFeedback.getCrawlerKeywords());
            hotNew.setDocId(apsFeedback.getId());
            hotNew.setEmotionScore(apsFeedback.getEmotionScore());
            hotNew.setEmotionTendency(apsFeedback.getEmotionTendency());
            hotNew.setSimilarity(apsFeedback.getPointsCount());
            hotNew.setPubTime(this.dateFormat2.format(apsFeedback.getPubTime()));
            hotNew.setTitle(apsFeedback.getSubject());
            String description = apsFeedback.getDescription();
            if (StringUtils.isEmpty((CharSequence)description)) {
                description = "";
            }
            hotNew.setDescription(description);
            hotNew.setShortcut(this.parseDesc(apsFeedback.getDescription()));
            hotNew.setUrl(apsFeedback.getRefererUrl());
            hotNew.setClusterId(apsFeedback.getClusterId());
            hotNew.setCluster(apsFeedback.getSubject());
            hotNew.setParentSource(apsFeedback.getTbNickname());
            hotNew.setSourceId(apsFeedback.getSourceId());
            hotNew.setSpiderTopicId(apsFeedback.getSpiderTopicId());
            hotNew.setPics(apsFeedback.getPics());
            hotNew.setKeywords(apsFeedback.getSummaryKeywordList());
            hotNew.setCover(apsFeedback.getCover());
            hotNew.setDigest(apsFeedback.getDigest());
            hotNew.setCreatedAt(apsFeedback.getCreatedAt());
            hotNew.setReprint(apsFeedback.getReprint());
            String htmlDescription = apsFeedback.getHtmlDescription();
            if (StringUtils.isEmpty((CharSequence)htmlDescription)) {
                htmlDescription = "";
            }
            hotNew.setHtmlDescription(htmlDescription);
            hotNew.setSource(apsFeedback.getSource());
            hotNew.setIsOriginal(apsFeedback.getIsOriginal());
            news.add(hotNew);
        }
        Page<HotNews> pager = new Page<HotNews>(news);
        pager.setTotalCount(result.getTotalCount());
        pager.setPageSize(result.getPageSize());
        pager.setTotalPages(result.getTotalPages());
        return pager;
    }

    private List<String> parsePics(Map<String, String> cfsMap) {
        JSONArray jsonArray;
        String valueStr;
        ArrayList<String> picUrls = new ArrayList<String>();
        if (cfsMap != null && !StringUtils.isEmpty((CharSequence)(valueStr = cfsMap.get("101148"))) && (jsonArray = JSONUtils.parseJSONArray(valueStr)) != null) {
            int jsonArrayLength = jsonArray.size();
            for (int i = 0; i < jsonArrayLength; ++i) {
                JSONObject attachment = jsonArray.getJSONObject(i);
                String picUrl = attachment.getString("url");
                if (StringUtils.isEmpty((CharSequence)picUrl)) continue;
                picUrls.add(picUrl);
            }
        }
        return picUrls;
    }

    private String parseDesc(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        String shortcut = str.replace("[[+_+]]", "").replace("`n`", "").trim();
        if (StringUtils.isEmpty((CharSequence)shortcut)) {
            return "";
        }
        return shortcut;
    }
}

