/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.parser;

import com.chinamcloud.bigdata.haiheservice.bean.FacetTrend;
import com.chinamcloud.bigdata.haiheservice.es.bean.EsApsFacetField;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TopicTrendParser {
    private static Logger logger = LogManager.getLogger(TopicTrendParser.class);
    private SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public List<FacetTrend> parseRecords(List<EsApsFacetField> result) {
        ArrayList<FacetTrend> facets = new ArrayList<FacetTrend>();
        try {
            if (result.size() != 0) {
                List<String> values = result.get(0).getValues();
                List<Long> counts = result.get(0).getCounts();
                List<Long> metrics = result.get(0).getMetrics();
                for (int i = 0; i < values.size(); ++i) {
                    FacetTrend bean = new FacetTrend();
                    bean.setPubTime(this.formater.parse(values.get(i)).getTime());
                    bean.setDocCount(counts.get(i));
                    bean.setEmotionScore(metrics.get(i));
                    facets.add(bean);
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return facets;
    }
}

