/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.result;

import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.bean.EsApsFacetField;
import com.chinamcloud.bigdata.haiheservice.es.result.EsFacetResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsResultProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.springframework.util.ObjectUtils;

public class EsFacetGroupResultProcessor
implements EsResultProcessor<EsFeedbackQuery, SearchResponse> {
    public EsFacetResult<List<EsApsFacetField>> processResult(EsFeedbackQuery query, SearchResponse response) {
        String name = query.getFacetField();
        String type = query.getType();
        EsFacetResult<List<EsApsFacetField>> facetResult = null;
        try {
            ArrayList<EsApsFacetField> list = new ArrayList<EsApsFacetField>();
            MultiBucketsAggregation agg = (MultiBucketsAggregation)response.getAggregations().get("agg");
            EsApsFacetField apsFacetField = new EsApsFacetField();
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<Long> counts = new ArrayList<Long>();
            ArrayList<Map<String, Long>> mapList = new ArrayList<Map<String, Long>>();
            for (MultiBucketsAggregation.Bucket entry : agg.getBuckets()) {
                Object key = entry.getKey();
                String keyAsString = entry.getKeyAsString();
                long docCount = entry.getDocCount();
                MultiBucketsAggregation agg1 = (MultiBucketsAggregation)entry.getAggregations().get("agg1");
                if (agg1 == null) {
                    if (ObjectUtils.isEmpty((Object)key)) continue;
                    if (StringUtils.isNotBlank((CharSequence)keyAsString)) {
                        values.add(keyAsString);
                    } else {
                        values.add(String.valueOf(key));
                    }
                    counts.add(docCount);
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)key)) continue;
                if (StringUtils.isNotBlank((CharSequence)keyAsString)) {
                    values.add(keyAsString);
                } else {
                    values.add(String.valueOf(key));
                }
                HashMap<String, Long> map = new HashMap<String, Long>();
                for (MultiBucketsAggregation.Bucket bucket : agg1.getBuckets()) {
                    Object bucketKey = bucket.getKey();
                    Long bucketDocCount = bucket.getDocCount();
                    if (ObjectUtils.isEmpty((Object)bucketKey)) continue;
                    map.put(bucketKey.toString(), bucketDocCount);
                }
                mapList.add(map);
            }
            apsFacetField.setName(name);
            apsFacetField.setValues(values);
            apsFacetField.setCounts(counts);
            apsFacetField.setMapList(mapList);
            list.add(apsFacetField);
            facetResult = new EsFacetResult(list, (Boolean)true);
        }
        catch (Exception e) {
            facetResult = new EsFacetResult<List<EsApsFacetField>>(e.getMessage(), (Boolean)false);
            e.printStackTrace();
        }
        return facetResult;
    }
}

