/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.service;

import com.alibaba.druid.util.StringUtils;
import com.chinamcloud.bigdata.haiheservice.bean.CustomCloumnBean;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import com.chinamcloud.bigdata.haiheservice.bean.SiteConfig;
import com.chinamcloud.bigdata.haiheservice.bean.SiteStatistic;
import com.chinamcloud.bigdata.haiheservice.dao.SiteStatisticDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SiteStatisticService {
    @Autowired
    private SiteStatisticDao dao;

    public List<SiteStatistic> findSitesByUserId(Long userId) {
        return this.dao.findSitesByUserId(userId);
    }

    public List<SiteStatistic> findStatisticList() {
        return this.dao.findStatisticListByUserIds(new Long[0]);
    }

    public List<SiteStatistic> findStatisticListByUserIds(Long ... userId) {
        return this.dao.findStatisticListByUserIds(userId);
    }

    public List<SiteStatistic> findStatisticListByUserIds(String userIds) {
        String[] split = userIds.split(",");
        Long[] longs = new Long[split.length];
        for (int i = 0; i < split.length; ++i) {
            longs[i] = Long.valueOf(split[i]);
        }
        return this.dao.findStatisticListByUserIds(longs);
    }

    public List<SiteStatistic> findStatisticList(Long userId, int catId) {
        return this.dao.findStatisticList(userId, (Integer)catId);
    }

    public List<SiteStatistic> findStatisticList(String userIds, int catId) {
        return this.dao.findStatisticList(userIds, (Integer)catId);
    }

    public boolean updateStatistic(SiteStatistic siteStatistic) {
        return this.dao.updateStatistic(siteStatistic);
    }

    public boolean updateStatistic(List<SiteStatistic> siteStatistic) {
        return this.dao.updateStatistic(siteStatistic);
    }

    public List<SiteStatistic> findSourceIdListByUserId(String provinceId) {
        return this.dao.findSourceIdListByUserId(provinceId);
    }

    public SiteConfig findSiteStatus(long userId) {
        SiteConfig siteStaus = this.dao.findSiteStatus(userId);
        if (siteStaus == null) {
            siteStaus = new SiteConfig();
            siteStaus.setWangzhanVisible("ON");
            siteStaus.setWeiboVisible("ON");
            siteStaus.setWeixinVisible("ON");
        }
        return siteStaus;
    }

    public List<FacetResult> findSiteCount(long userId) {
        List<FacetResult> siteCounts = this.dao.findSiteCount(userId);
        SiteConfig siteStatus = this.dao.findSiteStatus(userId);
        return siteCounts.stream().filter(x -> {
            String name = x.getName();
            if (siteStatus != null) {
                if (name.equals("1") && siteStatus.getWangzhanVisible().equals("ON")) {
                    return true;
                }
                if (name.equals("2") && siteStatus.getWeiboVisible().equals("ON")) {
                    return true;
                }
                if (name.equals("3") && siteStatus.getWeixinVisible().equals("ON")) {
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
    }

    public List<FacetResult> findSiteCount(String userIds) {
        Map<Long, List<FacetResult>> siteCount = this.dao.findSiteCount(userIds);
        Map<Long, SiteConfig> siteStatus = this.dao.findSiteStatus(userIds);
        if (siteCount == null || siteStatus == null) {
            return null;
        }
        ArrayList<FacetResult> list = new ArrayList<FacetResult>();
        if (StringUtils.isEmpty((String)userIds)) {
            return null;
        }
        SiteConfig activeUser = siteStatus.get(Long.valueOf(userIds.split(",")[0]));
        if (activeUser == null) {
            return null;
        }
        HashMap<String, FacetResult> map = new HashMap<String, FacetResult>();
        for (Map.Entry<Long, List<FacetResult>> entry : siteCount.entrySet()) {
            List<FacetResult> siteCounts;
            List tmp;
            Long key = entry.getKey();
            SiteConfig siteConfig = siteStatus.get(key);
            if (siteConfig == null || (tmp = (siteCounts = entry.getValue()).stream().filter(x -> {
                String name = x.getName();
                if (siteConfig != null) {
                    if (name.equals("1") && siteConfig.getWangzhanVisible().equals("ON") && activeUser.getWangzhanVisible().equals("ON")) {
                        return true;
                    }
                    if (name.equals("2") && siteConfig.getWeiboVisible().equals("ON") && activeUser.getWeiboVisible().equals("ON")) {
                        return true;
                    }
                    if (name.equals("3") && siteConfig.getWeixinVisible().equals("ON") && activeUser.getWeixinVisible().equals("ON")) {
                        return true;
                    }
                }
                return false;
            }).collect(Collectors.toList())) == null || tmp.isEmpty()) continue;
            for (FacetResult facetResult : tmp) {
                FacetResult facet = (FacetResult)map.get(facetResult.getName());
                if (facet == null) {
                    facetResult.setNegative(null);
                    map.put(facetResult.getName(), facetResult);
                    continue;
                }
                facet.setValue(facet.getValue() + facetResult.getValue());
            }
        }
        for (Map.Entry<Long, List<FacetResult>> entry : map.entrySet()) {
            list.add((FacetResult)((Object)entry.getValue()));
        }
        return list;
    }

    public Map<String, List<SiteStatistic>> findSitesWithConfig(Long userId, int catId, String flag) {
        List<SiteStatistic> sites = this.dao.findStatisticList(userId, (Integer)catId);
        List<Object> sites_has_no_keysourceIds = new ArrayList();
        ArrayList<SiteStatistic> keySourceIds = new ArrayList<SiteStatistic>();
        Map<Integer, String> sitesInfo = sites.stream().collect(Collectors.toMap(SiteStatistic::getSourceId, SiteStatistic::getName));
        SiteConfig siteConfig = this.dao.findSiteConfig(userId);
        String[] tmpKeySourceIds = null;
        if (siteConfig != null) {
            switch (catId) {
                case 1: {
                    String wangzhanSourcesIds = siteConfig.getWangzhanSourcesIds();
                    if (StringUtils.isEmpty((String)wangzhanSourcesIds)) break;
                    tmpKeySourceIds = wangzhanSourcesIds.split(",");
                    break;
                }
                case 2: {
                    String weiboSourcesIds = siteConfig.getWeiboSourcesIds();
                    if (StringUtils.isEmpty((String)weiboSourcesIds)) break;
                    tmpKeySourceIds = weiboSourcesIds.split(",");
                    break;
                }
                case 3: {
                    String weixinSourcesIds = siteConfig.getWeixinSourcesIds();
                    if (StringUtils.isEmpty((String)weixinSourcesIds)) break;
                    tmpKeySourceIds = weixinSourcesIds.split(",");
                    break;
                }
            }
            if (tmpKeySourceIds != null) {
                for (String tmpKeySourceId : tmpKeySourceIds) {
                    SiteStatistic bean = new SiteStatistic();
                    Integer sourceId = Integer.valueOf(tmpKeySourceId);
                    bean.setSourceId(sourceId);
                    bean.setName(sitesInfo.getOrDefault(sourceId, "\u9519\u8bef"));
                    keySourceIds.add(bean);
                }
            }
        }
        HashMap<String, List<SiteStatistic>> result = new HashMap<String, List<SiteStatistic>>();
        if (flag.equals("true")) {
            List tmp = Arrays.asList(tmpKeySourceIds);
            sites_has_no_keysourceIds = sites.stream().filter(x -> !tmp.contains(String.valueOf(x.getSourceId()))).collect(Collectors.toList());
            result.put("allSourceIds", sites_has_no_keysourceIds);
        } else {
            result.put("allSourceIds", sites);
        }
        result.put("keySourceIds", keySourceIds);
        return result;
    }

    public Map<String, List<SiteStatistic>> findSitesWithConfig(String userIds, int catId, String flag) {
        List<SiteStatistic> sites = this.dao.findStatisticList(userIds, (Integer)catId);
        List<Object> sites_has_no_keysourceIds = new ArrayList();
        ArrayList<SiteStatistic> keySourceIds = new ArrayList<SiteStatistic>();
        Map<Integer, String> sitesInfo = sites.stream().collect(Collectors.toMap(SiteStatistic::getSourceId, SiteStatistic::getName));
        Map<Long, SiteConfig> siteConfig = this.dao.findSiteConfig(userIds);
        final ArrayList<String> tmpKeySourceIds = new ArrayList<String>();
        ArrayList<String> tmpKeys = new ArrayList<String>();
        List<String> asList = Arrays.asList(userIds.split(","));
        for (Map.Entry<Long, SiteConfig> configEntry : siteConfig.entrySet()) {
            Long userId = configEntry.getKey();
            SiteConfig config = configEntry.getValue();
            if (config == null) continue;
            switch (catId) {
                case 1: {
                    String wangzhanSourcesIds = config.getWangzhanSourcesIds();
                    if (StringUtils.isEmpty((String)wangzhanSourcesIds)) break;
                    tmpKeySourceIds.addAll(Arrays.asList(wangzhanSourcesIds.split(",")));
                    if (!asList.get(0).equals(userId.toString())) break;
                    tmpKeys.addAll(Arrays.asList(wangzhanSourcesIds.split(",")));
                    break;
                }
                case 2: {
                    String weiboSourcesIds = config.getWeiboSourcesIds();
                    if (StringUtils.isEmpty((String)weiboSourcesIds)) break;
                    tmpKeySourceIds.addAll(Arrays.asList(weiboSourcesIds.split(",")));
                    if (!asList.get(0).equals(userId.toString())) break;
                    tmpKeys.addAll(Arrays.asList(weiboSourcesIds.split(",")));
                    break;
                }
                case 3: {
                    String weixinSourcesIds = config.getWeixinSourcesIds();
                    if (StringUtils.isEmpty((String)weixinSourcesIds)) break;
                    tmpKeySourceIds.addAll(Arrays.asList(weixinSourcesIds.split(",")));
                    if (!asList.get(0).equals(userId.toString())) break;
                    tmpKeys.addAll(Arrays.asList(weixinSourcesIds.split(",")));
                    break;
                }
            }
        }
        if (tmpKeySourceIds != null) {
            for (String tmpKey : tmpKeys) {
                SiteStatistic bean = new SiteStatistic();
                Integer sourceId = Integer.valueOf(tmpKey);
                bean.setSourceId(sourceId);
                bean.setName(sitesInfo.getOrDefault(sourceId, "\u9519\u8bef"));
                keySourceIds.add(bean);
            }
        }
        HashMap<String, List<SiteStatistic>> result = new HashMap<String, List<SiteStatistic>>();
        if (flag.equals("true")) {
            ArrayList<String> tmp = new ArrayList<String>(){
                {
                    this.addAll(tmpKeySourceIds);
                }
            };
            sites_has_no_keysourceIds = sites.stream().filter(x -> !tmp.contains(String.valueOf(x.getSourceId()))).collect(Collectors.toList());
            result.put("allSourceIds", sites_has_no_keysourceIds);
        } else {
            result.put("allSourceIds", sites);
        }
        result.put("keySourceIds", keySourceIds);
        return result;
    }

    public boolean saveSiteConfig(long userId, SiteConfig conf) {
        Pattern p = Pattern.compile("[\\d,]*+");
        StringBuilder builder = new StringBuilder();
        String wzSourcesIds = conf.getWangzhanSourcesIds();
        String wbSourcesIds = conf.getWeiboSourcesIds();
        String wxSourceIds = conf.getWeixinSourcesIds();
        if (p.matcher(wzSourcesIds).matches() && p.matcher(wbSourcesIds).matches() && p.matcher(wxSourceIds).matches()) {
            if (!StringUtils.isEmpty((String)wzSourcesIds)) {
                builder.append(wzSourcesIds + ",");
            }
            if (!StringUtils.isEmpty((String)wbSourcesIds)) {
                builder.append(wbSourcesIds + ",");
            }
            if (!StringUtils.isEmpty((String)wxSourceIds)) {
                builder.append(wxSourceIds);
            }
        } else {
            return false;
        }
        return this.dao.saveSiteConfig(conf, userId);
    }

    public List<CustomCloumnBean> getColumnsByCatId(String userIds, int catId) {
        return this.dao.getColumnsByCatId(userIds, catId);
    }

    public List<String> findSitesByColumns(String userIds, int catId, String column) {
        List<String> list = this.dao.getSitesByColumns(userIds, catId, column);
        if (list != null && list.size() >= 1) {
            String tmp = list.get(0);
            String[] split = tmp.split(",");
            return Arrays.asList(split);
        }
        return null;
    }

    public boolean saveColumn(Long userId, int catId, String column, String sourceIds) {
        return this.dao.saveColumn(userId, catId, column, sourceIds);
    }

    public boolean existCloumn(String groupId, String cloumnId) {
        return this.dao.existCloumn(groupId, cloumnId);
    }

    public boolean updateColumn(Long userId, String column, String sourceIds, String cloumnId) {
        return this.dao.updateColumn(userId, column, sourceIds, cloumnId);
    }

    public boolean deleteColumn(Long userId, String columnId) {
        return this.dao.deleteColumn(userId, columnId);
    }
}

