/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtils {
    private static Logger logger = LogManager.getLogger(HttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRequestResult executePost(String url, String queryParams) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        StringEntity entity = new StringEntity(queryParams, "UTF-8");
        entity.setContentType("text/json");
        httpPost.setEntity((HttpEntity)entity);
        HttpRequestResult requestResult = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity2 = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity2);
                EntityUtils.consume((HttpEntity)entity2);
                requestResult = new HttpRequestResult(Status.SUCCESS);
                requestResult.setMsg(result);
            } else {
                logger.error("http\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6570\u636e\u8fd4\u56de,url=" + url);
                requestResult = new HttpRequestResult(Status.FALILD);
                requestResult.setMsg("http\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6570\u636e\u8fd4\u56de,url=" + url);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            requestResult = new HttpRequestResult(Status.FALILD);
            requestResult.setMsg(e.getLocalizedMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return requestResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRequestResult executeGet(String url, Header[] headers) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpGet httpGet = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
        httpGet.setConfig(requestConfig);
        httpGet.addHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        httpGet.addHeader("Connection", "Keep-Alive");
        httpGet.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:29.0) Gecko/20100101 Firefox/29.0");
        httpGet.addHeader("Cookie", "");
        if (headers != null && headers.length > 0) {
            httpGet.setHeaders(headers);
        }
        HttpRequestResult requestResult = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
                requestResult = new HttpRequestResult(Status.SUCCESS);
                requestResult.setMsg(result);
            } else {
                logger.error("http\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6570\u636e\u8fd4\u56de,url = " + url);
                requestResult = new HttpRequestResult(Status.FALILD);
                requestResult.setMsg("http\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6570\u636e\u8fd4\u56de,url=" + url);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            requestResult = new HttpRequestResult(Status.FALILD);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return requestResult;
    }

    public static HttpRequestResult executeGet(String url, String queryParams, Header[] headers) {
        JSONObject params = JSON.parseObject((String)queryParams);
        if (params != null && !params.isEmpty()) {
            for (Map.Entry param : params.entrySet()) {
                url = url + "&" + (String)param.getKey() + "=" + param.getValue();
            }
        }
        return HttpUtils.executeGet(url, headers);
    }

    public static CloseableHttpClient getClient() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, trustAllCerts, null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(ctx);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRequestResult get(String url, Header[] headers, String str) {
        CloseableHttpClient httpClient = HttpUtils.getClient();
        CloseableHttpResponse response = null;
        RequestConfig requestConfig = null;
        HttpGet httpGet = new HttpGet(url);
        requestConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
        httpGet.setConfig(requestConfig);
        httpGet.addHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        httpGet.addHeader("Connection", "Keep-Alive");
        Random r = new Random();
        String[] ua = new String[]{"User-Agent : Mozilla/5.0 (Linux; U; Android 4.0.3; zh-cn; U8860 Build/HuaweiU8860) UC AppleWebKit/530+ (KHTML, like Gecko) Mobile Safari/530", "user-agent = Mozilla/5.0 (Linux; U; Android 2.3.7; zh-cn; GT-I9000 Build/MIUI) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1 360browser(securitypay,securityinstalled)", "user-agent = MQQBrowser/3.4/Adr (Linux; U; 2.3.7; zh-cn; GT-I9000 Build/MIUI.2.4.13;480*800)", "user-agent = Mozilla/5.0 (Linux; U; Android 2.3.7; zh-cn; GT-I9000 Build/MIUI) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1"};
        httpGet.addHeader("User-Agent", "User-Agent : Mozilla/5.0 (Linux; U; Android 4.0.3; zh-cn; U8860 Build/HuaweiU8860) UC AppleWebKit/530+ (KHTML, like Gecko) Mobile Safari/530");
        httpGet.addHeader("Cookie", "");
        if (headers != null && headers.length > 0) {
            httpGet.setHeaders(headers);
        }
        HttpRequestResult requestResult = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity, (String)str).trim();
                EntityUtils.consume((HttpEntity)entity);
                requestResult = new HttpRequestResult(Status.SUCCESS);
                requestResult.setMsg(result);
            } else {
                logger.error("http\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6570\u636e\u8fd4\u56de,url = " + url);
            }
        }
        catch (Throwable e) {
            logger.error("http\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6570\u636e\u8fd4\u56de,url = " + url);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return requestResult;
    }

    public static class HttpRequestResult {
        private final Status status;
        private String msg;

        public Status getStatus() {
            return this.status;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public HttpRequestResult(Status status) {
            this.status = status;
        }
    }

    public static enum Status {
        SUCCESS,
        FALILD;

    }
}

