/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeiboConf {
    private static final Log LOG = LogFactory.getLog(WeiboConf.class);
    private static final String CONF_PATH = "weibo-config.properties";
    private Long submitInterval;
    private Long workderInterval;

    public static void main(String[] args) {
        System.out.println(WeiboConf.getConf().getSubmitInterval());
    }

    private WeiboConf() {
        Properties properties = new Properties();
        StringBuffer logBuffer = new StringBuffer("loading Wechat config.........\n");
        try {
            properties.load(new InputStreamReader(WeiboConf.class.getClassLoader().getResourceAsStream(CONF_PATH), "UTF-8"));
            this.submitInterval = Long.parseLong(properties.getProperty("weibo.task.submit.interval.seconds"));
            this.workderInterval = Long.parseLong(properties.getProperty("weibo.task.worker.interval.seconds"));
            logBuffer.append("weibo.task.submit.interval.seconds=").append(this.submitInterval).append("\n");
            logBuffer.append("weibo.task.worker.interval.seconds=").append(this.workderInterval).append("\n");
        }
        catch (Exception e) {
            LOG.error((Object)"loading weibo-config error", (Throwable)e);
            this.submitInterval = 3L;
            this.workderInterval = 6L;
        }
        LOG.info((Object)logBuffer.toString());
    }

    public Long getSubmitInterval() {
        return this.submitInterval;
    }

    public void setSubmitInterval(Long submitInterval) {
        this.submitInterval = submitInterval;
    }

    public Long getWorkderInterval() {
        return this.workderInterval;
    }

    public void setWorkderInterval(Long workderInterval) {
        this.workderInterval = workderInterval;
    }

    public static WeiboConf getConf() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        static WeiboConf INSTANCE = new WeiboConf();

        private Holder() {
        }
    }
}

