/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisRecord;
import com.chinamcloud.bigdata.haiheservice.util.ConfigureUtils;
import com.chinamcloud.bigdata.haiheservice.util.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Component;

@Component
public class WeiboUtils {
    private static final Log logger = LogFactory.getLog(WeiboUtils.class);
    public static final List<Header> reqheaders = new ArrayList<Header>();

    public static Integer getWeiboForwards(String url) throws Exception {
        Integer forwards = null;
        for (int retryTimes = 0; retryTimes < 1; ++retryTimes) {
            try {
                url = url.replace("weibo\\.com", "weibo\\.cn").replace("weibo.com", "weibo.cn");
                String topicHtml = HttpUtils.get(url, null, "gb2312").getMsg();
                Document doc = Jsoup.parse((String)topicHtml);
                Elements script = doc.getElementsByTag("script");
                String value = "";
                if (script.size() > 2) {
                    String attr = ((Node)((Element)script.get(1)).childNodes().get(0)).attr("data");
                    String pattern = "reposts_count(.*?),";
                    Pattern r = Pattern.compile(pattern);
                    Matcher m = r.matcher(attr);
                    if (m.find()) {
                        value = m.group();
                    }
                } else {
                    Elements select = ((Element)doc.select("body").select("div").get(7)).select("span");
                    value = ((Element)select.get(0)).text();
                }
                if (StringUtils.isBlank((CharSequence)value)) {
                    return forwards;
                }
                String regEx = "[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(value);
                forwards = Integer.parseInt(m.replaceAll("").trim());
                continue;
            }
            catch (Exception e) {
                logger.error((Object)(e + " - get weibo forwards error. url:" + url + ", RetryTimes:" + retryTimes));
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return forwards;
    }

    public static final AnalysisRecord getWeiboDoc(String realUrl) {
        AnalysisRecord weiboDoc = null;
        for (int retryTimes = 0; retryTimes < 5; ++retryTimes) {
            try {
                String url = realUrl.replace("weibo\\.com", "weibo\\.cn").replace("weibo.com", "weibo.cn");
                String topicHtml = HttpUtils.get(url, null, "gb2312").getMsg();
                logger.info((Object)"html ->>  topicHtml");
                if ("unknown".equals(topicHtml)) {
                    return weiboDoc;
                }
                Document doc = Jsoup.parse((String)topicHtml);
                String regEx = "[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Elements eles = doc.getElementsByTag("script");
                weiboDoc = new AnalysisRecord();
                weiboDoc.setUrl(realUrl);
                String urlTemp = url.replace("http://", "").replace("https://", "");
                String uid = urlTemp.split("\\/")[1];
                weiboDoc.setUid(uid);
                if (eles.size() > 2) {
                    WeiboUtils.getWeiboDocScript(eles, weiboDoc, p);
                } else {
                    WeiboUtils.getWeiboDocHtml(doc, weiboDoc, p);
                }
                if (null != weiboDoc.getCreateAt()) break;
                weiboDoc.setCreateAt(new Date(System.currentTimeMillis()));
                break;
            }
            catch (Exception e) {
                logger.error((Object)(e + "- get weibo doc error. retryTimes:" + retryTimes));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return weiboDoc;
    }

    public static void getWeiboDocScript(Elements eles, AnalysisRecord weiboDoc, Pattern p) {
        String thumbsStr;
        Pattern thumbsPattern;
        Matcher thumbsMatcher;
        String commentsStr;
        Pattern commentsPattern;
        Matcher commentsMatcher;
        String sourceStr;
        Pattern sourcePattern;
        Matcher sourceMatcher;
        String userNameStr;
        Pattern userNamePattern;
        Matcher userNameMatcher;
        String contentStr;
        Pattern contentPattern;
        Matcher contentMatcher;
        String split;
        Pattern picPattern;
        String picStr;
        String attr = ((Node)((Element)eles.get(1)).childNodes().get(0)).attr("data");
        String imgStr = "type(.*?)video(.*?),";
        Pattern imgPattern = Pattern.compile(imgStr);
        Matcher imgMatcher = imgPattern.matcher(attr);
        if (imgMatcher.find()) {
            picStr = "\"url\":(.*?),";
            picPattern = Pattern.compile(picStr);
            Matcher picMatcher = picPattern.matcher(attr);
            if (picMatcher.find() && StringUtils.isNotBlank((CharSequence)(split = picMatcher.group().replace("\"url\":", "")))) {
                weiboDoc.setProfileImageURL(split.replace("\"", "").replace(",", "").trim());
            }
        } else {
            String s;
            picStr = "pics\":(.*?)],\"bid\":";
            picPattern = Pattern.compile(picStr);
            Matcher picMatcher = picPattern.matcher(s = attr.replaceAll(" ", "").replaceAll("\n", ""));
            if (picMatcher.find()) {
                ArrayList<String> imgList = new ArrayList<String>();
                String value = picMatcher.group().replace(",\"bid\":", "").replace("pics\":", "");
                List<Map<String, Object>> maps = WeiboUtils.toListMap(value);
                for (Map<String, Object> map : maps) {
                    Object o = map.get("url");
                    if (o == null) continue;
                    imgList.add(o.toString());
                }
                weiboDoc.setProfileImageURL(StringUtils.join(imgList, (String)";"));
            }
        }
        String timeStr = "\"created_at\":(.*?),";
        Pattern timePattern = Pattern.compile(timeStr);
        Matcher timeMatcher = timePattern.matcher(attr);
        if (timeMatcher.find()) {
            split = timeMatcher.group().replace("\"created_at\":", "");
            if (StringUtils.isNotBlank((CharSequence)split)) {
                String trim = split.replace("\"", "").replace(",", "").trim();
                String[] strings = trim.split(" ");
                if (strings.length >= 5) {
                    Date date = null;
                    try {
                        date = new Date(trim);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Acquisition time failed");
                    }
                    weiboDoc.setCreateAt(date);
                }
            } else {
                logger.error((Object)"userName label not found");
            }
        }
        if ((contentMatcher = (contentPattern = Pattern.compile(contentStr = "\"text\":(.*?),")).matcher(attr)).find()) {
            String content = contentMatcher.group().replace("\"text\": \"", "");
            if (content.length() > 2) {
                Document parse = Jsoup.parse((String)content.substring(0, content.length() - 2));
                content = parse.text();
            }
            content = content.replaceAll("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", "***");
            weiboDoc.setContent(content);
        }
        if ((userNameMatcher = (userNamePattern = Pattern.compile(userNameStr = "screen_name(.*?),")).matcher(attr)).find()) {
            String split2 = userNameMatcher.group().replace("screen_name\":", "");
            if (StringUtils.isNotBlank((CharSequence)split2)) {
                weiboDoc.setScreenName(split2.replace("\"", "").replace(",", "").trim());
            } else {
                logger.error((Object)"userName label not found");
            }
        }
        if ((sourceMatcher = (sourcePattern = Pattern.compile(sourceStr = "\"source\":(.*?),")).matcher(attr)).find()) {
            String split3 = sourceMatcher.group().replace("\"source\":", "");
            if (StringUtils.isNotBlank((CharSequence)split3)) {
                weiboDoc.setSource(split3.replace("\"", "").replace(",", "").trim());
            } else {
                logger.error((Object)"source label not found");
            }
        }
        String forwardsValue = "";
        String commentsValue = "";
        String thumbsValue = "";
        String forwardsStr = "reposts_count(.*?),";
        Pattern forwardsPattern = Pattern.compile(forwardsStr);
        Matcher forwardsMatcher = forwardsPattern.matcher(attr);
        if (forwardsMatcher.find()) {
            forwardsValue = forwardsMatcher.group();
        }
        if ((commentsMatcher = (commentsPattern = Pattern.compile(commentsStr = "comments_count(.*?),")).matcher(attr)).find()) {
            commentsValue = commentsMatcher.group();
        }
        if ((thumbsMatcher = (thumbsPattern = Pattern.compile(thumbsStr = "attitudes_count(.*?),")).matcher(attr)).find()) {
            thumbsValue = thumbsMatcher.group();
        }
        Matcher forwardsNum = p.matcher(forwardsValue);
        Matcher commentsNum = p.matcher(commentsValue);
        Matcher thumbsNum = p.matcher(thumbsValue);
        Long forwards = Long.parseLong(forwardsNum.replaceAll("").trim());
        Long comments = Long.parseLong(commentsNum.replaceAll("").trim());
        Long thumbs = Long.parseLong(thumbsNum.replaceAll("").trim());
        weiboDoc.setForwards(forwards);
        weiboDoc.setComments(comments);
        weiboDoc.setThumbs(thumbs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getWeiboDocHtml(Document doc, AnalysisRecord weiboDoc, Pattern p) {
        String content;
        Elements body = doc.select("body");
        Element elementV5 = (Element)body.select("div").get(4);
        if (!"M_".equals(elementV5.attr("id"))) {
            elementV5 = (Element)body.select("div#M_").get(0);
        }
        Element elementV7 = null;
        for (int i = 6; i < body.select("div").size(); ++i) {
            Element element = (Element)body.select("div").get(i);
            if (element.text().indexOf("\u8f6c\u53d1[") < 0 || element.text().indexOf("\u8bc4\u8bba[") < 0 || element.text().indexOf("\u8d5e[") < 0) continue;
            elementV7 = element;
            break;
        }
        Elements wbInfoEles = elementV5.select("div").select("a");
        weiboDoc.setScreenName(((Element)wbInfoEles.get(0)).text());
        Elements fromEles = elementV5.select("div").select("span");
        if (!fromEles.isEmpty()) {
            if (fromEles.size() < 2) {
                logger.error((Object)"time label not found");
            }
            Date createTime = WeiboUtils.parseDate(((Element)fromEles.get(1)).text());
            weiboDoc.setCreateAt(createTime);
        }
        if ((content = ((Element)fromEles.get(0)).text()).length() > 512) {
            content = content.substring(0, 500) + "...";
        }
        content = content.replaceAll("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", "***");
        weiboDoc.setContent(content);
        Elements picDiv = elementV5.select("div");
        if (picDiv.size() >= 2) {
            Elements picElements;
            if (elementV5.text().indexOf("\u7ec4\u56fe") >= 0) {
                picElements = ((Element)picDiv.get(0)).select("a");
                ArrayList<String> imgList = new ArrayList<String>();
                if (picElements.size() < 2) {
                    logger.error((Object)"Figure set label not found");
                }
                String href = "";
                for (Element picElement : picElements) {
                    if (picElement.text().indexOf("\u7ec4\u56fe") < 0) continue;
                    href = picElement.attr("href");
                    break;
                }
                int time = 1;
                if (StringUtils.isNotBlank((CharSequence)href)) {
                    boolean temp = true;
                    while (temp && time < 5) {
                        try {
                            String imgs = HttpUtils.get("https://weibo.cn" + href, null, "gb2312").getMsg();
                            Document img = Jsoup.parse((String)imgs);
                            Elements imgDiv = img.select("body").select("div");
                            if (imgDiv.size() > 2) {
                                for (int i = 1; i < imgDiv.size() - 1; ++i) {
                                    imgList.add("https://weibo.cn" + ((Element)((Element)imgDiv.get(i)).select("a").get(0)).attr("href"));
                                }
                            } else {
                                logger.error((Object)"Failed to obtain graph group data");
                            }
                            temp = false;
                        }
                        catch (Exception e) {
                            logger.error((Object)("retry " + time + " times"));
                            logger.error((Object)e);
                        }
                        finally {
                            ++time;
                        }
                    }
                } else {
                    logger.error((Object)"Figure set connect not found");
                }
                if (time >= 5) {
                    Elements picElement = picDiv.select("img.ib");
                    if (picElements == null) {
                        logger.error((Object)"pic label not found");
                    } else {
                        weiboDoc.setProfileImageURL(StringUtils.join((Object[])new String[]{picElement.attr("src"), ";"}));
                    }
                } else {
                    weiboDoc.setProfileImageURL(StringUtils.join(imgList, (String)";"));
                }
            } else {
                picElements = picDiv.select("img.ib");
                if (picElements == null) {
                    logger.error((Object)"pic label not found");
                } else {
                    weiboDoc.setProfileImageURL(StringUtils.join((Object[])new String[]{picElements.attr("src"), ";"}));
                }
            }
        } else {
            String videoHref;
            String videoHtml;
            Document video;
            String style;
            String[] split;
            Elements videoElements = ((Element)picDiv.get(0)).select("a");
            if (videoElements.size() < 2) {
                logger.error((Object)"Video label not found");
            }
            if ((split = (style = (video = Jsoup.parse((String)(videoHtml = HttpUtils.get(videoHref = ((Element)videoElements.get(1)).attr("href"), null, "gb2312").getMsg()))).select("body").select("div.vjs-poster").attr("style")).split("\"")).length >= 2) {
                weiboDoc.setProfileImageURL(split[1]);
            } else {
                logger.error((Object)"Video thumbnail not found");
            }
        }
        if (elementV7 == null) {
            logger.error((Object)"not find Retweets, thumb up, comments ,No corresponding label was found");
            return;
        }
        Elements span = elementV7.select("span");
        if (span.size() >= 3) {
            Element forwardsEles = (Element)span.get(0);
            Element commentsEle = (Element)span.get(1);
            Element thumbsEle = (Element)span.get(2);
            Matcher forwardsMatcher = null;
            Matcher commentsMatcher = null;
            Matcher thumbsMatcher = null;
            try {
                forwardsMatcher = p.matcher(forwardsEles.text());
                commentsMatcher = p.matcher(commentsEle.text());
                thumbsMatcher = p.matcher(thumbsEle.text());
            }
            catch (Exception e) {
                logger.error((Object)"not find Retweets, thumb up, comments , Failed to get data");
            }
            Long forwards = Long.parseLong(forwardsMatcher.replaceAll("").trim());
            Long comments = Long.parseLong(commentsMatcher.replaceAll("").trim());
            Long thumbs = Long.parseLong(thumbsMatcher.replaceAll("").trim());
            weiboDoc.setForwards(forwards);
            weiboDoc.setComments(comments);
            weiboDoc.setThumbs(thumbs);
        } else {
            logger.error((Object)"not find Retweets, thumb up, comments , Failed to get data");
        }
    }

    private static Date parseDate(String text) {
        String dateText = null;
        if (text.contains("\u5206\u949f\u524d")) {
            int minutes = Integer.parseInt(text.replace("\u5206\u949f\u524d", ""));
            DateTime dateTime = DateTime.now().minusMinutes(minutes);
            dateText = dateTime.toString("yyyy-MM-dd HH:mm");
        } else if (text.contains("\u4eca\u5929")) {
            String todayText = DateTime.now().toString("yyyy-MM-dd");
            String timeText = text.split(" ")[1];
            dateText = todayText + " " + timeText;
        } else if (text.contains("\u6708")) {
            int month = Integer.parseInt(text.substring(0, text.indexOf("\u6708")));
            int day = Integer.parseInt(text.substring(text.indexOf("\u6708") + 1, text.indexOf("\u65e5")));
            String timeText = text.split(" ")[1];
            int year = Calendar.getInstance().get(1);
            dateText = year + "-" + (month >= 10 ? Integer.valueOf(month) : "0" + month) + "-" + (day >= 10 ? Integer.valueOf(day) : "0" + day) + " " + timeText;
        } else {
            int year = Integer.parseInt(text.split("-")[0]);
            int month = Integer.parseInt(text.split("-")[1]);
            int day = Integer.parseInt(text.split("-")[2].split(" ")[0]);
            String timeText = text.split(" ")[1];
            dateText = year + "-" + (month >= 10 ? Integer.valueOf(month) : "0" + month) + "-" + (day >= 10 ? Integer.valueOf(day) : "0" + day) + " " + timeText;
        }
        DateTime dateTime = DateTime.parse((String)dateText, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm"));
        return new Date(dateTime.getMillis());
    }

    public static List<Map<String, Object>> toListMap(String json) {
        JSONArray list = JSON.parseArray((String)json);
        ArrayList<Map<String, Object>> listw = new ArrayList<Map<String, Object>>();
        for (Object object : list) {
            HashMap ageMap = new HashMap();
            Map ret = (Map)object;
            listw.add(ret);
        }
        return listw;
    }

    public static void main(String[] args) throws Exception {
        String url = "https://weibo.com/5878659096/IpTk6nRgR?ref=home&rid=2_0_8_4734676873728556288_0_0_0&type=comment";
        System.out.println(WeiboUtils.getWeiboDoc(url).getCreateAt());
    }

    static {
        Properties properties = new Properties();
        try {
            logger.info((Object)"loading weiboheaders.properties");
            properties.load(ConfigureUtils.class.getResourceAsStream("/config/weiboheaders.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("load weiboheaders.properties failed");
        }
        logger.info((Object)"loaded weiboheaders.properties");
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        entrySet.forEach(x -> reqheaders.add((Header)new BasicHeader(x.getKey().toString(), x.getValue().toString())));
    }
}

