/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.layoutdata.client.core;

import cn.hutool.core.io.file.FileReader;
import com.chinamcloud.bigdata.layoutdata.client.core.ILayoutDataRepository;
import com.chinamcloud.bigdata.layoutdata.client.po.LocalDataPO;
import com.chinamcloud.bigdata.layoutdata.client.utils.TemplateEqualsUtils;
import com.chinamcloud.bigdata.layoutdata.params.DataQueryParams;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDataRepository
implements ILayoutDataRepository {
    private Logger logger = LoggerFactory.getLogger(LocalDataRepository.class);
    private Map<SearchKey, List<LocalDataPO>> pos = new HashMap<SearchKey, List<LocalDataPO>>();
    private boolean start = false;
    private ObjectMapper mapper = new ObjectMapper();
    private String parentFilePath;
    private String suffix;

    public LocalDataRepository() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.parentFilePath = "layout_data/";
        this.suffix = ".json";
    }

    public String getParentFilePath() {
        return this.parentFilePath;
    }

    public void setParentFilePath(String parentFilePath) {
        this.parentFilePath = parentFilePath;
    }

    @Override
    public String queryData(DataQueryParams params) {
        String url;
        String serviceName = params.getServiceName();
        SearchKey key = new SearchKey(serviceName, url = params.getUrl());
        List<LocalDataPO> dataPOs = this.pos.get(key);
        if (dataPOs != null && !dataPOs.isEmpty()) {
            Map<String, Object> parameterObjs = params.getParameterObj();
            LocalDataPO localDataPO = null;
            for (LocalDataPO po : dataPOs) {
                if (!TemplateEqualsUtils.equals(po.getParams(), parameterObjs)) continue;
                localDataPO = po;
                break;
            }
            if (localDataPO != null) {
                return localDataPO.getData();
            }
        }
        return null;
    }

    @Override
    public synchronized void start() {
        if (this.start) {
            this.logger.warn("LocalDataRepository has started!,please stop first!");
        }
        if (StringUtils.isBlank((CharSequence)this.parentFilePath)) {
            throw new IllegalArgumentException("parentFilePath can not be blank");
        }
        File file = new File(this.parentFilePath);
        if (file.exists() && file.canRead()) {
            File[] files = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(LocalDataRepository.this.suffix);
                }
            });
            this.logger.info("files size is[" + files.length + "]");
            if (files.length > 0) {
                ObjectReader reader = this.mapper.readerFor(LocalDataPO.class);
                for (File dataFile : files) {
                    String data = FileReader.create((File)dataFile).readString();
                    if (!StringUtils.isNotBlank((CharSequence)data)) continue;
                    try {
                        LocalDataPO po = (LocalDataPO)reader.readValue(data);
                        if (!StringUtils.isNotBlank((CharSequence)po.getServiceName()) || !StringUtils.isNotBlank((CharSequence)po.getUrl())) continue;
                        SearchKey key = new SearchKey(po.getServiceName(), po.getUrl());
                        List<LocalDataPO> localDataPOs = this.pos.get(key);
                        if (localDataPOs == null) {
                            localDataPOs = new LinkedList<LocalDataPO>();
                            this.pos.put(key, localDataPOs);
                        }
                        localDataPOs.add(po);
                    }
                    catch (Exception e) {
                        this.logger.error("load file[" + dataFile.getAbsolutePath() + "] failed!");
                        this.logger.error(e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("parentFilePath not exist or can not read");
        }
        this.start = true;
    }

    @Override
    public synchronized void stop() {
        if (this.start) {
            this.pos.clear();
        }
    }

    private class SearchKey {
        private final String serviceName;
        private final String url;

        public SearchKey(String serviceName, String url) {
            this.serviceName = serviceName;
            this.url = url;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getUrl() {
            return this.url;
        }

        public int hashCode() {
            return (this.serviceName + "$" + this.url).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SearchKey) {
                SearchKey key = (SearchKey)obj;
                String serviceName = key.getServiceName();
                String url = key.getUrl();
                return this.serviceName.equals(serviceName) && this.url.equals(url);
            }
            return false;
        }
    }
}

