/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.layoutdata.client.core;

import cn.hutool.core.util.URLUtil;
import cn.hutool.crypto.SecureUtil;
import com.chinamcloud.bigdata.common.http.utils.HttpRequestSetter;
import com.chinamcloud.bigdata.common.http.utils.HttpUtils;
import com.chinamcloud.bigdata.layoutdata.client.core.CacheKey;
import com.chinamcloud.bigdata.layoutdata.client.core.ILayoutDataCache;
import com.chinamcloud.bigdata.layoutdata.client.core.ILayoutDataRepository;
import com.chinamcloud.bigdata.layoutdata.client.core.RequestMethod;
import com.chinamcloud.bigdata.layoutdata.params.DataQueryParams;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDataRepository
implements ILayoutDataRepository {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean start = false;
    private HostGenerator hostGenerator = null;
    private Logger logger = LoggerFactory.getLogger(RemoteDataRepository.class);
    private ILayoutDataCache cache;
    private ObjectMapper mapper = new ObjectMapper();

    public ILayoutDataCache getCache() {
        return this.cache;
    }

    public void setCache(ILayoutDataCache cache) {
        this.cache = cache;
    }

    public RemoteDataRepository(String host) {
        this.hostGenerator = () -> host;
    }

    public RemoteDataRepository(HostGenerator generator) {
        this.hostGenerator = generator;
    }

    @Override
    public String queryData(DataQueryParams params) {
        if (!this.start) {
            this.logger.error("repository has not start!");
            return null;
        }
        if (this.lock.readLock().tryLock() && this.start) {
            RequestMethod requestMethod = params.getRequestMethod();
            if (requestMethod == RequestMethod.POST) {
                String data = this.getDataFromCache(params);
                if (StringUtils.isNotBlank((CharSequence)data)) {
                    return data;
                }
                Map<String, Object> object = params.getParameterObj();
                SearchKey searchKey = new SearchKey(params.getEnv(), params.getServiceName(), object == null || object.isEmpty() ? null : object);
                String host = this.hostGenerator.generator();
                try {
                    this.logger.debug("requestUrl=" + URLUtil.normalize((String)(host + "/post/" + params.getUrl())));
                    this.logger.debug("requestContent=" + this.mapper.writeValueAsString((Object)searchKey));
                    String result = HttpUtils.executePost((String)URLUtil.normalize((String)(host + "/post/" + params.getUrl())), (String)this.mapper.writeValueAsString((Object)searchKey), (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

                        public void process(HttpRequestBase base) {
                            base.setHeader("Content-Type", "application/json;charset=utf-8");
                        }
                    }});
                    this.logger.debug("response result=" + result);
                    if (StringUtils.isNotBlank((CharSequence)result)) {
                        this.putDataToCache(params, result);
                    }
                    return result;
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.logger.info("multi thread is stop or start repository");
        }
        return null;
    }

    private CacheKey buildCacheKey(DataQueryParams params) {
        Map<String, Object> parameterObj = params.getParameterObj();
        String paramSign = "";
        if (parameterObj != null && !parameterObj.isEmpty()) {
            try {
                paramSign = SecureUtil.md5((String)this.mapper.writeValueAsString(parameterObj));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return null;
            }
        }
        CacheKey cacheKey = new CacheKey(params.getServiceName(), params.getUrl());
        cacheKey.setParamSign(paramSign);
        return cacheKey;
    }

    private String getDataFromCache(DataQueryParams params) {
        if (this.cache != null) {
            CacheKey cacheKey = this.buildCacheKey(params);
            return (String)this.cache.getData(cacheKey);
        }
        return null;
    }

    private boolean putDataToCache(DataQueryParams params, String data) {
        if (this.cache != null) {
            CacheKey cacheKey = this.buildCacheKey(params);
            return this.cache.putData(cacheKey, data);
        }
        return true;
    }

    @Override
    public void start() {
        if (this.start) {
            this.logger.info("start remote repository is started!");
            return;
        }
        if (this.lock.writeLock().tryLock() && !this.start) {
            try {
                if (this.hostGenerator == null) {
                    this.logger.error("repository host generator is null");
                    throw new IllegalArgumentException("repository host generator is null");
                }
                this.logger.info("start remote repository");
                this.logger.info("cache is[" + (this.cache == null ? "NULL" : this.cache.getClass()) + "]");
                this.start = true;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            this.logger.info("multi thread is stop or start repository");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stop() {
        if (!this.start) {
            this.logger.info("repository has stop!");
            return;
        }
        if (this.lock.writeLock().tryLock() && this.start) {
            try {
                this.logger.info("stop remote repository");
                if (this.cache == null) return;
                this.cache.destory();
                return;
            }
            finally {
                this.start = false;
                this.lock.writeLock().unlock();
            }
        } else {
            this.logger.info("multi thread is stop or start repository");
        }
    }

    private class SearchKey {
        private final String serviceName;
        private final String env;
        private final Map<String, Object> parameterObj;

        public String getEnv() {
            return this.env;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public Map<String, Object> getParameterObj() {
            return this.parameterObj;
        }

        public SearchKey(String env, String serviceName, Map<String, Object> parameterObj) {
            this.env = env;
            this.serviceName = serviceName;
            this.parameterObj = parameterObj;
        }
    }

    @FunctionalInterface
    public static interface HostGenerator {
        public String generator();
    }
}

