/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.newsanalysis.common.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.chinamcloud.bigdata.newsanalysis.common.config.DataSourceProperties;
import javax.sql.DataSource;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@EnableConfigurationProperties(value={DataSourceProperties.class})
@MapperScan(basePackages={"com.chinamcloud.bigdata.newsanalysis.*.mapper.mysql"}, sqlSessionFactoryRef="MysqlSqlSessionFactory")
public class MysqlConfig {
    private static final Logger log = LogManager.getLogger(MysqlConfig.class);
    @Autowired
    private DataSourceProperties dataSourceProperties;

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.H2));
        return interceptor;
    }

    @Primary
    @Bean(value={"MysqlDataSource"})
    public DataSource getMysqlDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.dataSourceProperties.getMysql().get("url"));
        datasource.setUsername(this.dataSourceProperties.getMysql().get("username"));
        datasource.setPassword(this.dataSourceProperties.getMysql().get("password"));
        datasource.setDbType(this.dataSourceProperties.getMysql().get("type"));
        datasource.setDriverClassName(this.dataSourceProperties.getMysql().get("driver-class-name"));
        return datasource;
    }

    @Primary
    @Bean(value={"MysqlSqlSessionFactory"})
    public SqlSessionFactory MysqlSqlSessionFactory(@Qualifier(value="MysqlDataSource") DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean sqlSessionFactory = new MybatisSqlSessionFactoryBean();
        sqlSessionFactory.setDataSource(dataSource);
        sqlSessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/mysql/*.xml"));
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        configuration.setLogImpl(StdOutImpl.class);
        sqlSessionFactory.setConfiguration(configuration);
        sqlSessionFactory.setPlugins(new Interceptor[]{this.mybatisPlusInterceptor()});
        return sqlSessionFactory.getObject();
    }

    @Bean(name={"mysqlTransactionManager"})
    public DataSourceTransactionManager transactionManagerOne(@Qualifier(value="MysqlDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer() {
        return configuration -> configuration.setUseDeprecatedExecutor(false);
    }

    @Primary
    @Bean(value={"MysqlSqlSessionTemplate"})
    public SqlSessionTemplate MysqlSqlSessionTemplate(@Qualifier(value="MysqlSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

