/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.newsanalysis.common.pojo;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.chinamcloud.bigdata.newsanalysis.common.pojo.UserTokenBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@TableName(value="plan_info")
public class PlanInfo
extends UserTokenBean
implements Serializable {
    private static final long serialVersionUID = -2574179391709766308L;
    @TableId(value="plan_id", type=IdType.INPUT)
    private Long planId;
    private String planName;
    private String classify;
    private String location;
    @JsonIgnore
    @TableField(exist=false)
    @JSONField(serialize=false)
    private Date weixinCrawlerTime;
    @JsonIgnore
    @TableField(exist=false)
    @JSONField(serialize=false)
    private Long maxArticleId;
    @JsonIgnore
    @TableField(exist=false)
    @JSONField(serialize=false)
    private Date weiboCrawlerTime;
    private String keywords;
    @JsonIgnore
    @TableField(exist=false)
    private List<String> keywordsList;
    private String noKeywords;
    @JsonIgnore
    @TableField(exist=false)
    private List<String> noKeywordsList;
    @JsonIgnore
    @JSONField(serialize=false)
    private Long lastVisitTime;
    @JsonIgnore
    @JSONField(serialize=false)
    private Long lastExecutionTime;
    @TableField(value="creation_time")
    private Date creationTime;
    @JsonIgnore
    @JSONField(serialize=false)
    @TableField(value="update_time")
    private Date updateTime;
    @JsonIgnore
    private String version;
    private Integer status;

    public PlanInfo(Long planId, String planName, String classify, String keywords, String noKeywords) {
        this.planId = planId;
        this.planName = planName;
        this.classify = classify;
        this.keywords = keywords;
        this.noKeywords = noKeywords;
    }

    public PlanInfo(Long planId, String planName, String classify, String location, String userToken, Integer status) {
        this.planId = planId;
        this.planName = planName;
        this.classify = classify;
        this.location = location;
        this.setUserToken(userToken);
        this.status = status;
    }

    public PlanInfo(String groupId, Integer status) {
        this.setGroupId(groupId);
        this.status = status;
    }

    public PlanInfo(Long planId, String planName, String groupId) {
        this.planId = planId;
        this.planName = planName;
        this.setGroupId(groupId);
    }

    public PlanInfo(Long planId, String planName, String userToken, String groupId) {
        this.planId = planId;
        this.planName = planName;
        this.setUserToken(userToken);
        this.setGroupId(groupId);
    }

    public static PlanInfo defaultPlan() {
        return new PlanInfo(123L, "\u5f53\u524d\u70ed\u70b9", "default", "default");
    }

    public PlanInfo(String userToken, String groupId) {
        this.setUserToken(userToken);
        this.setGroupId(groupId);
    }

    public List<String> getKeywordsList() {
        if (this.keywordsList == null) {
            this.keywordsList = new ArrayList<String>();
            if (StringUtils.isBlank((CharSequence)this.keywords)) {
                return this.keywordsList;
            }
            String[] split = this.keywords.split("\\|");
            this.keywordsList.addAll(Arrays.asList(split));
        }
        return this.keywordsList;
    }

    public List<String> getNoKeywordsList() {
        if (this.noKeywordsList == null) {
            this.noKeywordsList = new ArrayList<String>();
            if (StringUtils.isBlank((CharSequence)this.noKeywords)) {
                return this.noKeywordsList;
            }
            String[] split = this.noKeywords.split("\\|");
            this.noKeywordsList.addAll(Arrays.asList(split));
        }
        return this.noKeywordsList;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(this.hashCode());
        sb.append(", planName=").append(this.planName);
        sb.append(", classify=").append(this.classify);
        sb.append(", location=").append(this.location);
        sb.append(", weixinCrawlerTime=").append(this.weixinCrawlerTime);
        sb.append(", weiboCrawlerTime=").append(this.weiboCrawlerTime);
        sb.append(", keywords=").append(this.keywords);
        sb.append(", noKeywords=").append(this.noKeywords);
        sb.append(", maxArticleId=").append(this.maxArticleId);
        sb.append(", status=").append(this.status);
        sb.append(", serialVersionUID=").append(-2574179391709766308L);
        sb.append("]");
        return sb.toString();
    }

    public static List<List<String>> editKeywordGroup(String keywordStr) {
        String[] list_list = keywordStr.split("\\|");
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        if (list_list.length > 0) {
            for (String s : list_list) {
                String[] list_keyword = s.split("[,\uff0c&]");
                result.add(Arrays.asList(list_keyword));
            }
        }
        return result;
    }

    public boolean equalsPlan(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlanInfo planInfo = (PlanInfo)o;
        boolean bool = true;
        if (planInfo.getPlanId() != null) {
            bool = Objects.equals(this.getPlanId(), planInfo.getPlanId());
        }
        if (bool && StringUtils.isNotBlank((CharSequence)planInfo.planName)) {
            bool = Objects.equals(this.planName, planInfo.planName);
        }
        if (bool && StringUtils.isNotBlank((CharSequence)planInfo.classify)) {
            bool = Objects.equals(this.classify, planInfo.classify);
        }
        if (bool && StringUtils.isNotBlank((CharSequence)planInfo.keywords)) {
            bool = Objects.equals(this.keywords, planInfo.keywords);
        }
        if (bool && StringUtils.isNotBlank((CharSequence)planInfo.location)) {
            bool = Objects.equals(this.location, planInfo.location);
        }
        if (bool && StringUtils.isNotBlank((CharSequence)planInfo.noKeywords)) {
            bool = Objects.equals(this.noKeywords, planInfo.noKeywords);
        }
        return bool;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlanInfo planInfo = (PlanInfo)o;
        return Objects.equals(this.planName, planInfo.planName) && Objects.equals(this.classify, planInfo.classify) && Objects.equals(this.location, planInfo.location) && Objects.equals(this.weixinCrawlerTime, planInfo.weixinCrawlerTime) && Objects.equals(this.maxArticleId, planInfo.maxArticleId) && Objects.equals(this.weiboCrawlerTime, planInfo.weiboCrawlerTime) && Objects.equals(this.keywords, planInfo.keywords) && Objects.equals(this.keywordsList, planInfo.keywordsList) && Objects.equals(this.noKeywords, planInfo.noKeywords) && Objects.equals(this.noKeywordsList, planInfo.noKeywordsList) && Objects.equals(this.lastVisitTime, planInfo.lastVisitTime) && Objects.equals(this.lastExecutionTime, planInfo.lastExecutionTime) && Objects.equals(this.version, planInfo.version) && Objects.equals(this.status, planInfo.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.planName, this.classify, this.location, this.weixinCrawlerTime, this.maxArticleId, this.weiboCrawlerTime, this.keywords, this.keywordsList, this.noKeywords, this.noKeywordsList, this.lastVisitTime, this.lastExecutionTime, this.version, this.status);
    }

    public Long getPlanId() {
        return this.planId;
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getClassify() {
        return this.classify;
    }

    public String getLocation() {
        return this.location;
    }

    public Date getWeixinCrawlerTime() {
        return this.weixinCrawlerTime;
    }

    public Long getMaxArticleId() {
        return this.maxArticleId;
    }

    public Date getWeiboCrawlerTime() {
        return this.weiboCrawlerTime;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getNoKeywords() {
        return this.noKeywords;
    }

    public Long getLastVisitTime() {
        return this.lastVisitTime;
    }

    public Long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @JsonIgnore
    public void setWeixinCrawlerTime(Date weixinCrawlerTime) {
        this.weixinCrawlerTime = weixinCrawlerTime;
    }

    @JsonIgnore
    public void setMaxArticleId(Long maxArticleId) {
        this.maxArticleId = maxArticleId;
    }

    @JsonIgnore
    public void setWeiboCrawlerTime(Date weiboCrawlerTime) {
        this.weiboCrawlerTime = weiboCrawlerTime;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    @JsonIgnore
    public void setKeywordsList(List<String> keywordsList) {
        this.keywordsList = keywordsList;
    }

    public void setNoKeywords(String noKeywords) {
        this.noKeywords = noKeywords;
    }

    @JsonIgnore
    public void setNoKeywordsList(List<String> noKeywordsList) {
        this.noKeywordsList = noKeywordsList;
    }

    @JsonIgnore
    public void setLastVisitTime(Long lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    @JsonIgnore
    public void setLastExecutionTime(Long lastExecutionTime) {
        this.lastExecutionTime = lastExecutionTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @JsonIgnore
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public void setVersion(String version) {
        this.version = version;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public PlanInfo(Long planId, String planName, String classify, String location, Date weixinCrawlerTime, Long maxArticleId, Date weiboCrawlerTime, String keywords, List<String> keywordsList, String noKeywords, List<String> noKeywordsList, Long lastVisitTime, Long lastExecutionTime, Date creationTime, Date updateTime, String version, Integer status) {
        this.planId = planId;
        this.planName = planName;
        this.classify = classify;
        this.location = location;
        this.weixinCrawlerTime = weixinCrawlerTime;
        this.maxArticleId = maxArticleId;
        this.weiboCrawlerTime = weiboCrawlerTime;
        this.keywords = keywords;
        this.keywordsList = keywordsList;
        this.noKeywords = noKeywords;
        this.noKeywordsList = noKeywordsList;
        this.lastVisitTime = lastVisitTime;
        this.lastExecutionTime = lastExecutionTime;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
        this.version = version;
        this.status = status;
    }

    public PlanInfo() {
    }
}

