/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.backStageManagement.controller;

import com.chinamcloud.haihe.backStageManagement.pojo.Site;
import com.chinamcloud.haihe.backStageManagement.pojo.SiteInc;
import com.chinamcloud.haihe.backStageManagement.service.SiteQueryService;
import com.chinamcloud.haihe.common.CodeResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/station-query"})
public class SiteQueryController {
    @Autowired
    private SiteQueryService siteQueryService;
    @Value(value="${childList}")
    private String order;
    private static ObjectMapper mapper = new ObjectMapper();

    @GetMapping(value={"/getSiteType"}, consumes={"application/json;charset=utf-8"})
    public Object getType(@RequestParam(value="useChildrenNum", required=false) String useChildrenNum) {
        return this.siteQueryService.getType(useChildrenNum);
    }

    @PostMapping(value={"/getMergeType"}, consumes={"application/json;charset=utf-8"})
    public Object getMergeClassify(@RequestBody List<String> params) {
        return this.siteQueryService.getMergeClassify(params);
    }

    @GetMapping(value={"/getSiteLevel"}, consumes={"application/json;charset=utf-8"})
    public Object getSiteLevel(@RequestParam(value="useChildrenNum", required=false) String useChildrenNum) {
        try {
            List readValue = (List)mapper.readValue(this.order, List.class);
            if ("true".equals(useChildrenNum)) {
                this.siteQueryService.getSiteNumByMapData(readValue, "Level");
            }
            return new CodeResult<List>(CodeResult.Code.SUCCESS, readValue);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new CodeResult<List>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
        }
    }

    @PostMapping(value={"/getClassify"}, consumes={"application/json;charset=utf-8"})
    public Object getClassify(@RequestBody SiteInc site) {
        return this.siteQueryService.getClassify(site.getType(), site.isUseChildrenNum());
    }

    @PostMapping(value={"/getSiteTree"}, consumes={"application/json;charset=utf-8"})
    public Object getSiteTree(@RequestBody SiteInc site) {
        return this.siteQueryService.getSiteTree(site);
    }

    @PostMapping(value={"/getTree"}, consumes={"application/json;charset=utf-8"})
    public Object getTree(@RequestBody SiteInc site) {
        return this.siteQueryService.getTree(site);
    }

    @PostMapping(value={"/getSiteHead"}, consumes={"application/json;charset=utf-8"})
    public Object getSiteHead(@RequestBody SiteInc site) {
        return this.siteQueryService.getSiteHead(site);
    }

    @PostMapping(value={"/getDetailsPageSite"}, consumes={"application/json;charset=utf-8"})
    public Object getDetailsPageSite(@RequestBody SiteInc siteInc) {
        return this.siteQueryService.getDetailsPageSite(siteInc);
    }

    @PostMapping(value={"/getChildrenNum"}, consumes={"application/json;charset=utf-8"})
    public Object getChildrenNum(@RequestBody List<Site> sites) {
        this.siteQueryService.getChildrenNum(sites, new SiteInc());
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, sites);
    }

    @PostMapping(value={"/getPrepareCrawlSite"}, consumes={"application/json;charset=utf-8"})
    public Object getPrepareCrawlSite(@RequestBody Site site) throws InterruptedException {
        return this.siteQueryService.getPrepareCrawlSite(site);
    }

    @PostMapping(value={"/getSiteListBySiteIds"}, consumes={"application/json;charset=utf-8"})
    public Object getSiteListBySiteIds(@RequestBody Map<String, Set<Integer>> map) {
        Set<Integer> sites = map.get("siteIds");
        return this.siteQueryService.getSiteByIds(sites);
    }
}

